/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.isocaching;

import com.ami.kvm.isocaching.CacheManager;
import com.ami.kvm.isocaching.ISOReader;
import com.ami.kvm.isocaching.RequestHandler;
import com.ami.kvm.isocaching.SectorBank;
import com.ami.kvm.jviewer.Debug;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.util.LinkedList;

public class ReadAheadCache
extends Thread {
    public static final int MAX_CACHE_SIZE = 256;
    public static final int MAX_BANK_SIZE = 64;
    private LinkedList<SectorBank> sectorDataCache = null;
    private RequestHandler requestHandler = null;
    private CacheManager cacheManager = null;
    private ISOReader isoReader = null;
    private RandomAccessFile imageFile = null;
    private boolean running = false;
    private boolean cacheLocked = false;
    private boolean fileReadWait = false;
    private byte[] sectorData = null;
    private final Object cacheSync = new Object();
    private final Object readSync = new Object();
    private final Object cacheLock = new Object();
    private final Object fileLock = new Object();
    private final Object reqSync = new Object();
    private int numSectors;
    private long startingSector;

    public ReadAheadCache(RandomAccessFile randomAccessFile) {
        this.imageFile = randomAccessFile;
        if (this.getSectorDataCache() == null) {
            this.setSectorDataCache(new LinkedList<SectorBank>());
        }
        if (this.requestHandler == null) {
            this.requestHandler = new RequestHandler(this);
            this.requestHandler.startThread();
            this.requestHandler.setName("RequestHandler");
        }
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager(this);
            this.cacheManager.startThread();
            this.cacheManager.setName("CacheManager");
        }
        this.isoReader = new ISOReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            Object object = this.cacheSync;
            synchronized (object) {
                try {
                    this.sectorData = this.readSectorData();
                    Object object2 = this.readSync;
                    synchronized (object2) {
                        this.readSync.notifyAll();
                    }
                    this.cacheSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    Debug.out.println(interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readSectorData() {
        Object object;
        byte[] byArray = null;
        int n = 2048 * this.numSectors;
        long l = this.getSectorKey(this.startingSector);
        int n2 = (int)(2048L * (this.startingSector - l));
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (l >= 0L) {
            if (!this.isCacheLocked()) {
                block31: {
                    object = this.getSectorBank(l);
                    byArray = new byte[n];
                    if (this.startingSector + (long)this.numSectors > l + 64L) {
                        int n3 = (int)(this.startingSector + (long)this.numSectors - (l + 64L));
                        int n4 = (int)(l + 64L - this.startingSector);
                        long l2 = this.startingSector + (long)n4;
                        int n5 = 2048 * n4;
                        int n6 = 2048 * n3;
                        byte[] byArray4 = ((SectorBank)object).getSectorData();
                        byArray2 = new byte[n5];
                        byArray3 = new byte[n6];
                        if (byArray4 != null) {
                            if (byArray4.length >= n2 + byArray2.length) {
                                System.arraycopy(byArray4, n2, byArray2, 0, byArray2.length);
                                this.rearrangeSectorBank((SectorBank)object);
                            } else {
                                byArray2 = null;
                            }
                        }
                        if ((l = this.getSectorKey(l2)) >= 0L) {
                            n2 = (int)(2048L * (l2 - l));
                            try {
                                object = this.getSectorBank(l);
                                byte[] byArray5 = this.getSectorBank(l).getSectorData();
                                if (byArray5.length >= n2 + byArray3.length) {
                                    System.arraycopy(byArray5, n2, byArray3, 0, byArray3.length);
                                    this.rearrangeSectorBank((SectorBank)object);
                                    break block31;
                                }
                                byArray3 = null;
                            }
                            catch (NullPointerException nullPointerException) {
                                Debug.out.println(nullPointerException);
                                byArray3 = null;
                            }
                            catch (BufferUnderflowException bufferUnderflowException) {
                                byArray3 = null;
                                Debug.out.println(bufferUnderflowException);
                            }
                        } else {
                            byArray3 = null;
                        }
                    }
                }
                if (byArray2 != null && byArray3 != null) {
                    System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
                } else {
                    l = this.getSectorKey(this.startingSector);
                    if (l >= 0L) {
                        byte[] byArray6 = null;
                        try {
                            object = this.getSectorBank(l);
                            byArray6 = ((SectorBank)object).getSectorData();
                        }
                        catch (NullPointerException nullPointerException) {
                            byArray6 = null;
                            Debug.out.println(nullPointerException);
                        }
                        if (byArray6 != null) {
                            if (byArray6.length >= n2 + n) {
                                try {
                                    System.arraycopy(byArray6, n2, byArray, 0, n);
                                    this.rearrangeSectorBank((SectorBank)object);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    Debug.out.println(arrayIndexOutOfBoundsException);
                                    byArray = null;
                                }
                                catch (Exception exception) {
                                    Debug.out.println(exception);
                                    byArray = null;
                                }
                            } else {
                                byArray = null;
                            }
                        } else {
                            byArray = null;
                        }
                    }
                }
            } else {
                byArray = null;
            }
        }
        if (byArray == null) {
            try {
                this.getRequestHandler().setMissingBankInfo(this.startingSector / 64L * 64L);
                this.getRequestHandler().setSectorMiss(true);
                byArray = new byte[n];
                byArray = this.readFromFile(this.startingSector, this.numSectors);
            }
            catch (IOException iOException) {
                byArray = null;
                Debug.out.println(iOException);
            }
            object = this.getReqSync();
            synchronized (object) {
                this.getReqSync().notifyAll();
            }
        }
        return byArray;
    }

    public byte[] getSectorData() {
        return this.sectorData;
    }

    private long getSectorKey(long l) {
        long l2 = l / 64L * 64L;
        if (this.getSectorBank(l2) == null) {
            l2 = -1L;
        }
        return l2;
    }

    public boolean addToCache(byte[] byArray, long l) {
        boolean bl = false;
        if (this.getSectorDataCache().size() <= 256 && this.getSectorBank(l) == null) {
            SectorBank sectorBank = new SectorBank();
            sectorBank.setSectorKey(l);
            sectorBank.setSectorData(byArray);
            this.getSectorDataCache().addFirst(sectorBank);
            bl = true;
        }
        return bl;
    }

    public SectorBank getSectorBank(long l) {
        SectorBank sectorBank = null;
        try {
            for (int i = 0; i < this.getSectorDataCache().size(); ++i) {
                SectorBank sectorBank2 = this.getSectorDataCache().get(i);
                if (sectorBank2.getSectorKey() != l) continue;
                sectorBank = sectorBank2;
                break;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            sectorBank = null;
        }
        return sectorBank;
    }

    public void rearrangeSectorBank(SectorBank sectorBank) {
        int n;
        if (sectorBank != null && (n = this.getSectorDataCache().indexOf(sectorBank)) >= 0 && n < this.getSectorDataCache().size()) {
            try {
                SectorBank sectorBank2 = this.getSectorDataCache().remove(n);
                this.getSectorDataCache().addFirst(sectorBank2);
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromFile(long l, int n) throws IOException {
        byte[] byArray = new byte[2048 * n];
        if (this.imageFile != null) {
            this.fileReadWait = true;
            Object object = this.fileLock;
            synchronized (object) {
                if (this.isoReader == null) {
                    this.isoReader = new ISOReader();
                }
                byArray = this.isoReader.readSectorData(this.imageFile, l, n);
                this.fileReadWait = false;
                this.fileLock.notifyAll();
            }
        }
        return byArray;
    }

    public LinkedList<SectorBank> getSectorDataCache() {
        return this.sectorDataCache;
    }

    public void setSectorDataCache(LinkedList<SectorBank> linkedList) {
        this.sectorDataCache = linkedList;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void startThread() {
        this.running = true;
        this.start();
    }

    public void stopThread() {
        this.running = false;
    }

    public Object getCacheSync() {
        return this.cacheSync;
    }

    public Object getReadSync() {
        return this.readSync;
    }

    public void setSectorRequest(long l, int n) {
        this.startingSector = l;
        this.numSectors = n;
    }

    public boolean isCacheLocked() {
        return this.cacheLocked;
    }

    public void setCacheLocked(boolean bl) {
        this.cacheLocked = bl;
    }

    public Object getCacheLock() {
        return this.cacheLock;
    }

    public Object getFileLock() {
        return this.fileLock;
    }

    public boolean isFileReadWait() {
        return this.fileReadWait;
    }

    public Object getReqSync() {
        return this.reqSync;
    }
}

