/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoDialog {
    public static final int WAIT_DIALOG = 0;
    public static final int INFORMATION_DIALOG = 1;
    public static final int ERROR_DIALOG = 2;
    public static final int CONFIRMATION_DIALOG = 3;
    public static final int UNDECORATED_DIALOG = 4;
    public static final int MODELESS_WAIT_DIALOG = 5;
    public static final int HOST_KBD_LANG = 0;
    public static final long ONE_SEC = 1000L;
    public static final long DISPLAY_DURATION = 5000L;
    private JDialog infoDialog;
    private static InfoDialog undecDialog;
    private String infoText = null;
    private long displayDuration = 5000L;
    private WaitThread waitThread;
    private int dialogType = 0;
    private String title = null;
    private JFrame ownerFrame = null;
    private JDialog ownerDialog = null;
    private int type = 0;
    private JLabel durationMsgArea = null;

    private JDialog createInfoDialog() {
        try {
            int n = 0;
            int n2 = 0;
            Window window = null;
            if (this.ownerFrame != null && this.ownerFrame.isShowing()) {
                this.infoDialog = new JDialog(this.ownerFrame, this.title, false);
                window = this.ownerFrame;
            } else if (this.ownerDialog != null && this.ownerDialog.isShowing()) {
                this.infoDialog = new JDialog(this.ownerDialog, this.title, false);
                window = this.ownerDialog;
            } else {
                this.infoDialog = new JDialog(JViewer.getMainFrame(), this.title, false);
                window = JViewer.getMainFrame();
            }
            if (this.dialogType == 0) {
                this.infoDialog.setMinimumSize(new Dimension(240, 80));
                this.infoDialog.setModal(true);
                this.infoDialog.setUndecorated(true);
            } else if (this.dialogType == 4 || this.dialogType == 5) {
                this.infoDialog.setMinimumSize(new Dimension(240, 80));
                this.infoDialog.setModal(false);
                this.infoDialog.setUndecorated(true);
            } else {
                this.infoDialog.setMinimumSize(new Dimension(240, 120));
                this.infoDialog.setModal(false);
            }
            this.infoDialog.add(this.getinfoPane());
            this.infoDialog.pack();
            this.infoDialog.setResizable(false);
            this.infoDialog.requestFocus();
            n = (window.getLocationOnScreen().x + window.getWidth() - this.infoDialog.getWidth()) / 2;
            n2 = (window.getLocationOnScreen().y + window.getHeight() - this.infoDialog.getHeight()) / 2;
            this.infoDialog.setLocation(n, n2);
            this.infoDialog.setLocationRelativeTo(window);
            this.infoDialog.addWindowListener(new DiaologWindowListener());
            this.waitThread = new WaitThread();
            this.infoDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            Debug.out.println(throwable);
        }
        return this.infoDialog;
    }

    private JPanel getMessagePane() {
        JPanel jPanel = null;
        JLabel jLabel = null;
        String string = "&nbsp;&nbsp;&nbsp;";
        String string2 = "<p style=\"padding-top:5;\">";
        String string3 = "</p>";
        try {
            if (this.infoText.contains("\n")) {
                this.infoText = this.infoText.replace("\n", string + "<br>" + string2 + string);
            }
            jLabel = new JLabel("<html>" + string2 + string + this.infoText + string + string3 + "</html>");
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            jLabel.setVerticalTextPosition(0);
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "Center");
            if (this.dialogType == 3 || this.dialogType == 4) {
                this.durationMsgArea = new JLabel();
                this.durationMsgArea.setHorizontalAlignment(0);
                this.durationMsgArea.setVerticalAlignment(0);
                jPanel.add((Component)this.durationMsgArea, "South");
            }
        }
        catch (Throwable throwable) {
            Debug.out.println(throwable);
        }
        return jPanel;
    }

    public JLabel getDurationMsgArea() {
        return this.durationMsgArea;
    }

    private JPanel getOKButton() {
        JPanel jPanel = null;
        JButton jButton = null;
        if (jButton == null) {
            jButton = new JButton(LocaleStrings.getString("A_3_GLOBAL"));
            jButton.setSize(100, 25);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InfoDialog.this.closeDialog();
                }
            });
            jButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        InfoDialog.this.closeDialog();
                    }
                }
            });
            jPanel = new JPanel();
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(jButton);
            jPanel.add(Box.createHorizontalGlue());
        }
        return jPanel;
    }

    private JPanel getYesNoButton() {
        JPanel jPanel = null;
        JButton jButton = null;
        JButton jButton2 = null;
        if (jButton == null) {
            jButton = new JButton(LocaleStrings.getString("A_7_GLOBAL"));
            jButton.setSize(100, 25);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InfoDialog.this.closeDialog();
                    JViewerApp.getInstance().confirmationDialogResponse(InfoDialog.this.type);
                }
            });
            jButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        InfoDialog.this.closeDialog();
                        JViewerApp.getInstance().confirmationDialogResponse(InfoDialog.this.type);
                    }
                }
            });
        }
        if (jButton2 == null) {
            jButton2 = new JButton(LocaleStrings.getString("A_8_GLOBAL"));
            jButton2.setSize(100, 25);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InfoDialog.this.closeDialog();
                }
            });
            jButton2.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        InfoDialog.this.closeDialog();
                    }
                }
            });
        }
        jPanel = new JPanel();
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(Box.createVerticalStrut(40));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JPanel getinfoPane() {
        JPanel jPanel = null;
        try {
            jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.getMessagePane(), "Center");
            switch (this.dialogType) {
                case 1: 
                case 2: {
                    jPanel.add((Component)this.getIconPanel(), "Before");
                    jPanel.add((Component)this.getOKButton(), "South");
                    break;
                }
                case 0: 
                case 4: 
                case 5: {
                    jPanel.setBorder(BorderFactory.createEtchedBorder(Color.BLACK, Color.GRAY));
                    break;
                }
                case 3: {
                    jPanel.add((Component)this.getIconPanel(), "Before");
                    jPanel.add((Component)this.getYesNoButton(), "South");
                }
            }
        }
        catch (Throwable throwable) {
            Debug.out.println(throwable);
        }
        return jPanel;
    }

    private JPanel getIconPanel() {
        JPanel jPanel = null;
        JLabel jLabel = null;
        String string = null;
        URL uRL = null;
        try {
            jPanel = new JPanel();
            jLabel = new JLabel();
            switch (this.dialogType) {
                case 1: {
                    string = "res/information.png";
                    break;
                }
                case 2: {
                    string = "res/error.png";
                    break;
                }
                default: {
                    string = "res/information.png";
                }
            }
            if (string != null) {
                uRL = JViewer.class.getResource(string);
            }
            if (uRL != null) {
                jLabel.setIcon(new ImageIcon(uRL));
            }
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            jPanel.add(jLabel);
        }
        catch (Throwable throwable) {
            Debug.out.println(throwable);
        }
        return jPanel;
    }

    private void initialize() {
        try {
            this.createInfoDialog();
        }
        catch (Throwable throwable) {
            Debug.out.println(throwable);
        }
    }

    public static void showDialog(Component component, String string, long l) {
        InfoDialog infoDialog = new InfoDialog();
        InfoDialog.setOwner(infoDialog, component);
        infoDialog.infoText = string;
        infoDialog.displayDuration = l;
        infoDialog.dialogType = 0;
        infoDialog.initialize();
    }

    public static InfoDialog showDialog(Component component, String string, long l, int n) {
        InfoDialog infoDialog = new InfoDialog();
        InfoDialog.setOwner(infoDialog, component);
        infoDialog.infoText = string;
        infoDialog.displayDuration = l;
        infoDialog.dialogType = n;
        infoDialog.initialize();
        return infoDialog;
    }

    public static void showDialog(Component component, String string, String string2, int n) {
        InfoDialog infoDialog = new InfoDialog();
        InfoDialog.setOwner(infoDialog, component);
        infoDialog.infoText = string;
        infoDialog.dialogType = n;
        infoDialog.displayDuration = 0L;
        infoDialog.title = string2;
        infoDialog.initialize();
    }

    public static void showDialog(Component component, String string, String string2, int n, long l, int n2) {
        InfoDialog infoDialog = new InfoDialog();
        InfoDialog.setOwner(infoDialog, component);
        infoDialog.infoText = string;
        infoDialog.dialogType = n;
        infoDialog.displayDuration = l;
        infoDialog.title = string2;
        infoDialog.type = n2;
        infoDialog.initialize();
    }

    public static void showDialog(Component component, String string, int n, int n2) {
        if (undecDialog == null) {
            undecDialog = new InfoDialog();
            InfoDialog.setOwner(undecDialog, component);
            InfoDialog.undecDialog.infoText = string;
            InfoDialog.undecDialog.dialogType = n;
            InfoDialog.undecDialog.displayDuration = n2;
            undecDialog.initialize();
        }
    }

    public static void undecDialogClose() {
        if (undecDialog != null) {
            undecDialog.closeDialog();
            undecDialog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDialog() {
        if (this.waitThread != null) {
            if (this.dialogType == 3 || this.dialogType == 4) {
                this.displayDuration = 0L;
            } else {
                WaitThread waitThread = this.waitThread;
                synchronized (waitThread) {
                    this.waitThread.notify();
                }
            }
            this.waitThread = null;
        } else if (this.infoDialog != null) {
            this.infoDialog.dispose();
            this.infoDialog = null;
        }
    }

    public static void setOwner(InfoDialog infoDialog, Component component) {
        try {
            if (component == null) {
                return;
            }
            if (component.getClass().equals(Class.forName("javax.swing.JFrame")) || component.getClass().getGenericSuperclass().equals(Class.forName("javax.swing.JFrame"))) {
                infoDialog.ownerFrame = (JFrame)component;
            } else if (component.getClass().equals(Class.forName("javax.swing.JDialog")) || component.getClass().getGenericSuperclass().equals(Class.forName("javax.swing.JDialog"))) {
                infoDialog.ownerDialog = (JDialog)component;
            } else {
                InfoDialog.setOwner(infoDialog, component.getParent());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.out.println(classNotFoundException);
        }
    }

    public static InfoDialog getUndecDialog() {
        return undecDialog;
    }

    class DiaologWindowListener
    extends WindowAdapter {
        DiaologWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            InfoDialog.this.closeDialog();
        }
    }

    class WaitThread
    extends Thread {
        int wokeup = 0;

        public WaitThread() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (InfoDialog.this.infoDialog == null) {
                return;
            }
            if (InfoDialog.this.dialogType == 3 || InfoDialog.this.dialogType == 4) {
                do {
                    try {
                        Object object;
                        if (this.wokeup == 0) {
                            object = InfoDialog.this.waitThread;
                            synchronized (object) {
                                this.wokeup = 1;
                            }
                        }
                        if (InfoDialog.this.dialogType == 3) {
                            InfoDialog.this.durationMsgArea.setText(LocaleStrings.getString("M_2_ID") + new Integer((int)(InfoDialog.this.displayDuration / 1000L)).toString() + LocaleStrings.getString("M_3_ID"));
                        } else if (InfoDialog.this.dialogType == 4) {
                            InfoDialog.this.durationMsgArea.setText(JViewerApp.getInstance().getCurrentRetryCount() + LocaleStrings.getString("M_4_ID") + " ( " + new Integer((int)(InfoDialog.this.displayDuration / 1000L)).toString() + LocaleStrings.getString("M_5_ID") + " )");
                        }
                        InfoDialog.this.durationMsgArea.repaint();
                        WaitThread.sleep(1000L);
                        InfoDialog.this.displayDuration = InfoDialog.this.displayDuration - 1000L;
                        if (InfoDialog.this.dialogType != 4) continue;
                        if (JViewerApp.getInstance().getCurrentRetryCount() < JViewer.getRetryCount() && InfoDialog.this.displayDuration == 0L) {
                            InfoDialog.this.displayDuration = JViewer.getRetryInterval();
                            InfoDialog.this.durationMsgArea.setText(JViewerApp.getInstance().getCurrentRetryCount() + 1 + LocaleStrings.getString("M_4_ID"));
                            object = JViewerApp.getInstance().getRetryCountSync();
                            synchronized (object) {
                                JViewerApp.getInstance().getRetryCountSync().notify();
                            }
                            WaitThread.sleep(1000L);
                        }
                        if (JViewerApp.getInstance().getCurrentRetryCount() < JViewer.getRetryCount()) continue;
                        InfoDialog.this.displayDuration = 0L;
                    }
                    catch (InterruptedException interruptedException) {
                        Debug.out.println(interruptedException);
                    }
                } while (InfoDialog.this.displayDuration > 0L);
            } else {
                try {
                    WaitThread waitThread = InfoDialog.this.waitThread;
                    synchronized (waitThread) {
                        InfoDialog.this.waitThread.wait(InfoDialog.this.displayDuration);
                        InfoDialog.this.displayDuration = 0L;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Debug.out.println(interruptedException);
                }
            }
            if (InfoDialog.this.infoDialog != null && InfoDialog.this.displayDuration <= 0L) {
                if (InfoDialog.this.dialogType == 5 && JViewerApp.getInstance().getHidInitDialog() != null) {
                    JViewerApp.getInstance().setHidInitDialog(null);
                    JViewerApp.getInstance().getRCView().addKMListeners();
                }
                InfoDialog.this.infoDialog.dispose();
                InfoDialog.this.infoDialog = null;
            }
        }
    }
}

