/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.FSMenuBar;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMShareDialog;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.vmedia.VMApp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public abstract class JVFrame
extends JInternalFrame {
    protected JScrollPane m_viewSP;
    protected static String m_serverIP;
    private FSMenuBar m_fsMenuBr = new FSMenuBar();
    public JDialog videoStopError = null;
    private JLabel confirmationLabel = null;

    public JVFrame() {
        super(LocaleStrings.getString("C_1_JVF"), true, true, true, true);
    }

    public abstract JVMenu getMenu();

    public abstract void setStatus(String var1);

    public abstract void resetStatus();

    public abstract void exitApp();

    public abstract void setWndLabel(String var1);

    public abstract void refreshTitle();

    public static void setServerIP(byte[] byArray, int n) {
        try {
            m_serverIP = byArray == null && n == JViewerApp.REDIR_PAUSING ? LocaleStrings.getString("C_2_JVF") : (byArray == null && n == JViewerApp.REDIR_STOPPING ? LocaleStrings.getString("C_3_JVF") : (byArray == null && JViewer.isplayerapp() ? LocaleStrings.getString("C_4_JVF") : (byArray == null && JViewer.isdownloadapp() ? LocaleStrings.getString("C_5_JVF") : InetAddress.getByAddress(byArray).getHostAddress())));
        }
        catch (UnknownHostException unknownHostException) {
            m_serverIP = LocaleStrings.getString("C_6_JVF");
            Debug.out.println(unknownHostException);
        }
    }

    public static String getServerIP() {
        if (m_serverIP != null && !m_serverIP.equalsIgnoreCase(new String(LocaleStrings.getString("C_6_JVF")))) {
            return m_serverIP;
        }
        return null;
    }

    public void attachView() {
        this.m_viewSP = new JScrollPane(JViewerApp.getInstance().getRCView());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (JViewerApp.getInstance().isM_wndMode()) {
            this.m_viewSP.getHorizontalScrollBar().setUnitIncrement(10);
            this.m_viewSP.getVerticalScrollBar().setUnitIncrement(10);
            JViewerApp.getInstance().getMainWindow().getContentPane().add(this.m_viewSP);
            this.getContentPane().setMaximumSize(dimension);
            if (JViewer.isStandalone()) {
                JViewer.getMainFrame().setExtendedState(6);
            }
            this.setVisible(true);
        }
        if (!JViewerApp.getInstance().isM_wndMode()) {
            if (JViewerApp.getInstance().getSocframeHdr().getresX() == dimension.width) {
                this.m_viewSP.setHorizontalScrollBarPolicy(31);
            } else {
                this.m_viewSP.setHorizontalScrollBarPolicy(30);
            }
            if (JViewerApp.getInstance().getSocframeHdr().getresY() == dimension.height) {
                this.m_viewSP.setVerticalScrollBarPolicy(21);
            } else {
                this.m_viewSP.setVerticalScrollBarPolicy(20);
            }
            JViewerApp.getInstance().getMainWindow().getContentPane().add(this.m_viewSP);
            if (JViewer.isStandalone()) {
                JViewer.getMainFrame().setExtendedState(6);
            }
            this.setVisible(true);
        }
    }

    public static void setUndecorated(boolean bl, JInternalFrame jInternalFrame) {
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)jInternalFrame.getUI();
        if (bl) {
            jInternalFrame.putClientProperty("titlePane", basicInternalFrameUI.getNorthPane());
            jInternalFrame.putClientProperty("border", jInternalFrame.getBorder());
            basicInternalFrameUI.setNorthPane(null);
            jInternalFrame.setBorder(null);
        }
    }

    public void detachView() {
        this.m_fsMenuBr.cancelTimer();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            Debug.out.println(interruptedException);
        }
        this.getContentPane().remove(this.m_viewSP);
        this.dispose();
    }

    public boolean windowClosed() {
        if (JViewer.isdownloadapp() || JViewer.isplayerapp()) {
            boolean bl = true;
            if (JViewerApp.getInstance().getConnectionDialog() != null) {
                bl = JViewerApp.getInstance().getConnectionDialog().isWebLogIn();
            }
            if (bl) {
                JViewerApp.getInstance().getVideorecordapp().lockVideoFile(false);
            }
            JViewerApp.getInstance().getVideorecordapp().Ondeletetmpfile();
        }
        if (JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED && (JViewer.isjviewerapp() || JViewer.isStandAloneApp()) && KVMShareDialog.isMasterSession && JViewerApp.getInstance().getKVMShareDialog() != null && JViewerApp.getInstance().getResponseDialogTable() != null && !JViewerApp.getInstance().getResponseDialogTable().isEmpty() && JViewerApp.getInstance().getKVMShareDialog().getDialogType() != 1) {
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), LocaleStrings.getString("C_14_JVF"), LocaleStrings.getString("C_15_JVF"), 1);
            return false;
        }
        if ((JViewer.isjviewerapp() || JViewer.isStandAloneApp()) && !this.stopVMediaRedirection(LocaleStrings.getString("C_7_JVF"))) {
            if (JViewer.isKVMReconnectEnabled()) {
                JViewerApp.getInstance().setSessionLive(true);
            }
            return false;
        }
        if (JViewerApp.getInstance().getM_videorecord() != null) {
            if (VideoRecord.Recording_Started) {
                JViewerApp.getInstance().getM_videorecord().OnVideoRecordStop();
            }
            if (VideoRecord.Record_Processing) {
                if (JViewer.isdownloadapp()) {
                    JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
                }
                this.showVideoStopError();
                while (VideoRecord.Record_Processing) {
                    this.videoStopError.setVisible(true);
                }
            }
        }
        if ((JViewer.isjviewerapp() || JViewer.isStandAloneApp()) && JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED) {
            JViewerApp.getInstance().OnSelectKVMMaster();
        }
        if ((JViewer.isjviewerapp() || JViewer.isStandAloneApp()) && (JViewer.getOEMFeatureStatus() & 0x200L) != 512L) {
            JViewerApp.getInstance().setClientKeyboardLEDStatus(JViewerApp.getInstance().getInitClientLEDStatus());
        }
        try {
            JViewerApp.getInstance().OnVideoStopRedirection();
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        if (JViewer.isStandalone()) {
            if (!(JViewer.isWebPreviewer() || JViewer.isBSODViewer() || JViewerApp.getInstance().getKVMClient().isStopSignalRecieved())) {
                JViewer.exit(0);
            }
        } else {
            if (Debug.MODE == 0) {
                Debug.out.closeLog();
            }
            JViewerApp.getInstance().getMainWindow().dispose();
        }
        return true;
    }

    public void generalErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this, string2, string, 0);
    }

    public JScrollPane getM_viewSP() {
        return this.m_viewSP;
    }

    public void setM_viewSP(JScrollPane jScrollPane) {
        this.m_viewSP = jScrollPane;
    }

    private void showVideoStopError() {
        if (this.videoStopError == null) {
            JFrame jFrame = JViewer.getMainFrame();
            this.videoStopError = new JDialog((Frame)jFrame, true);
            this.videoStopError.setUndecorated(true);
            this.videoStopError.setSize(550, 100);
            this.videoStopError.setLocationRelativeTo(jFrame);
            this.videoStopError.setTitle(LocaleStrings.getString("C_11_JVF"));
            this.videoStopError.add(this.getVideoStopError());
            this.videoStopError.setVisible(true);
        }
    }

    private JPanel getVideoStopError() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 2, 30));
        jPanel.setSize(550, 100);
        JLabel jLabel = new JLabel(LocaleStrings.getString("C_12_JVF") + JViewer.getTitle() + LocaleStrings.getString("C_13_JVF"));
        jPanel.add(jLabel);
        return jPanel;
    }

    public JLabel getConfirmationLabel() {
        return this.confirmationLabel;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (JViewer.isStandalone()) {
            JVFrame.setUndecorated(true, this);
        }
        super.paintComponent(graphics);
    }

    public boolean stopVMediaRedirection(String string) {
        if (JViewerApp.getInstance().GetRedirectionState() != JViewerApp.REDIR_STOPPED && string != null && (JViewerApp.getInstance().IsCDROMRedirRunning() || JViewerApp.getInstance().IsHarddiskRedirRunning())) {
            if (JViewer.getMediaLicenseStatus() != 1) {
                InfoDialog.showDialog((Component)JViewer.getMainFrame(), string, LocaleStrings.getString("A_6_GLOBAL"), 1);
            } else {
                this.confirmationLabel = new JLabel(string);
                UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
                int n = JOptionPane.showConfirmDialog(JViewer.getMainFrame(), this.confirmationLabel, LocaleStrings.getString("C_8_JVF"), 0);
                if (n == -1) {
                    return false;
                }
                if (n == 1) {
                    Debug.out.println("Returning false\n");
                    return false;
                }
            }
        }
        this.onStopVMediaRedirection(0);
        return true;
    }

    public void onStopVMediaRedirection(int n) {
        int n2 = 0;
        int n3 = 0;
        n2 = VMApp.getInstance().getNumCD();
        n3 = VMApp.getInstance().getNumHD();
        int n4 = JViewerApp.getInstance().getCDPort();
        int n5 = JViewerApp.getInstance().getHDPort();
        boolean bl = JViewerApp.getInstance().isM_bVMUseSSL();
        String string = JViewerApp.getInstance().getSessionToken();
        if (n == 0 && JViewerApp.getInstance().getVMDialog() != null) {
            JViewerApp.getInstance().getVMDialog().disposeVMDialog();
        }
        try {
            String string2;
            int n6;
            for (n6 = 0; n6 < n2; ++n6) {
                if (VMApp.getInstance().getIUSBRedirSession().cdromSession[n6] == null) continue;
                if (n == 1) {
                    VMApp.getInstance().getIUSBRedirSession().cdromSession[n6].setCdReconnect(true);
                }
                VMApp.getInstance().getIUSBRedirSession().StopCDROMRedir(n6, 0);
                VMApp.getInstance().getIUSBRedirSession().updateCDToolbarButtonStatus(false);
                if (n != 1) continue;
                string2 = VMApp.getInstance().getIUSBRedirSession().cdromSession[n6].getSourceDrive();
                VMApp.getInstance().getIUSBRedirSession().cdromSession[n6].setCdReconnect(false);
                if (VMApp.getInstance().getIUSBRedirSession().cdromSession[n6].isCdImageRedirected()) {
                    VMApp.getInstance().getIUSBRedirSession().StartISORedir(string, n4, n6, bl, string2);
                    VMApp.getInstance().getIUSBRedirSession().cdromSession[n6].setCdImageRedirected(true);
                } else {
                    VMApp.getInstance().getIUSBRedirSession().StartCDROMRedir(string, n4, n6, bl, string2);
                    VMApp.getInstance().getIUSBRedirSession().cdromSession[n6].setCdImageRedirected(false);
                }
                VMApp.getInstance().getIUSBRedirSession().updateCDToolbarButtonStatus(true);
                VMApp.getVMPane().getDeviceControlPanel(0, n6).updateDeviceControlPanel();
            }
            for (n6 = 0; n6 < n3; ++n6) {
                byte by;
                if (VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6] == null) continue;
                if (n == 1) {
                    VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6].setHdReconnect(true);
                }
                VMApp.getInstance().getIUSBRedirSession().StopHarddiskRedir(n6, 0);
                VMApp.getInstance().getIUSBRedirSession().updateHDToolbarButtonStatus(false);
                if (n != 1) continue;
                string2 = VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6].getSourceDrive();
                VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6].setHdReconnect(false);
                if (VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6].isHdImageRedirected()) {
                    by = -128;
                    VMApp.getInstance().getIUSBRedirSession().StartharddiskImageRedir(string, n5, n6, bl, string2, by);
                    VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6].setHdImageRedirected(true);
                } else {
                    by = VMApp.getInstance().getIUSBRedirSession().getMediaType(string2);
                    VMApp.getInstance().getIUSBRedirSession().StartHarddiskRedir(string, n5, n6, bl, string2, by);
                    VMApp.getInstance().getIUSBRedirSession().hardDiskSession[n6].setHdImageRedirected(false);
                }
                VMApp.getInstance().getIUSBRedirSession().updateHDToolbarButtonStatus(true);
                VMApp.getVMPane().getDeviceControlPanel(2, n6).updateDeviceControlPanel();
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
    }
}

