/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class LocaleStrings {
    private static LocaleStrings localeStrings = new LocaleStrings();
    private ResourceBundle resourceBundle = null;
    private ResourceBundle resourceBundleSOC = null;
    private ResourceBundle resourceBundleOEM = null;
    private ResourceBundle prevresourceBundle = null;
    private ResourceBundle prevresourceBundleSOC = null;
    private ResourceBundle prevresourceBundleOEM = null;
    private ResourceBundle parentResourceBundle = ResourceBundle.getBundle("com.ami.kvm.jviewer.lang.Resources_EN");
    private ResourceBundle parentResourceBundleSOC = ResourceBundle.getBundle("com.ami.kvm.jviewer.soc.lang.SOCResources_EN");
    private ResourceBundle parentResourceBundleOEM = null;
    private String errorMsg = "";

    private LocaleStrings() {
        try {
            this.parentResourceBundleOEM = ResourceBundle.getBundle("com.ami.kvm.jviewer.oem.lang.OEMResources_EN");
        }
        catch (Exception exception) {
            this.parentResourceBundleOEM = null;
        }
        this.resourceBundle = this.parentResourceBundle;
        this.resourceBundleSOC = this.parentResourceBundleSOC;
        this.resourceBundleOEM = this.parentResourceBundleOEM;
        this.prevresourceBundle = this.resourceBundle;
        this.prevresourceBundleSOC = this.resourceBundleSOC;
        this.prevresourceBundleOEM = this.resourceBundleOEM;
    }

    public static void setLanguageID(String string) {
        if (string.length() == 0 || string.equals(null)) {
            return;
        }
        try {
            LocaleStrings.localeStrings.prevresourceBundle = LocaleStrings.localeStrings.resourceBundle;
            LocaleStrings.localeStrings.resourceBundle = ResourceBundle.getBundle("com.ami.kvm.jviewer.lang.Resources_" + string);
        }
        catch (MissingResourceException missingResourceException) {
            Debug.out.println(missingResourceException + LocaleStrings.getString("AC_2_LS"));
            LocaleStrings.localeStrings.resourceBundle = ResourceBundle.getBundle("com.ami.kvm.jviewer.lang.Resources_EN");
        }
        try {
            LocaleStrings.localeStrings.prevresourceBundleOEM = LocaleStrings.localeStrings.resourceBundleOEM;
            LocaleStrings.localeStrings.resourceBundleOEM = ResourceBundle.getBundle("com.ami.kvm.jviewer.oem.lang.OEMResources_" + string);
        }
        catch (MissingResourceException missingResourceException) {
            Debug.out.println(missingResourceException + LocaleStrings.getString("AC_2_LS"));
            LocaleStrings.localeStrings.resourceBundle = ResourceBundle.getBundle("com.ami.kvm.jviewer.oem.lang.Resources_EN");
            LocaleStrings.localeStrings.resourceBundleSOC = ResourceBundle.getBundle("com.ami.kvm.jviewer.soc.lang.SOCResources_EN");
            LocaleStrings.localeStrings.resourceBundleOEM = ResourceBundle.getBundle("com.ami.kvm.jviewer.oem.lang.OEMResources_EN");
            LocaleStrings.localeStrings.errorMsg = LocaleStrings.getString("AC_4_LS");
            JOptionPane.showMessageDialog(null, LocaleStrings.localeStrings.errorMsg, LocaleStrings.getString("AC_1_LS"), 0);
            JViewer.setLanguage("EN");
            JViewer.setDefaultLang(true);
        }
        try {
            LocaleStrings.localeStrings.prevresourceBundleSOC = LocaleStrings.localeStrings.resourceBundleSOC;
            LocaleStrings.localeStrings.resourceBundleSOC = ResourceBundle.getBundle("com.ami.kvm.jviewer.soc.lang.SOCResources_" + string);
        }
        catch (MissingResourceException missingResourceException) {
            Debug.out.println(missingResourceException + LocaleStrings.getString("AC_3_LS"));
            LocaleStrings.localeStrings.resourceBundleSOC = ResourceBundle.getBundle("com.ami.kvm.jviewer.soc.lang.SOCResources_EN");
        }
    }

    public static String getString(String string) {
        String string2 = LocaleStrings.getOEMString(string);
        if (string2 != null) {
            return string2;
        }
        if (LocaleStrings.containsKey(LocaleStrings.localeStrings.resourceBundle, string)) {
            return LocaleStrings.localeStrings.resourceBundle.getString(string);
        }
        String string3 = LocaleStrings.localeStrings.resourceBundle.toString();
        Debug.out.printError("The resource for the key " + string + " is missing in the resource bundle " + string3.substring(0, string3.indexOf(64)));
        if (LocaleStrings.containsKey(LocaleStrings.localeStrings.parentResourceBundle, string)) {
            return LocaleStrings.localeStrings.parentResourceBundle.getString(string);
        }
        string3 = LocaleStrings.localeStrings.parentResourceBundle.toString();
        Debug.out.printError("The resource for the key " + string + " is missing in the resource bundle " + string3.substring(0, string3.indexOf(64)));
        return null;
    }

    private static String convertResourceBundleToProperties(ResourceBundle resourceBundle, String string) {
        Properties properties = new Properties();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string.equalsIgnoreCase(resourceBundle.getString(string2))) continue;
            return string2;
        }
        return null;
    }

    public static String getStringKey(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                string2 = LocaleStrings.convertResourceBundleToProperties(LocaleStrings.localeStrings.prevresourceBundleOEM, string);
                if (string2 == null && (string2 = LocaleStrings.convertResourceBundleToProperties(LocaleStrings.localeStrings.prevresourceBundleSOC, string)) == null) {
                    string2 = LocaleStrings.convertResourceBundleToProperties(LocaleStrings.localeStrings.prevresourceBundle, string);
                }
            }
            catch (MissingResourceException missingResourceException) {
                Debug.out.println(missingResourceException);
                string2 = LocaleStrings.convertResourceBundleToProperties(LocaleStrings.localeStrings.parentResourceBundleOEM, string);
                if (string2 != null || (string2 = LocaleStrings.convertResourceBundleToProperties(LocaleStrings.localeStrings.parentResourceBundleSOC, string)) != null) break block3;
                string2 = LocaleStrings.convertResourceBundleToProperties(LocaleStrings.localeStrings.parentResourceBundle, string);
            }
        }
        return string2;
    }

    public static String getPreviousLocaleString(String string) {
        String string2 = null;
        string2 = LocaleStrings.localeStrings.prevresourceBundle.getString(string);
        return string2;
    }

    public static String getSOCString(String string) {
        String string2 = LocaleStrings.getOEMString(string);
        if (string2 == null) {
            if (LocaleStrings.containsKey(LocaleStrings.localeStrings.resourceBundleSOC, string)) {
                string2 = LocaleStrings.localeStrings.resourceBundleSOC.getString(string);
            } else {
                String string3 = LocaleStrings.localeStrings.resourceBundleSOC.toString();
                Debug.out.printError("The resource for the key " + string + " is missing in the resource bundle " + string3.substring(0, string3.indexOf(64)));
                if (LocaleStrings.containsKey(LocaleStrings.localeStrings.parentResourceBundleSOC, string)) {
                    string2 = LocaleStrings.localeStrings.parentResourceBundleSOC.getString(string);
                } else {
                    string3 = LocaleStrings.localeStrings.parentResourceBundleSOC.toString();
                    Debug.out.printError("The resource for the key " + string + " is missing in the resource bundle " + string3.substring(0, string3.indexOf(64)));
                    string2 = null;
                }
            }
        }
        return string2;
    }

    public static String getOEMString(String string) {
        if (LocaleStrings.localeStrings.resourceBundleOEM == null) {
            return null;
        }
        if (LocaleStrings.containsKey(LocaleStrings.localeStrings.resourceBundleOEM, string)) {
            return LocaleStrings.localeStrings.resourceBundleOEM.getString(string);
        }
        String string2 = LocaleStrings.localeStrings.resourceBundleOEM.toString();
        Debug.out.printError("The resource for the key " + string + " is missing in the resource bundle " + string2.substring(0, string2.indexOf(64)));
        if (LocaleStrings.containsKey(LocaleStrings.localeStrings.parentResourceBundleOEM, string)) {
            return LocaleStrings.localeStrings.parentResourceBundleOEM.getString(string);
        }
        string2 = LocaleStrings.localeStrings.parentResourceBundleOEM.toString();
        Debug.out.printError("The resource for the key " + string + " is missing in the resource bundle " + string2.substring(0, string2.indexOf(64)));
        return null;
    }

    private static boolean containsKey(ResourceBundle resourceBundle, String string) {
        boolean bl = false;
        if (resourceBundle == null || string == null) {
            return bl;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

