/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.communication.Connection;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.videorecord.URLProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.swing.JOptionPane;

public class SinglePortKVM {
    private String webSessionToken = null;
    private int secWebPort;
    private String tunnelHost = null;
    private int tunnelPort;
    private boolean m_bUseSSL = false;
    private URLProcessor urlProcessor;
    public OutputStream outStream;
    public InputStream inStream;
    public Socket httpsock;
    private String Service = null;
    public static final String VIDEO = "VIDEO";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public SSLSocket sslsock = null;
    public SSLContext context = null;
    public byte[] reply = new byte[200];

    public Socket getHttpsock() {
        return this.httpsock;
    }

    public void setHttpsock(Socket socket) {
        this.httpsock = socket;
    }

    public OutputStream getOutstream() {
        return this.outStream;
    }

    public void setOutstream(OutputStream outputStream) {
        this.outStream = outputStream;
    }

    public InputStream getInstream() {
        return this.inStream;
    }

    public void setInstream(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public SSLSocket getSSLsock() {
        return this.sslsock;
    }

    public void setSSLsock(SSLSocket sSLSocket) {
        this.sslsock = sSLSocket;
    }

    public SinglePortKVM(String string, int n, int n2, boolean bl) {
        this.tunnelHost = string;
        this.tunnelPort = n;
        this.secWebPort = n2;
        this.m_bUseSSL = bl;
    }

    public int startConnect() {
        if (0 > this.setHTTPConnect(VIDEO)) {
            Debug.out.println(LocaleStrings.getString("AE_10_SPKVM"));
            return -1;
        }
        return 0;
    }

    public int getWebSessionToken() {
        int n;
        block9: {
            JViewerApp.getInstance().setM_webSession_token(null);
            this.urlProcessor = new URLProcessor(null, 1);
            n = -1;
            String string = null;
            if (JViewer.isRestService()) {
                n = this.urlProcessor.restProcessRequest(JViewer.getProtocol() + "://" + this.tunnelHost + ":" + this.secWebPort + "/api/session?username=" + JViewer.getUsername() + "&password=" + JViewer.getPassword());
                try {
                    if (n == 0) {
                        this.webSessionToken = this.urlProcessor.getValue("Set-Cookie: ", ';');
                        JViewerApp.getInstance().setM_webSession_token(this.webSessionToken);
                        string = this.urlProcessor.getValue("\"CSRFToken\": ", ' ');
                        string.trim();
                        URLProcessor.setCsrfToken(string.substring(1, string.length() - 1));
                        break block9;
                    }
                    Debug.out.println("getWebSessionToken failed with return value:" + n);
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                }
            } else {
                n = this.urlProcessor.processRequest(JViewer.getProtocol() + "://" + this.tunnelHost + ":" + this.secWebPort + "/rpc/WEBSES/create.asp?WEBVAR_USERNAME=" + JViewer.getUsername() + "&WEBVAR_PASSWORD=" + JViewer.getPassword());
                try {
                    if (n == 0) {
                        this.webSessionToken = this.urlProcessor.getValue("'SESSION_COOKIE' : '", ',');
                        this.webSessionToken.trim();
                        this.webSessionToken = this.webSessionToken.substring(0, this.webSessionToken.lastIndexOf(39));
                        JViewerApp.getInstance().setM_webSession_token(this.webSessionToken);
                    } else {
                        Debug.out.println("getWebSessionToken failed with return value:" + n);
                    }
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                }
            }
        }
        return n;
    }

    public int setHTTPConnect(String string) {
        int n = 0;
        Socket socket = null;
        this.Service = string;
        this.setHttpsock(null);
        this.setOutstream(null);
        this.setInstream(null);
        if (JViewerApp.getInstance().getM_webSession_token() == null) {
            n = this.getWebSessionToken();
            if (n < 0) {
                return n;
            }
            if (n == 0) {
                JViewerApp.getInstance().getConnectionDialog().setWebLogIn(true);
            }
        }
        try {
            int n2 = this.m_bUseSSL ? 2 : 0;
            socket = JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByName(this.tunnelHost), this.tunnelPort, n2);
            if (socket == null) {
                if (this.m_bUseSSL && JViewerApp.getInstance().getConnection().getConnErrCode() == Connection.SUCCESS) {
                    JViewer.exit(0);
                }
                return -1;
            }
            this.setHttpsock(socket);
            this.setOutstream(socket.getOutputStream());
            this.setInstream(socket.getInputStream());
            n = this.doTunnelHandshake(this.tunnelHost, this.secWebPort);
            if (n < 0) {
                Debug.out.println(LocaleStrings.getString("AE_10_SPKVM"));
            }
        }
        catch (UnknownHostException unknownHostException) {
            Debug.out.println(unknownHostException);
            n = -1;
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            n = -1;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            n = -1;
        }
        if (JViewer.isStandAloneApp() || JViewer.isVMApp()) {
            JViewerApp.getInstance().getConnectionDialog().logoutWebSession();
        }
        return n;
    }

    public void DisconnectService(Socket socket) {
        String string = null;
        int n = 0;
        string = "JVIEWER DISCONNECT Cookie " + JViewerApp.getInstance().getM_webSession_token() + "\r\n\r\n";
        if (this.WriteToConnectedSock(string) == 0) {
            string = null;
        } else {
            Debug.out.println(LocaleStrings.getString("AE_11_SPKVM"));
        }
        try {
            n = this.ReadFromConnectedSock();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
        if (n < 0) {
            return;
        }
    }

    private int doTunnelHandshake(String string, int n) throws IOException {
        int n2 = 0;
        String string2 = null;
        string2 = this.FormHttpRequest(" ", string, n);
        if (this.WriteToConnectedSock(string2) != 0) {
            Debug.out.println(LocaleStrings.getString("AE_10_SPKVM"));
            return -1;
        }
        string2 = null;
        string2 = "JVIEWER " + this.Service + " cookie " + JViewerApp.getInstance().getM_webSession_token() + "\r\n\r\n";
        if (this.WriteToConnectedSock(string2) != 0) {
            Debug.out.println(LocaleStrings.getString("AE_10_SPKVM"));
            return -1;
        }
        string2 = null;
        n2 = this.ReadFromConnectedSock();
        if (n2 < 0) {
            return -1;
        }
        return 0;
    }

    private String FormHttpRequest(String string, String string2, int n) {
        String string3 = null;
        String string4 = null;
        string4 = true == this.m_bUseSSL ? " HTTPS/1.1\r\n" : " HTTP/1.1\r\n";
        string3 = "CONNECT" + string + string2 + ":" + n + string4 + " cookie " + JViewerApp.getInstance().getM_webSession_token() + "\r\n\r\n";
        return string3;
    }

    public String GetErrorCode(String string) throws IOException {
        String string2 = null;
        int n = -1;
        if (null == string) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (n = 0; n < stringBuffer.length() && stringBuffer.charAt(n) != '\\'; ++n) {
        }
        try {
            if (n > 0) {
                string2 = "AE_" + string.substring(string.indexOf(":") + 1, n) + "_SPKVM";
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
        }
        return string2;
    }

    public int ReadFromConnectedSock() throws IOException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string = null;
        while (n2 < 1) {
            int n3 = this.getInstream().read();
            if (n3 < 0) {
                return n3;
            }
            if (0 == this.getInstream().available()) {
                bl = true;
                ++n2;
                continue;
            }
            if (n3 == 13) continue;
            n2 = 0;
            if (bl || n >= this.reply.length) continue;
            this.reply[n++] = (byte)n3;
        }
        String string2 = null;
        try {
            string2 = new String(this.reply, 0, n, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.out.println(unsupportedEncodingException);
            string2 = new String(this.reply, 0, n);
        }
        if (string2.contains("ERROR")) {
            try {
                string = LocaleStrings.getString(this.GetErrorCode(string2.trim()));
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                string = LocaleStrings.getString("AE_4_SPKVM");
            }
            if (!this.Service.contains(VIDEO)) {
                JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), string, LocaleStrings.getString("D_3_JVAPP"), 1);
                return -1;
            }
            JOptionPane.showMessageDialog(JViewerApp.getInstance().getMainWindow(), string, LocaleStrings.getString("AE_10_SPKVM"), 1);
            JViewer.exit(0);
        }
        Debug.out.dump(string2.getBytes());
        return n;
    }

    public int WriteToConnectedSock(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.out.println(unsupportedEncodingException);
            byArray = string.getBytes();
        }
        try {
            this.getOutstream().write(byArray);
            this.getOutstream().flush();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        return 0;
    }
}

