/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecordSettings;
import com.ami.kvm.jviewer.gui.VideoRecordStart;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class VideoRecord {
    public int Frame_Interval;
    public int Frame_No;
    public String StoreLocation;
    public String videoType = ".avi";
    public String videoName;
    public String Temp_store_Path;
    public String Final_store_Path;
    private String dateString;
    private String timeString;
    public Timer m_recordTimer;
    public JDialog videoPath = null;
    public VideoRecordSettings m_videoPath;
    public static boolean Recording_Started = false;
    public static boolean Record_Processing = false;
    public static boolean Record_Interrupted = false;
    public static boolean file_creat_success = true;
    public boolean singleVideo = true;
    public VideoRecordStart m_videorecord;
    public final Object obj = new Object();
    public static int fps = 0;
    public static float Avg_fps = 0.0f;
    public static int TotalFrames = 0;
    public static int RecordStopTimer = 1;
    public Date TimeToRun = new Date(0L);
    JViewerApp RCApp = JViewerApp.getInstance();

    public VideoRecord() {
        this.StoreLocation = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_PATH;
        RecordStopTimer = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_TIME;
    }

    public void deleteFiles(int n, String string) {
        while (n < TotalFrames) {
            File file = this.getFile(n, string);
            if (file.isFile()) {
                file.delete();
            }
            ++n;
        }
    }

    public File getFile(int n, String string) {
        String string2 = "file" + n + ".jpeg";
        File file = new File(string, string2);
        return file;
    }

    public void mktmp_videoPath() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH-mm-ss");
        Date date = new Date();
        this.timeString = simpleDateFormat2.format(date);
        this.dateString = simpleDateFormat.format(date);
        this.Final_store_Path = this.StoreLocation + File.separator + this.videoName;
        this.Temp_store_Path = System.getProperty("java.io.tmpdir") + File.separator + this.videoName + "-on-" + this.dateString + "-at-" + this.timeString;
        boolean bl = new File(this.Temp_store_Path).mkdirs();
        if (bl) {
            Debug.out.println("Directories: " + this.Temp_store_Path + " created");
        }
    }

    public String getDate() {
        return this.dateString;
    }

    public void setDate(String string) {
        this.dateString = string;
    }

    public String getTime() {
        return this.timeString;
    }

    public void OnLowDiskSpace(File file, String string) {
        File file2 = file.getParentFile();
        Record_Processing = false;
        if (!file2.delete()) {
            this.RCApp.getM_videorecord().deleteFiles(0, file2.getPath());
            file2.delete();
        }
        if (JViewer.isdownloadapp()) {
            JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
        }
        JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
        JOptionPane.showMessageDialog(jVFrame, string, LocaleStrings.getString("U_1_VR"), 0);
        if (!JViewer.isdownloadapp()) {
            JViewerApp.getInstance().getM_wndFrame().getM_status().resetStatus();
            JViewerApp.getInstance().getM_wndFrame().getWindowMenu().setMessage("");
            TotalFrames = 0;
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
        }
    }

    public void OnVideoRecordStart() {
        TotalFrames = 0;
        this.TimeToRun = new Date(System.currentTimeMillis() / 1000L + (long)RecordStopTimer);
        this.m_videorecord = new VideoRecordStart();
        this.m_recordTimer = null;
        Recording_Started = true;
        this.m_recordTimer = new Timer(true);
        if (JViewer.isdownloadapp()) {
            this.videoName = LocaleStrings.getString("U_6_VR");
        } else {
            this.videoName = LocaleStrings.getString("U_7_VR");
            this.RCApp.getM_wndFrame().getToolbar().getVideoRecordBtn().setIcon(new ImageIcon(JViewer.class.getResource("res/stop_record.png")));
            this.RCApp.getM_wndFrame().getToolbar().getVideoRecordBtn().setToolTipText(LocaleStrings.getString("Q_24_JVT"));
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordStart", false);
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordStop", true);
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordSettings", false);
            this.RCApp.getM_wndFrame().getM_status().setStatus(LocaleStrings.getString("U_2_VR"));
            this.RCApp.getM_wndFrame().getWindowMenu().setMessage(LocaleStrings.getString("U_3_VR"));
        }
        this.mktmp_videoPath();
        this.m_recordTimer.schedule((TimerTask)this.m_videorecord, 0L, 1L);
    }

    public void OnVideoRecordStop() {
        this.m_videorecord.cancel();
        this.m_recordTimer.cancel();
        Recording_Started = false;
        if (!JViewer.isdownloadapp()) {
            this.RCApp.getJVMenu().notifyMenuStateEnable("VideoRecordStop", false);
            JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStart", false);
        }
        if (JViewer.isStandAloneApp() || JViewer.isjviewerapp()) {
            this.RCApp.getM_wndFrame().getToolbar().getVideoRecordBtn().setIcon(new ImageIcon(JViewer.class.getResource("res/start_record.png")));
            this.RCApp.getM_wndFrame().getToolbar().getVideoRecordBtn().setToolTipText(LocaleStrings.getString("Q_7_JVT"));
        }
        if (!Record_Interrupted) {
            Record_Processing = true;
            try {
                Avg_fps = fps / TotalFrames;
            }
            catch (ArithmeticException arithmeticException) {
                Debug.out.println(arithmeticException);
                Avg_fps = 1.0f;
            }
            fps = 0;
            if (Avg_fps >= 5.0f) {
                Avg_fps /= 3.0f;
            }
            if (Avg_fps < 1.0f) {
                Avg_fps = 1.0f;
            }
            try {
                if (!JViewer.isdownloadapp()) {
                    this.RCApp.getM_wndFrame().getWindowMenu().setMessage(LocaleStrings.getString("U_4_VR"));
                    JViewerApp.getInstance().getM_wndFrame().getM_status().resetStatus();
                }
                file_creat_success = true;
                File file = new File(this.Final_store_Path);
                if (!file.exists()) {
                    if (file.mkdirs()) {
                        Debug.out.println("Directories: " + this.Final_store_Path + " created");
                    } else {
                        Debug.out.println("Directories: " + this.Final_store_Path + " Failed");
                        this.Final_store_Path = JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_PATH + File.separator + this.videoName;
                        file = new File(this.Final_store_Path);
                        file.mkdirs();
                        file_creat_success = false;
                        Debug.out.println("Directories: " + this.Final_store_Path + " created");
                    }
                } else {
                    Debug.out.println("Directories: " + this.Final_store_Path + " Already exist");
                }
                this.m_videorecord.makeVideo(this.Final_store_Path + File.separator + LocaleStrings.getString("F_1_JVM") + "_" + this.getDate() + "_" + this.getTime() + this.videoType);
            }
            catch (MalformedURLException malformedURLException) {
                Debug.out.println(malformedURLException);
            }
        }
        Record_Interrupted = false;
        this.RCApp.getMainWindow().repaint();
    }

    public void VideoRecordsettings() {
        Debug.out.println("OnVideoRecordSettings");
        Point point = JViewerApp.getInstance().getPopUpWindowPosition(450, 250);
        if (this.m_videoPath == null) {
            this.m_videoPath = new VideoRecordSettings(JViewer.getMainFrame());
        }
        this.m_videoPath.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VideoRecord.this.m_videoPath.close();
            }
        });
        if (JViewer.isStandalone()) {
            this.m_videoPath.setLocation(point);
            this.m_videoPath.setVisible(true);
        } else {
            JOptionPane jOptionPane = new JOptionPane(this.m_videoPath.getJContentPane(), -1);
            jOptionPane.setOptions(new Object[0]);
            this.videoPath = jOptionPane.createDialog(this.RCApp.getMainWindow(), LocaleStrings.getString("U_5_VR"));
            this.videoPath.setSize(465, 243);
            this.videoPath.setTitle(LocaleStrings.getString("U_5_VR"));
            this.videoPath.setVisible(true);
            this.videoPath.setSize(750, 520);
            this.videoPath.setLocation(point);
            this.videoPath.setLocationRelativeTo(null);
            this.videoPath.setVisible(true);
            this.m_videoPath = (VideoRecordSettings)this.videoPath;
        }
    }

    public Timer getM_recordTimer() {
        return this.m_recordTimer;
    }

    public void setM_recordTimer(Timer timer) {
        this.m_recordTimer = timer;
    }

    public VideoRecordStart getM_videorecord() {
        return this.m_videorecord;
    }

    public void setM_videorecord(VideoRecordStart videoRecordStart) {
        this.m_videorecord = videoRecordStart;
    }

    public VideoRecordSettings getM_videoPath() {
        return this.m_videoPath;
    }

    public void setM_videoPath(VideoRecordSettings videoRecordSettings) {
        this.m_videoPath = videoRecordSettings;
    }
}

