/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.HeaderReader;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import java.net.Socket;
import java.nio.ByteBuffer;

public class CtrlReader
implements KVMReader {
    private static final int CTRL_MSG_BODY_SIZE = 1024;
    private KVMClient m_client;
    private int m_ctrlIx;
    private ByteBuffer m_ctrlBuf;

    public CtrlReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_ctrlIx = 0;
        this.m_ctrlBuf = ByteBuffer.allocate(1024);
    }

    @Override
    public void initialize() {
        if (this.m_client.m_pktHdr.pktSize > 1024) {
            Debug.out.println("Error Case... got a packet bigger than allocated buffer");
            Debug.out.dump(this.m_client.m_pktHdr.array(), 8);
            this.m_ctrlIx = 0;
            this.m_ctrlBuf.clear();
            this.m_ctrlBuf.limit(1024);
            this.m_ctrlBuf.position(0);
        } else {
            this.m_ctrlIx = 0;
            this.m_ctrlBuf.clear();
            this.m_ctrlBuf.limit(this.m_client.m_pktHdr.pktSize);
            this.m_ctrlBuf.position(0);
        }
    }

    @Override
    public int read(Socket socket) {
        if (this.m_client.m_pktHdr.pktSize > 1024 || this.m_client.m_pktHdr.pktSize < 0) {
            try {
                byte[] byArray = new byte[this.m_ctrlBuf.remaining()];
                this.m_ctrlIx = this.m_client.read_data(socket, byArray);
                this.m_ctrlBuf.put(byArray);
                this.m_ctrlBuf.limit(this.m_ctrlIx);
                this.m_ctrlBuf.position(0);
                if (this.m_ctrlIx < 0) {
                    return -1;
                }
            }
            catch (Exception exception) {
                Debug.out.println("CTRL_RDR 1 ");
                Debug.out.println(exception);
                return -1;
            }
            Debug.out.println("1.Invalid pktSize in m_pktHdr: " + this.m_client.m_pktHdr.pktSize);
            return -1;
        }
        if (this.m_client.m_pktHdr.pktSize <= 0) {
            Debug.out.println("3.Invalid pktSize in m_pktHdr: " + this.m_client.m_pktHdr.pktSize);
            return -1;
        }
        try {
            byte[] byArray = new byte[this.m_ctrlBuf.remaining()];
            this.m_ctrlIx = this.m_client.read_data(socket, byArray);
            this.m_ctrlBuf.put(byArray);
            this.m_ctrlBuf.limit(this.m_ctrlIx);
            this.m_ctrlBuf.position(0);
            if (this.m_client.m_pktHdr.pktSize <= this.m_ctrlIx) {
                this.m_client.m_ctrlMsg = this.m_ctrlBuf;
                this.m_client.onControlMessage();
                this.m_client.m_ctrlMsg.position(0);
                HeaderReader headerReader = this.m_client.getHdrReader();
                headerReader.initialize();
                this.m_client.setState(headerReader);
            }
        }
        catch (Exception exception) {
            Debug.out.println("CTRL_RDR 2");
            Debug.out.println(exception);
            return -1;
        }
        return 0;
    }
}

