/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.FragNumReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.NullReader;
import java.net.Socket;
import java.nio.ByteBuffer;

public class HeaderReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_hdrBuf;
    private ByteBuffer m_hdrByteBuf;
    private IVTPPktHdr m_pktHdr;
    private int m_hdrIx;

    public HeaderReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_hdrBuf = new byte[8];
        this.m_hdrByteBuf = ByteBuffer.wrap(this.m_hdrBuf);
        this.m_pktHdr = new IVTPPktHdr();
        this.m_hdrIx = 0;
    }

    @Override
    public void initialize() {
        this.m_hdrIx = 0;
        this.m_hdrByteBuf.clear();
    }

    @Override
    public int read(Socket socket) {
        try {
            byte[] byArray = new byte[this.m_hdrByteBuf.remaining()];
            this.m_hdrIx = this.m_client.read_data(socket, byArray);
            this.m_hdrByteBuf.put(byArray);
            if (this.m_hdrIx < 0) {
                return -1;
            }
            if (8 <= this.m_hdrIx) {
                this.m_pktHdr.set(this.m_hdrByteBuf);
                this.m_client.m_pktHdr = this.m_pktHdr;
                KVMReader kVMReader = null;
                Boolean bl = this.OnGetReader(this.m_pktHdr.type);
                if (!bl.booleanValue()) {
                    if (this.m_pktHdr.pktSize > 0) {
                        Debug.out.println("Control\n");
                        kVMReader = this.m_client.getCtrlReader();
                        kVMReader.initialize();
                        this.m_client.setState(kVMReader);
                    } else {
                        Debug.out.println("Control No Body\n");
                        this.m_client.onControlMessage();
                        kVMReader = this.m_client.getHdrReader();
                        kVMReader.initialize();
                        this.m_client.setState(kVMReader);
                    }
                }
            }
        }
        catch (Exception exception) {
            Debug.out.println("HDR_RDR ");
            Debug.out.println(exception);
            return -1;
        }
        return 0;
    }

    private Boolean OnGetReader(short s) {
        if (s == 25) {
            if (this.m_client.m_isBlank) {
                this.m_client.m_isBlank = false;
            }
            Debug.out.println("Video Fragment\n");
            FragNumReader fragNumReader = this.m_client.getFragNumReader();
            fragNumReader.initialize();
            this.m_client.setState(fragNumReader);
        } else if (s == 17) {
            Debug.out.println("BW Detect\n");
            NullReader nullReader = this.m_client.getNullReader();
            nullReader.initialize();
            this.m_client.setState(nullReader);
        } else {
            Debug.out.println("GET SOC READER :: Header type : " + this.m_pktHdr.type);
            KVMReader kVMReader = this.m_client.getSocReader(this.m_pktHdr.type);
            if (kVMReader == null) {
                return false;
            }
            kVMReader.initialize();
            this.m_client.setState(kVMReader);
        }
        return true;
    }
}

