/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc;

import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.common.ISOCJVVideo;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.soc.SOCCreateBufferImage;
import com.ami.kvm.jviewer.soc.SOCFrameHdr;
import com.ami.kvm.jviewer.soc.video.Decoder;
import com.ami.kvm.jviewer.soc.video.VideoEngineInfo;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SOCJVVideo
implements ISOCJVVideo {
    private byte[] videoBuf;
    private JViewerView viewerView = JViewerApp.getInstance().getRCView();
    private SOCFrameHdr frameHdr;
    private VideoEngineInfo videoEngInfo;
    private Decoder decoder;
    private Rectangle prevCursorRect;
    public byte[] prevCursorFrame;
    private static boolean m_bFirstInit = true;

    @Override
    public void VideoBuffer_Initialize() {
        this.videoBuf = ((SOCCreateBufferImage)JViewerApp.getInstance().getPrepare_buf()).imageMemoryByte();
        Arrays.fill(this.videoBuf, (byte)0);
        this.decoder = new Decoder(this.viewerView, this.videoBuf, this);
        this.prevCursorFrame = new byte[12288];
        this.prevCursorRect = new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void Newframevalidate() {
        this.videoEngInfo = this.frameHdr.getFrameVariables();
    }

    @Override
    public ByteBuffer decompressframe(ISOCFrameHdr iSOCFrameHdr, ByteBuffer byteBuffer) {
        this.videoBuf = ((SOCCreateBufferImage)JViewerApp.getInstance().getPrepare_buf()).imageMemoryByte();
        this.decoder.setBuf(this.videoBuf);
        if (this.frameHdr.getCompressedBuf() != null) {
            int[] nArray = this.MakeIntArray(this.frameHdr.getCompressedBuf());
            this.decoder.decode(this.videoEngInfo, nArray);
            this.viewerView.repaint();
        }
        return byteBuffer;
    }

    @Override
    public void SOC_Specific(ByteBuffer byteBuffer) {
    }

    @Override
    public void setframehdr(ISOCFrameHdr iSOCFrameHdr) {
        this.frameHdr = (SOCFrameHdr)iSOCFrameHdr;
    }

    public SOCFrameHdr getframehdr() {
        return this.frameHdr;
    }

    @Override
    public void SOCBlankscreen() {
    }

    @Override
    public void SOCreset() {
    }

    @Override
    public void soccompressionchange() {
    }

    public int[] MakeIntArray(byte[] byArray) {
        byte[] byArray2;
        int n = 0;
        if (byArray.length % 4 == 3) {
            byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray2.length - 1] = 0;
        } else if (byArray.length % 4 == 2) {
            byArray2 = new byte[byArray.length + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray2.length - 2] = 0;
            byArray2[byArray2.length - 1] = 0;
        } else if (byArray.length % 4 == 1) {
            byArray2 = new byte[byArray.length + 3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray2.length - 3] = 0;
            byArray2[byArray2.length - 2] = 0;
            byArray2[byArray2.length - 1] = 0;
        } else {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        int[] nArray = new int[byArray2.length / 4];
        int n2 = 0;
        while (n2 < byArray2.length / 4) {
            nArray[n2] = (byArray2[n + 3] & 0xFF) << 24;
            int n3 = n2;
            nArray[n3] = nArray[n3] | (byArray2[n + 2] & 0xFF) << 16;
            int n4 = n2;
            nArray[n4] = nArray[n4] | (byArray2[n + 1] & 0xFF) << 8;
            int n5 = n2++;
            nArray[n5] = nArray[n5] | (byArray2[n + 0] & 0xFF) << 0;
            n += 4;
        }
        return nArray;
    }

    public void SetPointInSavedScreen(int n, int n2, byte by, byte by2, byte by3) {
        if (this.prevCursorRect.contains(n, n2)) {
            int n3 = ((n2 - this.prevCursorRect.y) * this.prevCursorRect.width + (n - this.prevCursorRect.x)) * 3;
            this.prevCursorFrame[n3] = by;
            this.prevCursorFrame[n3 + 1] = by2;
            this.prevCursorFrame[n3 + 2] = by3;
        }
    }

    public void SaveScreenContent(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                n = ((i + rectangle.y) * this.viewerView.viewWidth() + (j + rectangle.x)) * 3;
                this.prevCursorFrame[n2] = this.videoBuf[n];
                this.prevCursorFrame[n2 + 1] = this.videoBuf[n + 1];
                this.prevCursorFrame[n2 + 2] = this.videoBuf[n + 2];
                n2 += 3;
            }
        }
        this.prevCursorRect.setBounds(rectangle);
    }

    public void RestoreScreenContent(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                n = ((i + rectangle.y) * this.viewerView.viewWidth() + (j + rectangle.x)) * 3;
                this.videoBuf[n] = this.prevCursorFrame[n2];
                this.videoBuf[n + 1] = this.prevCursorFrame[n2 + 1];
                this.videoBuf[n + 2] = this.prevCursorFrame[n2 + 2];
                n2 += 3;
            }
        }
    }

    private void sendIVTPPacket(IVTPPktHdr iVTPPktHdr, DataInputStream dataInputStream) {
    }

    @Override
    public void socreadframeattributes(DataInputStream dataInputStream) {
    }
}

