/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc.reader;

import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.jvvideo.JVVideo;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import com.ami.kvm.jviewer.soc.SOCApp;
import java.net.Socket;
import java.nio.ByteBuffer;

public class HardwareCursorReader
implements KVMReader {
    private KVMClient client;
    private byte[] hwCursorBuf;
    private ByteBuffer hwCursorByteBuf;
    private int hwCursorIndex;

    public HardwareCursorReader(KVMClient kVMClient, JVVideo jVVideo) {
        this.client = kVMClient;
        this.hwCursorBuf = new byte[8205];
        this.hwCursorIndex = 0;
        this.hwCursorByteBuf = ByteBuffer.wrap(this.hwCursorBuf);
    }

    @Override
    public void initialize() {
        this.hwCursorByteBuf.position(0);
        this.hwCursorByteBuf.limit(this.client.m_pktHdr.pktSize);
        this.hwCursorIndex = 0;
    }

    @Override
    public int read(Socket socket) {
        Object object;
        try {
            object = new byte[this.hwCursorByteBuf.remaining()];
            this.hwCursorIndex = this.client.read_data(socket, (byte[])object);
            this.hwCursorByteBuf.put((byte[])object);
        }
        catch (Exception exception) {
            System.out.println("HW CURSOR " + exception);
            return -1;
        }
        if (this.hwCursorIndex == 0) {
            object = this.client.getHdrReader();
            object.initialize();
            this.client.setState((KVMReader)object);
            return 0;
        }
        if (this.hwCursorIndex == this.client.m_pktHdr.pktSize) {
            object = this.client.getHdrReader();
            object.initialize();
            this.client.setState((KVMReader)object);
            ((SOCApp)JViewerApp.getInstance().getSoc_App()).onHardwareCursor(this.hwCursorByteBuf);
        }
        return 0;
    }
}

