/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.videorecord;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.common.ISOCFrameHdr;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.RecorderToolBar;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.videorecord.VideoFrame;
import com.ami.kvm.jviewer.videorecord.VideoFrameBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;

public class DisplayVideoDataTask
extends TimerTask {
    public static boolean run = true;
    private ISOCFrameHdr frameHdr = JViewerApp.getSoc_manager().getSOCFramehdr();
    private Date startTime;
    private VideoFrameBuffer videoFrameBuffer = null;
    private static int videoDuration = 0;
    public static Object playLock = new Object();
    public static boolean isPaused = false;
    private static int counter = 0;
    public static Timer timer;

    public DisplayVideoDataTask(byte[] byArray) {
        if (JViewer.isdownloadapp()) {
            JViewerApp.getInstance().getVideorecordapp().showInformationDialog(LocaleStrings.getString("Y_1_DVDT"), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        long l = 0L;
        long l2 = 0L;
        byte[] byArray = new byte[this.frameHdr.getFrameHeadersize()];
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        this.videoFrameBuffer = JViewerApp.getInstance().getVideorecordapp().getVideoFrameBuffer();
        this.startTime = new Date(System.currentTimeMillis() / 1000L);
        run = true;
        if (JViewer.isplayerapp() && videoDuration != 0) {
            object = new TimerTask(){

                @Override
                public void run() {
                    DisplayVideoDataTask.update();
                }
            };
            timer = new Timer();
            timer.scheduleAtFixedRate((TimerTask)object, 0L, 100L);
            RecorderToolBar.updateComponents(videoDuration);
        }
        while (run) {
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).clear();
            l4 = System.currentTimeMillis();
            try {
                Object object2;
                Object object3;
                Object object4;
                if (this.videoFrameBuffer.size() <= 0) {
                    run = false;
                    if (JViewer.isplayerapp()) {
                        this.onenablemenu();
                    }
                    this.cancel();
                    continue;
                }
                VideoFrame videoFrame = this.videoFrameBuffer.take();
                if (videoFrame == null) {
                    run = false;
                    if (JViewer.isplayerapp()) {
                        this.onenablemenu();
                    }
                    this.cancel();
                    continue;
                }
                if (l5 < 0L) {
                    l5 = 0L;
                }
                l2 = videoFrame.getTimeStamp();
                if (l == 0L) {
                    l = l2;
                }
                byte by = videoFrame.getCode();
                l3 = l2 - l - l5;
                if (by == 85 || by == -86 || by == 170) {
                    if (l3 > 0L) {
                        try {
                            Thread.sleep(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            Debug.out.println(interruptedException);
                        }
                    }
                    if (by == -86) continue;
                }
                if (by == 170) continue;
                if (by == 102) {
                    if (l3 > 0L) {
                        try {
                            Thread.sleep(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            Debug.out.println(interruptedException);
                        }
                    }
                    JViewerApp.getInstance().getVidClnt().onBlankScreen();
                    continue;
                }
                if (by == 119) {
                    object4 = null;
                    object3 = videoFrame.getPalette();
                    object4 = ByteBuffer.wrap((byte[])object3);
                    ((ByteBuffer)object4).order(ByteOrder.LITTLE_ENDIAN);
                    object2 = new IVTPPktHdr(4097, ((byte[])object3).length, 0);
                    JViewerApp.getInstance().getSockvmclient().onSocControlMessage((IVTPPktHdr)object2, (ByteBuffer)object4);
                    ByteBuffer byteBuffer = null;
                    byte[] byArray2 = videoFrame.getAttribute();
                    byteBuffer = ByteBuffer.wrap(byArray2);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    object2 = new IVTPPktHdr(4096, byArray2.length, 0);
                    JViewerApp.getInstance().getSockvmclient().onSocControlMessage((IVTPPktHdr)object2, byteBuffer);
                    continue;
                }
                l = l2;
                byArray = videoFrame.getHeader();
                object = ByteBuffer.wrap(byArray);
                ((ByteBuffer)object).position(this.frameHdr.getFrameHeadersize());
                this.frameHdr.setHeader((ByteBuffer)object);
                ((ByteBuffer)object).position(0);
                if (this.frameHdr.getFrameSize() > 0x480000) {
                    run = false;
                    if (JViewer.isplayerapp()) {
                        this.onenablemenu();
                    }
                    this.cancel();
                    break;
                }
                object4 = new byte[this.frameHdr.getFrameSize()];
                object4 = videoFrame.getFrameData();
                object3 = ByteBuffer.allocate(this.frameHdr.getFrameSize() + this.frameHdr.getFrameHeadersize());
                ((ByteBuffer)object3).order(ByteOrder.LITTLE_ENDIAN);
                ((ByteBuffer)object3).put(byArray, 0, this.frameHdr.getFrameHeadersize());
                ((ByteBuffer)object3).put((byte[])object4);
                ((ByteBuffer)object3).position(this.frameHdr.getFrameSize() + this.frameHdr.getFrameHeadersize());
                object2 = DisplayVideoDataTask.getPlayLock();
                synchronized (object2) {
                    if (DisplayVideoDataTask.isPaused()) {
                        playLock.wait();
                    }
                }
                JViewerApp.getInstance().getVidClnt().onNewFrame((ByteBuffer)object3);
                l5 = System.currentTimeMillis() - l4 - l3;
            }
            catch (Exception exception) {
                Debug.out.println(exception);
            }
        }
        if (JViewer.isdownloadapp()) {
            this.calculateDuration();
        }
    }

    private void onenablemenu() {
        JViewerApp.getInstance().initilizeJVVideo();
        RecorderToolBar recorderToolBar = (RecorderToolBar)JViewerApp.getInstance().getM_wndFrame().getToolbar();
        recorderToolBar.replayButton.setIcon(new ImageIcon(JViewer.class.getResource("res/play.png")));
        recorderToolBar.replayButton.setToolTipText(LocaleStrings.getString("R_1_RT"));
        recorderToolBar.replayButton.setActionCommand("");
    }

    public void calculateDuration() {
        long l = new Date(System.currentTimeMillis() / 1000L).getTime() - this.startTime.getTime();
        JViewerApp.getInstance().getVideorecordapp().setDuration(l);
    }

    public static Object getPlayLock() {
        return playLock;
    }

    public static void pause() {
        timer.cancel();
    }

    public static void resume() {
        if (JViewer.isplayerapp() && videoDuration != 0) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    DisplayVideoDataTask.update();
                }
            };
            timer = new Timer();
            timer.scheduleAtFixedRate(timerTask, 0L, 100L);
        }
    }

    public static void update() {
        if (counter <= videoDuration * 10) {
            RecorderToolBar.getSlider().setValue(++counter);
            RecorderToolBar.getLabel().setText(Integer.toString(counter / 10) + " / " + Integer.toString(videoDuration));
        } else {
            timer.cancel();
        }
    }

    public static int getVideoDuration() {
        return videoDuration;
    }

    public static void setVideoDuration(int n) {
        videoDuration = n;
    }

    public static int getCounter() {
        return counter;
    }

    public static void setCounter(int n) {
        counter = n;
    }

    public static boolean isPaused() {
        return isPaused;
    }

    public static void setPaused(boolean bl) {
        isPaused = bl;
    }
}

