/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.DevicePanel;

public class RedirectionController
implements Runnable {
    private String sessionToken = null;
    private int cdPort = JViewer.getCDPort();
    private int hdPort = JViewer.getHDPort();
    private boolean useSSL = JViewer.isVMUseSSL();
    private int deviceType = -1;
    private int deviceIndex = -1;

    public void updateRedirectionStatus(int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        for (n3 = 0; n3 < n2; ++n3) {
            switch (n) {
                case 0: {
                    bl = JViewerApp.getInstance().IsCDROMRedirRunning(n3);
                    break;
                }
                case 2: {
                    bl = JViewerApp.getInstance().IsHarddiskRedirRunning(n3);
                    break;
                }
                default: {
                    Debug.out.printError("Invalid Device type");
                    return;
                }
            }
            VMApp.getVMPane().getStatusTabPanel().updateStatusTable(n, n3, bl);
            VMApp.getVMPane().updateDeviceStatusTable(n, n3, bl);
            VMApp.getVMPane().getDeviceControlPanel(n, n3).updateDeviceControlPanel();
        }
    }

    public void handleDeviceRedirection(int n, int n2) {
        this.deviceIndex = n2;
        this.deviceType = n;
        new Thread((Runnable)VMApp.getInstance().getRedirectionController(), "VMApp redirectionController").start();
    }

    private void updateConnectButton(boolean bl) {
        int[] nArray = new int[]{0, 2};
        int[] nArray2 = new int[]{VMApp.getInstance().getNumCD(), VMApp.getInstance().getNumHD()};
        int n = 0;
        for (int n2 : nArray) {
            for (int i = 0; i < nArray2[n]; ++i) {
                VMApp.getVMPane().getDeviceControlPanel(n2, i).getConnectButton().setEnabled(bl);
            }
            ++n;
        }
    }

    @Override
    public void run() {
        IUSBRedirSession iUSBRedirSession = VMApp.getInstance().getIUSBRedirSession();
        this.sessionToken = JViewer.getKVMToken();
        boolean bl = false;
        boolean bl2 = false;
        DevicePanel devicePanel = VMApp.getVMPane().getDeviceControlPanel(this.deviceType, this.deviceIndex).getDevicePanel();
        String string = null;
        int n = 0;
        switch (this.deviceType) {
            case 0: {
                n = this.cdPort;
                break;
            }
            case 2: {
                n = this.hdPort;
            }
        }
        if (devicePanel.isImageSelected()) {
            Debug.out.println("Starting image redirection " + devicePanel.getImagePath());
            bl2 = false;
            string = devicePanel.getImagePath();
        } else {
            Debug.out.println("Starting device redirection " + devicePanel.getSelectedDeviceString());
            bl2 = true;
            string = devicePanel.getSelectedDeviceString();
        }
        this.updateConnectButton(false);
        if (iUSBRedirSession.getDeviceRedirStatus(this.deviceType, this.deviceIndex) == 0) {
            devicePanel.disableAll();
            VMApp.getVMPane().getDeviceControlPanel(this.deviceType, this.deviceIndex).getConnectButton().setText(LocaleStrings.getString("AJ_7_DCP"));
            bl = iUSBRedirSession.startDeviceRedirection(this.deviceType, this.sessionToken, n, this.deviceIndex, this.useSSL, string, bl2);
            if (bl) {
                if (!bl2) {
                    String[] stringArray = devicePanel.getImagePathList();
                    devicePanel.saveImagePath(stringArray, this.deviceType, this.deviceIndex);
                } else {
                    VMApp.getVMPane().physicalDriveChangeState(this.deviceType, this.deviceIndex, string, false);
                }
                iUSBRedirSession.setImageRedirected(this.deviceType, this.deviceIndex, !bl2);
                VMApp.getVMPane().getStatusTabPanel().updateStatusTable(this.deviceType, this.deviceIndex, true);
                VMApp.getVMPane().updateDeviceStatusTable(this.deviceType, this.deviceIndex, true);
            }
            devicePanel.enableAll();
            Debug.out.println("redirection should be running");
        } else {
            VMApp.getVMPane().getDeviceControlPanel(this.deviceType, this.deviceIndex).getConnectButton().setText(LocaleStrings.getString("AJ_8_DCP"));
            iUSBRedirSession.setImageRedirected(this.deviceType, this.deviceIndex, !bl2);
            iUSBRedirSession.setDeviceStopMode(this.deviceType, this.deviceIndex, true);
            if (bl2) {
                VMApp.getVMPane().physicalDriveChangeState(this.deviceType, this.deviceIndex, string, true);
            }
            iUSBRedirSession.stopDeviceRedirection(this.deviceType, this.deviceIndex);
            VMApp.getVMPane().getStatusTabPanel().updateStatusTable(this.deviceType, this.deviceIndex, false);
            VMApp.getVMPane().updateDeviceStatusTable(this.deviceType, this.deviceIndex, false);
        }
        VMApp.getVMPane().getDeviceControlPanel(this.deviceType, this.deviceIndex).updateDeviceControlPanel();
        this.updateConnectButton(true);
    }
}

