/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.HarddiskRedir;
import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.InfoDialog;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.SinglePortKVM;
import com.ami.vmedia.DeviceDetector;
import com.ami.vmedia.RedirectionController;
import com.ami.vmedia.RedirectionStatusMonitor;
import com.ami.vmedia.gui.UpdateBytesRead;
import com.ami.vmedia.gui.VMDialog;
import com.ami.vmedia.gui.VMFrame;
import com.ami.vmedia.gui.VMPane;
import com.ami.vmedia.gui.VMStatusBar;
import java.awt.Component;
import java.awt.Point;
import java.util.Timer;
import java.util.TimerTask;

public class VMApp {
    public static final int DEVICE_TYPE_CDROM = 0;
    public static final int DEVICE_TYPE_HD_USB = 2;
    public static final int DEFAULT_NUM_DRIVES = 1;
    public static final int IMAGE_TYPE_CDROM = 1;
    public static final int IMAGE_TYPE_HARDDISK = 3;
    public static final int MAX_IMAGE_PATH_COUNT = 5;
    private static int height = 0;
    private static int width = 0;
    private static Point windowPos = new Point(0, 0);
    public static final int CD_MEDIA = 0;
    public static final int HD_MEDIA = 1;
    public static final int STATUS_TAB = 2;
    public static String[][] cdImagePath;
    public static String[][] hdImagePath;
    private static VMApp vmApp;
    private static VMPane vmPane;
    private static VMStatusBar statusPanel;
    private static VMFrame vmFrame;
    private static VMDialog vmDialog;
    private int numCD;
    private int numHD;
    private int freeCDNum = 0;
    private int freeHDNum = 0;
    private String[] cdDriveList;
    private String[] hdDriveList;
    private static String lang;
    private static String ip;
    private IUSBRedirSession iusbRedirSession = null;
    private static DeviceDetector devDetector;
    private static RedirectionStatusMonitor redirectionStatusMonitor;
    private static String webSessionToken;
    private static String kvmToken;
    private RedirectionController redirectionController = null;
    private static Timer updateBytesTimer;

    public static void launchApp() {
        statusPanel = new VMStatusBar();
        if (JViewer.isVMApp()) {
            vmFrame = new VMFrame();
        } else {
            vmDialog = new VMDialog();
            VMApp.setVMDialog(vmDialog);
            JViewerApp.getInstance().setVMDialog(vmDialog);
        }
        updateBytesTimer = new Timer();
        updateBytesTimer.schedule((TimerTask)new UpdateBytesRead(), 0L, 1000L);
        if (JViewer.isVMApp() && JViewer.isSinglePortEnabled()) {
            JViewerApp.getInstance().getConnection().setKvmSSLVerify(false);
            JViewerApp.getInstance().setSinglePortKvm(new SinglePortKVM(JViewer.getIp(), JViewer.getKvmPort(), JViewer.getWebPort(), JViewer.isUseSSL()));
        }
    }

    public VMApp() {
        webSessionToken = JViewer.getWebSessionToken();
        kvmToken = JViewer.getKVMToken();
        this.redirectionController = new RedirectionController();
    }

    public static VMApp getInstance() {
        return vmApp;
    }

    public static VMPane getVMPane() {
        return vmPane;
    }

    public static void setVMPane(VMPane vMPane) {
        vmPane = vMPane;
    }

    public static VMStatusBar getVMStatusPanel() {
        return statusPanel;
    }

    public static VMFrame getVMFrame() {
        return vmFrame;
    }

    public static VMDialog getVMDialog() {
        return vmDialog;
    }

    public static void setVMDialog(VMDialog vMDialog) {
        vmDialog = vMDialog;
    }

    public int getNumCD() {
        return this.numCD;
    }

    public void setNumCD(int n) {
        String[][] stringArray = null;
        int n2 = this.numCD;
        stringArray = cdImagePath;
        this.numCD = n;
        cdImagePath = new String[n][5];
        if (n2 > n) {
            n2 = n;
        }
        if (stringArray != null) {
            for (int i = 0; i < n2; ++i) {
                VMApp.cdImagePath[i] = stringArray[i];
            }
        }
    }

    public int getNumHD() {
        return this.numHD;
    }

    public void setNumHD(int n) {
        String[][] stringArray = null;
        int n2 = this.numHD;
        stringArray = hdImagePath;
        this.numHD = n;
        hdImagePath = new String[n][5];
        if (n2 > n) {
            n2 = n;
        }
        if (stringArray != null) {
            for (int i = 0; i < n2; ++i) {
                VMApp.hdImagePath[i] = stringArray[i];
            }
        }
    }

    public int getFreeCDNum() {
        return this.freeCDNum;
    }

    public void setFreeCDNum(int n) {
        this.freeCDNum = n;
    }

    public int getFreeHDNum() {
        return this.freeHDNum;
    }

    public void setFreeHDNum(int n) {
        this.freeHDNum = n;
    }

    public void updateFreeDeviceStatus() {
        if (vmFrame == null || vmFrame.isShowing()) {
            // empty if block
        }
    }

    public String getRomanNumber(int n) {
        String string = null;
        int n2 = 8544;
        if (n < 12) {
            if (n > 0) {
                n2 += n;
            }
            char c = (char)n2;
            string = String.valueOf(c);
        } else {
            string = String.valueOf(n);
        }
        return string;
    }

    public static String getLanguage() {
        return lang;
    }

    public static void setLanguage(String string) {
        lang = string;
        LocaleStrings.setLanguageID(lang);
    }

    public static void setDefaultLanguage() {
        lang = "EN";
    }

    public static String getIp() {
        return ip;
    }

    public void createIUSBRedirectionSession() {
        if (this.iusbRedirSession != null && (this.iusbRedirSession.cdromSession.length != VMApp.getInstance().getNumCD() || this.iusbRedirSession.hardDiskSession.length != VMApp.getInstance().getNumHD())) {
            this.iusbRedirSession = null;
        }
        if (this.iusbRedirSession == null) {
            this.iusbRedirSession = new IUSBRedirSession();
        }
    }

    public IUSBRedirSession getIUSBRedirSession() {
        return this.iusbRedirSession;
    }

    public String[] getCDROMList() {
        String[] stringArray = null;
        try {
            CDROMRedir cDROMRedir = new CDROMRedir(true);
            stringArray = cDROMRedir.getCDROMList();
            System.gc();
        }
        catch (RedirectionException redirectionException) {
            Debug.out.println("Exception occured while getCDROMList()");
            Debug.out.println(redirectionException);
        }
        catch (Error error) {
            Debug.out.println("Exception occured while getCDROMList()");
            Debug.out.println(error);
        }
        catch (Exception exception) {
            Debug.out.println("Exception occured while getCDROMList()");
            Debug.out.println(exception);
        }
        return stringArray;
    }

    public String[] getHDDUSBList() {
        String[] stringArray = null;
        try {
            if (JViewer.IsClientAdmin()) {
                HarddiskRedir harddiskRedir = new HarddiskRedir(true);
                stringArray = harddiskRedir.getUSBHDDList();
                System.gc();
            }
        }
        catch (Error error) {
            Debug.out.println("Exception occured while getHDDUSBList()");
            Debug.out.println(error);
        }
        catch (Exception exception) {
            Debug.out.println("Exception occured while getHDDUSBList()");
            Debug.out.println(exception);
        }
        return stringArray;
    }

    public String[] getHarddiskFixedList() {
        String[] stringArray = null;
        if (JViewer.IsClientAdmin()) {
            try {
                if ((JViewer.getOEMFeatureStatus() & 2L) != 2L) {
                    HarddiskRedir harddiskRedir = new HarddiskRedir(true);
                    stringArray = harddiskRedir.getHarddiskFixedList();
                    System.gc();
                }
            }
            catch (Error error) {
                Debug.out.println("Exception occured while getHarddiskFixedList()");
                Debug.out.println(error);
            }
            catch (Exception exception) {
                Debug.out.println("Exception occured while getHarddiskFixedList()");
                Debug.out.println(exception);
            }
        }
        return stringArray;
    }

    public String[] getEntireHarddiskList() {
        String[] stringArray = null;
        try {
            HarddiskRedir harddiskRedir = new HarddiskRedir(true);
            stringArray = harddiskRedir.getEntireHarddiskList();
            System.gc();
        }
        catch (Error error) {
            Debug.out.println("Exception occured while getEntireHarddiskList()");
            Debug.out.println(error);
        }
        catch (Exception exception) {
            Debug.out.println("Exception occured while getEntireHarddiskList()");
            Debug.out.println(exception);
        }
        return stringArray;
    }

    public String[] getDeviceDriveList(int n) {
        String[] stringArray = null;
        if (n == 0) {
            stringArray = this.cdDriveList = this.getCDROMList();
        } else if (n == 2) {
            String[] stringArray2 = this.getHDDUSBList();
            String[] stringArray3 = null;
            if (JViewer.IsClientAdmin() && (JViewer.getOEMFeatureStatus() & 2L) != 2L) {
                stringArray3 = this.getHarddiskFixedList();
            }
            int n2 = 0;
            if (stringArray2 != null || stringArray3 != null) {
                int n3;
                int n4 = 0;
                if (stringArray2 != null) {
                    n4 += stringArray2.length;
                }
                if (stringArray3 != null) {
                    n4 += stringArray3.length;
                }
                this.hdDriveList = new String[n4];
                if (stringArray3 != null) {
                    n3 = 0;
                    while (n3 < stringArray3.length) {
                        this.hdDriveList[n2] = stringArray3[n3];
                        this.hdDriveList[n2] = this.hdDriveList[n2].concat(LocaleStrings.getString("G_16_VMD"));
                        ++n3;
                        ++n2;
                    }
                }
                if (stringArray2 != null) {
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        this.hdDriveList[n2] = stringArray2[n3];
                        this.hdDriveList[n2] = this.hdDriveList[n2].concat(" - USB");
                        ++n2;
                    }
                }
            } else {
                this.hdDriveList = null;
            }
            stringArray = this.hdDriveList;
        }
        return stringArray;
    }

    public String[] getCDDriveList() {
        return this.cdDriveList;
    }

    public void setCDDriveList(String[] stringArray) {
        this.cdDriveList = stringArray;
    }

    public String[] getHDDriveList() {
        return this.hdDriveList;
    }

    public void setHDDriveList(String[] stringArray) {
        this.hdDriveList = stringArray;
    }

    public static String getWebSessionToken() {
        return webSessionToken;
    }

    public static void setWebSessionToken(String string) {
        webSessionToken = string;
    }

    public static String getKVMToken() {
        return kvmToken;
    }

    public RedirectionController getRedirectionController() {
        return this.redirectionController;
    }

    public static void setKVMToken(String string) {
        kvmToken = string;
    }

    public static Timer getUpdateBytesTimer() {
        return updateBytesTimer;
    }

    public boolean isCDRedirRunning(int n) {
        boolean bl = false;
        if (this.iusbRedirSession.getCDROMRedirStatus(n) == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isHDRedirRunning(int n) {
        boolean bl = false;
        if (this.iusbRedirSession.getHarddiskRedirStatus(n) == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isCDRedirRunning() {
        boolean bl = false;
        try {
            for (int i = 0; i < this.numCD; ++i) {
                if (this.iusbRedirSession.getCDROMRedirStatus(i) != 1) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            bl = false;
        }
        return bl;
    }

    public boolean isHDRedireRunning() {
        boolean bl = false;
        try {
            for (int i = 0; i < this.numHD; ++i) {
                if (this.iusbRedirSession.getHarddiskRedirStatus(i) != 1) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            bl = false;
        }
        return bl;
    }

    public void generalErrorMessage(String string, String string2) {
        InfoDialog.showDialog((Component)vmFrame, string2, string, 2);
    }

    public void initDeviceDetector() {
        if (devDetector == null) {
            devDetector = new DeviceDetector();
            devDetector.setName("DeviceDetector");
        }
    }

    public void initRedirectionStatusMonitor() {
        if (redirectionStatusMonitor == null) {
            redirectionStatusMonitor = new RedirectionStatusMonitor();
            redirectionStatusMonitor.setName("RedirectionStatusMonitor");
        }
    }

    public static void stopDeviceDetector() {
        if (devDetector != null) {
            devDetector.stopDeviceDetector();
        }
        devDetector = null;
    }

    public static void stopRedirectionStatusMonitor() {
        if (redirectionStatusMonitor != null) {
            redirectionStatusMonitor.stopRedirectionStatusMonitior();
        }
        redirectionStatusMonitor = null;
    }

    public static void exit(int n) {
        VMApp.stopDeviceDetector();
        VMApp.stopRedirectionStatusMonitor();
        System.exit(n);
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static void setWidth(int n) {
        width = n;
    }

    public static void setHeight(int n) {
        height = n;
    }

    public static Point getWindowPos() {
        return windowPos;
    }

    public static void setWindowPos(Point point) {
        windowPos = point;
    }

    static {
        vmApp = new VMApp();
        vmPane = null;
        statusPanel = null;
        vmFrame = null;
        vmDialog = null;
        lang = null;
        devDetector = null;
        redirectionStatusMonitor = null;
        updateBytesTimer = null;
    }
}

