/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.DevicePanel;
import com.ami.vmedia.gui.VMActionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DeviceControlPanel
extends JPanel {
    private final int INSTANCE_PANEL_WIDTH = 400;
    private final int INSTANCE_PANEL_HEIGHT = 70;
    private JButton connectButton;
    private JScrollPane instanceScrollPane;
    private DevicePanel devicePanel;
    private JPanel connectPanel;
    private JPanel instancePanel;
    private IUSBRedirSession iusbRedirSession = VMApp.getInstance().getIUSBRedirSession();
    private String deviceLabelText;
    private JRadioButton physicalDrive;
    private JRadioButton logicalDrive;
    private ButtonGroup driveSelectionGroup;
    private int deviceIndex;
    private int deviceType;
    private String redirectionSource = null;
    private int devCount;
    private int freeDevCount;

    public DeviceControlPanel(int n, int n2) {
        this.deviceType = n;
        this.deviceIndex = n2;
        String[] stringArray = VMApp.getInstance().getDeviceDriveList(n);
        switch (n) {
            case 0: {
                this.deviceLabelText = LocaleStrings.getString("AJ_1_DCP");
                this.devCount = VMApp.getInstance().getNumCD();
                this.freeDevCount = VMApp.getInstance().getFreeCDNum();
                break;
            }
            case 2: {
                this.deviceLabelText = LocaleStrings.getString("AJ_3_DCP");
                this.devCount = VMApp.getInstance().getNumHD();
                this.freeDevCount = VMApp.getInstance().getFreeHDNum();
            }
        }
        this.constructDeviceControlPanel(n2, n, stringArray);
    }

    private void constructDeviceControlPanel(int n, int n2, String[] stringArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Border border = BorderFactory.createEtchedBorder();
        this.connectButton = this.createConnectButton(n2, n);
        this.devicePanel = new DevicePanel(stringArray, n2, n);
        this.instanceScrollPane = new JScrollPane(this.devicePanel, 20, 30);
        this.instanceScrollPane.setPreferredSize(new Dimension(400, 70));
        this.instancePanel = new JPanel();
        this.instancePanel.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridy = 0;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.deviceLabelText + VMApp.getInstance().getRomanNumber(n), 0, 1);
        this.instancePanel.setBorder(titledBorder);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.fill = 2;
        this.instancePanel.add((Component)this.createPhysicalDevPanel(n2), gridBagConstraints);
        if (n2 == 2 && JViewer.IsClientAdmin() && System.getProperty("os.name").toLowerCase().contains("windows")) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    if (!string.startsWith(LocaleStrings.getString("A_5_DP"))) continue;
                    if (this.getPhysicalDrive() != null) {
                        this.getPhysicalDrive().setVisible(true);
                    }
                    if (this.getLogicalDrive() != null) {
                        this.getLogicalDrive().setVisible(true);
                    }
                    break;
                }
            } else {
                if (this.getPhysicalDrive() != null) {
                    this.getPhysicalDrive().setVisible(false);
                }
                if (this.getLogicalDrive() != null) {
                    this.getLogicalDrive().setVisible(false);
                }
            }
        }
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridy = 1;
        this.instancePanel.add((Component)this.instanceScrollPane, gridBagConstraints);
        this.connectPanel = new JPanel(new BorderLayout(0, 4));
        this.connectPanel.add((Component)this.connectButton, "Center");
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.gridx = 1;
        this.instancePanel.add((Component)this.connectPanel, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints2.insets = new Insets(10, 5, 5, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = -1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 23;
        gridBagConstraints2.fill = 2;
        this.add((Component)this.instancePanel, gridBagConstraints2);
    }

    private JButton createConnectButton(int n, int n2) {
        JButton jButton = new JButton(LocaleStrings.getString("AJ_4_DCP"));
        switch (n) {
            case 0: {
                jButton.setActionCommand("CONNECT_CD_" + n2);
                break;
            }
            case 2: {
                jButton.setActionCommand("CONNECT_HD_" + n2);
                break;
            }
        }
        jButton.addActionListener(new VMActionListener());
        return jButton;
    }

    public JScrollPane getInstanceScrollPane() {
        return this.instanceScrollPane;
    }

    public JPanel getConnectPanel() {
        return this.connectPanel;
    }

    public JButton getConnectButton() {
        return this.connectButton;
    }

    public DevicePanel getDevicePanel() {
        return this.devicePanel;
    }

    public void setDevicePanel(DevicePanel devicePanel) {
        this.devicePanel = devicePanel;
    }

    public void updateDeviceControlPanel() {
        this.redirectionSource = this.iusbRedirSession.getDeviceRedirSource(this.deviceType, this.deviceIndex);
        if (this.iusbRedirSession.getDeviceRedirStatus(this.deviceType, this.deviceIndex) == 1) {
            this.devicePanel.disableAll();
            this.connectButton.setText(LocaleStrings.getString("AJ_5_DCP"));
            this.devicePanel.selectRadioButton(this.redirectionSource);
            if (JViewer.IsClientAdmin() && this.deviceType == 2 && JViewerApp.getInstance().isWindowsClient()) {
                this.physicalDrive.setEnabled(false);
                this.logicalDrive.setEnabled(false);
            }
        } else if (this.iusbRedirSession.getDeviceStatus(this.deviceType, this.deviceIndex) == 1) {
            this.devicePanel.enableAll();
            this.connectButton.setText(LocaleStrings.getString("AJ_4_DCP"));
            this.devicePanel.selectRadioButton(this.redirectionSource);
            if (JViewer.IsClientAdmin() && this.deviceType == 2 && JViewerApp.getInstance().isWindowsClient()) {
                this.physicalDrive.setEnabled(true);
                this.logicalDrive.setEnabled(true);
            }
        }
        if (!JViewer.isVMApp()) {
            VMApp.getVMPane().updateJVToolbar(this.deviceType);
        }
        VMApp.getVMPane().physicalDriveChangeState(this.deviceType, this.deviceIndex, this.redirectionSource, false);
    }

    private JPanel createPhysicalDevPanel(int n) {
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (n == 2 && JViewer.IsClientAdmin() && System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.driveSelectionGroup = new ButtonGroup();
            this.physicalDrive = new JRadioButton(LocaleStrings.getString("A_5_DP"));
            this.physicalDrive.addActionListener(radioButtonListener);
            this.driveSelectionGroup.add(this.physicalDrive);
            this.physicalDrive.setSelected(true);
            jPanel.add((Component)this.physicalDrive, gridBagConstraints);
            this.physicalDrive.setVisible(false);
            this.logicalDrive = new JRadioButton(LocaleStrings.getString("A_6_DP"));
            this.logicalDrive.addActionListener(radioButtonListener);
            this.driveSelectionGroup.add(this.logicalDrive);
            jPanel.add((Component)this.logicalDrive, gridBagConstraints);
            this.logicalDrive.setVisible(false);
        }
        return jPanel;
    }

    public JRadioButton getLogicalDrive() {
        return this.logicalDrive;
    }

    public JRadioButton getPhysicalDrive() {
        return this.physicalDrive;
    }

    class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton.getText().startsWith(DevicePanel.PHYSICAL_DRIVE_WIN)) {
                DeviceControlPanel.this.getDevicePanel().enableHardDiskDrives(DevicePanel.PHYSICAL_DRIVE_WIN);
            } else if (jRadioButton.getText().startsWith(DevicePanel.LOGICAL_DRIVE_WIN)) {
                DeviceControlPanel.this.getDevicePanel().enableHardDiskDrives(DevicePanel.LOGICAL_DRIVE_WIN);
            }
            DeviceControlPanel.this.getDevicePanel().revalidate();
            DeviceControlPanel.this.getDevicePanel().repaint();
        }
    }
}

