/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.VMPane;
import com.ami.vmedia.gui.VMStatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class VMFrame
extends JFrame {
    private static final int VMFRAME_WIDTH = 800;
    private static final int VMFRAME_HEIGHT = 700;
    private VMPane vmPane;
    private VMStatusBar statusPanel;

    public VMFrame() {
        super(LocaleStrings.getString("G_1_VMD") + " - [ " + JViewer.getIp() + " ]");
        this.setSize(800, 700);
        VMApp.setWidth(800);
        VMApp.setHeight(700);
        this.setLayout(new BorderLayout());
        this.vmPane = new VMPane();
        VMApp.setVMPane(this.vmPane);
        this.statusPanel = VMApp.getVMStatusPanel();
        this.add((Component)this.vmPane, "Center");
        this.add((Component)this.statusPanel, "South");
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VMFrame.this.closeVMFrame();
            }
        });
        this.setIconImage(this.vmPane.getImageIcon("jviewer.jpg").getImage());
    }

    private void closeVMFrame() {
        if (VMApp.getInstance().isCDRedirRunning() || VMApp.getInstance().isHDRedireRunning()) {
            UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
            int n = JOptionPane.showConfirmDialog(JViewer.getMainFrame(), LocaleStrings.getString("C_7_JVF"), LocaleStrings.getString("C_8_JVF"), 0);
            if (n == -1) {
                Debug.out.println("Returning CLOSED_OPTION\n");
                return;
            }
            if (n == 1) {
                Debug.out.println("Returning NO_OPTION\n");
                return;
            }
        }
        VMApp.exit(0);
    }
}

