/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.EncryptionException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.RedirPacket;
import com.ami.iusb.protocol.RedirProtocol;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.communication.Connection;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Selector;
import javax.net.ssl.SSLSocket;

public class PacketMaster {
    private Socket packetSock;
    private Socket Sock;
    private SSLSocket packetSockssl;
    private Selector packetSel;
    private RedirProtocol protocol;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private String host;
    private int port;
    private boolean wakeup = false;
    private static final int IUSB_HDR_SIZE = 32;
    private static final int TIMEOUT_VALUE = 180000;

    public PacketMaster(String string, int n, boolean bl, RedirProtocol redirProtocol, boolean bl2) {
        this.host = string;
        this.port = n;
        this.protocol = redirProtocol;
    }

    public void setupBuffers(int n, int n2) {
        this.netIn = ByteBuffer.allocateDirect(n);
        this.netOut = ByteBuffer.allocateDirect(n2);
        this.appIn = this.netIn;
        this.appOut = this.netOut;
        Debug.out.println("No SSL, allocating only netIn and netOut...");
        Debug.out.println("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
        Debug.out.println("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
    }

    public void setupBuffers(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.netIn = byteBuffer;
        this.netOut = byteBuffer2;
        this.appIn = this.netIn;
        this.appOut = this.netOut;
        this.netIn.clear();
        this.netOut.clear();
        Debug.out.println("No SSL, using provided buffers exclusively");
    }

    public void setBufferEndianness(ByteOrder byteOrder, ByteOrder byteOrder2) {
        this.appIn.order(byteOrder);
        this.appOut.order(byteOrder2);
    }

    public int connectVmedia(boolean bl) {
        try {
            int n = bl ? 2 : 0;
            this.packetSock = JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByName(this.host), this.port, n);
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        if (this.packetSock == null) {
            if (bl && JViewerApp.getInstance().getConnection().getConnErrCode() == Connection.SUCCESS) {
                JViewerApp.getInstance().getVMDialog().disposeVMDialog();
            } else {
                return -1;
            }
        }
        this.setSock(this.packetSock);
        return 0;
    }

    public Socket getSock() {
        return this.Sock;
    }

    public void setSock(Socket socket) {
        this.Sock = socket;
    }

    public void VmediaSockclose() throws IOException {
        if (JViewer.isSinglePortEnabled()) {
            if (this.getSock() != null) {
                this.getSock().close();
            }
        } else {
            if (this.packetSock != null) {
                this.packetSock.close();
            }
            if (this.packetSockssl != null) {
                this.packetSockssl.close();
            }
        }
    }

    public void wakeup() {
        this.wakeup = true;
        if (this.packetSel.isOpen()) {
            this.packetSel.wakeup();
        }
    }

    public void sendPacket(RedirPacket redirPacket) throws IOException, EncryptionException {
        this.appOut.clear();
        this.netOut.clear();
        redirPacket.writePacket(this.appOut);
        this.appOut.flip();
        byte[] byArray = new byte[this.netOut.remaining()];
        this.netOut.get(byArray);
        this.getSock().getOutputStream().write(byArray);
    }

    public RedirPacket receivePacket(boolean bl) throws IOException, RedirectionException {
        int n = 0;
        RedirPacket redirPacket = null;
        if (this.appIn.position() != 0) {
            this.appIn.flip();
            redirPacket = this.protocol.getPacket(this.appIn);
            if (redirPacket == null) {
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
            } else {
                Debug.out.println("Got a packet!");
            }
        }
        while (redirPacket == null) {
            byte[] byArray = new byte[32];
            n = this.read_data(byArray);
            if (n < 0) {
                throw new IOException(LocaleStrings.getString("8_2_PACKETMAST"));
            }
            this.netIn.put(byArray);
            this.netIn.position(12);
            long l = (long)this.netIn.getInt() & 0xFFFFFFFFFFFFFFFFL;
            byte[] byArray2 = new byte[(int)l];
            n = 0;
            n = this.read_data(byArray2);
            if (n < 0) {
                throw new IOException(LocaleStrings.getString("8_2_PACKETMAST"));
            }
            this.netIn.position(32);
            this.netIn.put(byArray2, 0, byArray2.length);
            this.netIn.position(0);
            this.netIn.limit(byArray.length + byArray2.length);
            redirPacket = this.protocol.getPacket(this.netIn);
            if (redirPacket == null) {
                Debug.out.println("Can't build a packet from input data");
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
                continue;
            }
            Debug.out.println("Got a packet!");
        }
        if (bl) {
            this.appIn.compact();
        }
        return redirPacket;
    }

    public RedirPacket receivePacket() throws IOException, RedirectionException {
        return this.receivePacket(true);
    }

    public void clearBuffer() {
        this.appIn.compact();
    }

    public void setSocketTimeout() {
        try {
            this.getSock().setSoTimeout(180000);
        }
        catch (SocketException socketException) {
            Debug.out.println(socketException);
        }
    }

    public int read_data(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n2 != 0) {
            try {
                n3 = this.getSock().getInputStream().read(byArray, n, n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n3 <= 0) {
                System.out.println("SOCKET FAILURE");
                return n3;
            }
            n2 -= n3;
            n += n3;
        }
        n3 = byArray.length;
        return n3;
    }
}

