/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.vmedia.VMApp;

public class vCDMonitorThread
extends Thread {
    private CDROMRedir cdromRedir = null;
    private String[] cdromList = null;
    private String cdromSource = null;
    private boolean cdromThreadStatus = false;
    private boolean isMediaMatched = false;
    private int cddevice_no = 0;

    public vCDMonitorThread(int n) {
        this.cddevice_no = n;
    }

    public void startCDROMMonitor() {
        this.cdromThreadStatus = true;
        this.start();
    }

    public void stopCDROMMonitor() {
        this.cdromThreadStatus = false;
    }

    @Override
    public void run() {
        this.cdromRedir = new CDROMRedir(true);
        this.cdromSource = VMApp.getInstance().getIUSBRedirSession().getCDROMSource(this.cddevice_no);
        this.cdromThreadStatus = true;
        while (this.cdromThreadStatus) {
            try {
                if (!VMApp.getInstance().isCDRedirRunning(this.cddevice_no)) break;
                this.cdromList = this.cdromRedir.getCDROMList();
                if (this.cdromList == null) {
                    VMApp.getInstance().getIUSBRedirSession().StopCDROMRedir(this.cddevice_no, 3);
                    VMApp.getVMPane().getDeviceControlPanel(0, this.cddevice_no).updateDeviceControlPanel();
                } else {
                    for (int i = 0; i < this.cdromList.length; ++i) {
                        if (!this.cdromSource.equals(this.cdromList[i])) continue;
                        this.isMediaMatched = true;
                        break;
                    }
                    if (!this.isMediaMatched) {
                        Debug.out.println("REDIRECTED CDROM MEDIUM REMOVAL HAS BEEN DETECTED, STOPPING REDIRECTION TO PREVENT FURTHER DAMAGE");
                        VMApp.getInstance().getIUSBRedirSession().StopCDROMRedir(this.cddevice_no, 3);
                        VMApp.getVMPane().getDeviceControlPanel(0, this.cddevice_no).updateDeviceControlPanel();
                    } else {
                        this.isMediaMatched = false;
                    }
                }
                vCDMonitorThread.sleep(2000L);
            }
            catch (RedirectionException redirectionException) {
                this.stopCDRedirAbnormal();
                Debug.out.println(redirectionException);
            }
            catch (InterruptedException interruptedException) {
                this.stopCDRedirAbnormal();
                Debug.out.println(interruptedException);
            }
            catch (Exception exception) {
                this.stopCDRedirAbnormal();
                Debug.out.println(exception);
            }
        }
    }

    private void stopCDRedirAbnormal() {
        if (!JViewer.isVMApp() && JViewerApp.getInstance().getVMDialog() != null) {
            JViewerApp.getInstance().getVMDialog().setVisible(false);
        }
        VMApp.getInstance().getIUSBRedirSession().stopCDROMAbnormal(this.cddevice_no);
    }
}

