/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.imageredir;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.protocol.RedirHeader;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class IUSBHeader
extends RedirHeader {
    public static final int IUSB_SIGNATURE_SIZE = 8;
    public static final int IUSB_HEADER_SIZE = 61;
    public static final int HEADER_LEN = 32;
    private static final String IUSB_HEADER = "IUSB    ";
    private static final int IUSB_MAJOR = 1;
    private static final int IUSB_MINOR = 0;
    private byte[] signature;
    private int major;
    private int minor;
    private int headerCheckSum;
    private long dataPacketLen;
    private int serverCaps;
    private int deviceType;
    private int protocol;
    private int direction;
    private int deviceNo;
    private int interfaceNo;
    private int clientData;
    private int instance;
    private long sequenceNo;
    private byte[] key;

    public IUSBHeader(IUSBHeader iUSBHeader) {
        this.setSignature(new byte[8]);
        System.arraycopy(iUSBHeader.getSignature(), 0, this.getSignature(), 0, iUSBHeader.getSignature().length);
        this.setMajor(iUSBHeader.getMajor());
        this.setMinor(iUSBHeader.getMinor());
        this.setHeaderLen(iUSBHeader.getHeaderLen());
        this.setHeaderCheckSum(iUSBHeader.getHeaderCheckSum());
        this.setDataPktLen(iUSBHeader.getDataPktLen());
        this.setServerCaps(iUSBHeader.getServerCaps());
        this.setDeviceType(iUSBHeader.getDeviceType());
        this.setProtocol(iUSBHeader.getProtocol());
        this.setDirection(iUSBHeader.getDirection());
        this.setDeviceNo(iUSBHeader.getDeviceNo());
        this.setInterfaceNo(iUSBHeader.getInterfaceNo());
        this.setClientData(iUSBHeader.getClientData());
        this.setInstance(iUSBHeader.getInstance());
        this.setSeqNo(iUSBHeader.getSeqNo());
        this.setKey(iUSBHeader.getKey());
    }

    public IUSBHeader() {
        this.headerLen = 32;
        this.signature = new byte[8];
        this.key = new byte[4];
    }

    public IUSBHeader(int n) {
        this.signature = IUSB_HEADER.getBytes();
        this.headerLen = 32;
        this.major = 1;
        this.minor = 0;
        this.sequenceNo = 0L;
        this.direction = 128;
        this.dataPacketLen = n;
        this.deviceType = 5;
        this.deviceNo = 0;
        this.interfaceNo = 0;
        this.protocol = 1;
        this.key = new byte[4];
    }

    public IUSBHeader(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[8];
        this.setSignature(new byte[8]);
        this.key = new byte[4];
        byteBuffer.get(byArray, 0, 8);
        for (int i = 0; i < 8; ++i) {
            this.signature[i] = byArray[i];
        }
        this.major = byteBuffer.get() & 0xFF;
        this.minor = byteBuffer.get() & 0xFF;
        this.headerLen = byteBuffer.get() & 0xFF;
        this.headerCheckSum = byteBuffer.get() & 0xFF;
        this.dataPacketLen = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        this.serverCaps = byteBuffer.get() & 0xFF;
        this.deviceType = byteBuffer.get() & 0xFF;
        this.protocol = byteBuffer.get() & 0xFF;
        this.direction = byteBuffer.get() & 0xFF;
        this.deviceNo = byteBuffer.get() & 0xFF;
        this.interfaceNo = byteBuffer.get() & 0xFF;
        this.clientData = byteBuffer.get() & 0xFF;
        this.instance = byteBuffer.get() & 0xFF;
        this.sequenceNo = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        byteBuffer.get(this.key);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getHeaderLen() {
        return this.headerLen;
    }

    public void setHeaderLen(int n) {
        this.headerLen = n;
    }

    public int getHeaderCheckSum() {
        return this.headerCheckSum;
    }

    public void setHeaderCheckSum(int n) {
        this.headerCheckSum = n;
    }

    public long getDataPktLen() {
        return this.dataPacketLen;
    }

    public void setDataPktLen(long l) {
        this.dataPacketLen = l;
    }

    public int getServerCaps() {
        return this.serverCaps;
    }

    public void setServerCaps(int n) {
        this.serverCaps = n;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int n) {
        this.deviceType = n;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDeviceNo() {
        return this.deviceNo;
    }

    public void setDeviceNo(int n) {
        this.deviceNo = n;
    }

    public int getInterfaceNo() {
        return this.interfaceNo;
    }

    public void setInterfaceNo(int n) {
        this.interfaceNo = n;
    }

    public int getClientData() {
        return this.clientData;
    }

    public void setClientData(int n) {
        this.clientData = n;
    }

    public int getInstance() {
        return this.instance;
    }

    public void setInstance(int n) {
        this.instance = n;
    }

    public long getSeqNo() {
        return this.sequenceNo;
    }

    public void setSeqNo(long l) {
        this.sequenceNo = l;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] byArray) {
        this.key = byArray;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws RedirProtocolException, BufferUnderflowException {
        byteBuffer.get(this.signature);
        String string = new String(this.signature);
        if (!string.equals(IUSB_HEADER)) {
            Debug.out.dump(this.signature);
            throw new RedirProtocolException(LocaleStrings.getString("7_1_IUSBH"));
        }
        this.major = byteBuffer.get() & 0xFF;
        this.minor = byteBuffer.get() & 0xFF;
        this.headerLen = byteBuffer.get() & 0xFF;
        this.headerCheckSum = byteBuffer.get() & 0xFF;
        this.dataPacketLen = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        this.serverCaps = byteBuffer.get() & 0xFF;
        this.deviceType = byteBuffer.get() & 0xFF;
        this.protocol = byteBuffer.get() & 0xFF;
        this.direction = byteBuffer.get() & 0xFF;
        this.deviceNo = byteBuffer.get() & 0xFF;
        this.interfaceNo = byteBuffer.get() & 0xFF;
        this.clientData = byteBuffer.get() & 0xFF;
        this.instance = byteBuffer.get() & 0xFF;
        this.sequenceNo = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        byteBuffer.get(this.key);
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        byteBuffer.put(this.signature);
        byteBuffer.put((byte)(this.major & 0xFF));
        byteBuffer.put((byte)(this.minor & 0xFF));
        byteBuffer.put((byte)(this.headerLen & 0xFF));
        byteBuffer.put((byte)(this.headerCheckSum & 0xFF));
        byteBuffer.putInt((int)(this.dataPacketLen & 0xFFFFFFFFFFFFFFFFL));
        byteBuffer.put((byte)(this.serverCaps & 0xFF));
        byteBuffer.put((byte)(this.deviceType & 0xFF));
        byteBuffer.put((byte)(this.protocol & 0xFF));
        byteBuffer.put((byte)(this.direction & 0xFF));
        byteBuffer.put((byte)(this.deviceNo & 0xFF));
        byteBuffer.put((byte)(this.interfaceNo & 0xFF));
        byteBuffer.put((byte)(this.clientData & 0xFF));
        byteBuffer.put((byte)(this.instance & 0xFF));
        byteBuffer.putInt((int)(this.sequenceNo & 0xFFFFFFFFFFFFFFFFL));
        byteBuffer.put(this.key);
        int n = 0;
        for (int i = 0; i < byteBuffer.limit(); ++i) {
            n = n + (byteBuffer.get(i) & 0xFF) & 0xFF;
        }
        byteBuffer.put(11, -((byte)(n & 0xFF)));
    }
}

