/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.imageredir;

import com.ami.kvm.imageredir.IUSBHeader;
import com.ami.kvm.imageredir.SCSICommandPacket;
import com.ami.kvm.imageredir.SCSIStatusPacket;
import java.nio.ByteBuffer;

public class IUSBSCSIPacket {
    private IUSBHeader header;
    private int readLen;
    private int tagNo;
    private byte dataDir;
    private SCSICommandPacket commandPkt;
    private SCSIStatusPacket statusPkt;
    private int dataLen;
    private byte data;
    private int[] values;

    public IUSBSCSIPacket(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        this.setHeader(new IUSBHeader(byteBuffer));
        this.setReadLen(byteBuffer.getInt());
        this.setTagNo(byteBuffer.getInt());
        this.setDataDir(byteBuffer.get());
        this.setCommandPkt(new SCSICommandPacket(byteBuffer));
        this.setStatusPkt(new SCSIStatusPacket(byteBuffer));
        this.setDataLen(byteBuffer.getInt());
        byteBuffer.rewind();
    }

    public int getReadLen() {
        return this.readLen;
    }

    public void setReadLen(int n) {
        this.readLen = n & 0xFF;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public void setTagNo(int n) {
        this.tagNo = n & 0xFF;
    }

    public int getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(int n) {
        this.dataDir = (byte)n;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(int n) {
        this.dataLen = n;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int n) {
        this.data = (byte)n;
    }

    public IUSBHeader getHeader() {
        return this.header;
    }

    public void setHeader(IUSBHeader iUSBHeader) {
        this.header = iUSBHeader;
    }

    public SCSICommandPacket getCommandPkt() {
        return this.commandPkt;
    }

    public void setCommandPkt(SCSICommandPacket sCSICommandPacket) {
        this.commandPkt = sCSICommandPacket;
    }

    public SCSIStatusPacket getStatusPkt() {
        return this.statusPkt;
    }

    private void setStatusPkt(SCSIStatusPacket sCSIStatusPacket) {
        this.statusPkt = sCSIStatusPacket;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] nArray) {
        this.values = nArray;
    }
}

