/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.imageredir;

import com.ami.kvm.imageredir.Cmd10;
import com.ami.kvm.imageredir.Cmd12;
import java.nio.ByteBuffer;

public class SCSICommandPacket {
    public static final int SCSI_TEST_UNIT_READY = 0;
    public static final int SCSI_READ_CAPACITY = 37;
    public static final int SCSI_READ_10 = 40;
    public static final int SCSI_READ_12 = 168;
    public static final int SCSI_READ_TOC = 67;
    public static final int SCSI_START_STOP_UNIT = 27;
    public static final int SCSI_MEDIUM_REMOVAL = 30;
    private int opCode;
    private byte lun;
    private int lba;
    private Cmd10 cmd10;
    private Cmd12 cmd12;

    public SCSICommandPacket(SCSICommandPacket sCSICommandPacket) {
        this.setOpCode(sCSICommandPacket.getOpCode());
        this.setLun(sCSICommandPacket.getLun());
        this.setLba(sCSICommandPacket.getLba());
        this.getCmd10().setReserved6(sCSICommandPacket.getCmd10().getReserved6());
        this.getCmd10().setLength(sCSICommandPacket.getCmd10().getLength());
        System.arraycopy(sCSICommandPacket.getCmd10().getReserved9(), 0, this.getCmd10().getReserved9(), 0, sCSICommandPacket.getCmd10().getReserved9().length);
        this.getCmd12().setLength32(sCSICommandPacket.getCmd12().getLength32());
        System.arraycopy(sCSICommandPacket.getCmd12().getReserved10(), 0, this.getCmd12().getReserved10(), 0, sCSICommandPacket.getCmd12().getReserved10().length);
    }

    public SCSICommandPacket(ByteBuffer byteBuffer) {
        block3: {
            block2: {
                this.setOpCode(byteBuffer.get() & 0xFF);
                this.setLun(byteBuffer.get());
                this.setLba(byteBuffer.getInt());
                if (this.getOpCode() != 40 && this.getOpCode() != 67) break block2;
                this.setCmd10(new Cmd10());
                this.getCmd10().setReserved6(byteBuffer.get());
                this.getCmd10().setLength(byteBuffer.getShort());
                int n = this.getCmd10().getReserved9().length;
                byte[] byArray = new byte[n];
                this.getCmd10().setReserved9(new byte[n]);
                byteBuffer.get(byArray, 0, n);
                for (int i = 0; i < byArray.length; ++i) {
                    this.getCmd10().getReserved9()[i] = byArray[i];
                }
                break block3;
            }
            if (this.getOpCode() != 168) break block3;
            this.setCmd12(new Cmd12());
            this.getCmd12().setLength32(byteBuffer.getInt());
            int n = this.getCmd12().getReserved10().length;
            byte[] byArray = new byte[n];
            this.getCmd12().setReserved10(new byte[n]);
            byteBuffer.get(byArray, 0, n);
            for (int i = 0; i < byArray.length; ++i) {
                this.getCmd12().getReserved10()[i] = byArray[i];
            }
        }
    }

    public SCSICommandPacket() {
    }

    public Cmd10 getCmd10() {
        return this.cmd10;
    }

    public void setCmd10(Cmd10 cmd10) {
        this.cmd10 = cmd10;
    }

    public Cmd12 getCmd12() {
        return this.cmd12;
    }

    public void setCmd12(Cmd12 cmd12) {
        this.cmd12 = cmd12;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public void setOpCode(int n) {
        this.opCode = n;
    }

    public byte getLun() {
        return this.lun;
    }

    public void setLun(byte by) {
        this.lun = by;
    }

    public int getLba() {
        return this.lba;
    }

    public void setLba(int n) {
        this.lba = n;
    }
}

