/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.communication.Connection;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMSharing;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.net.ssl.SSLSocket;

public abstract class Client {
    protected Socket m_sock = null;
    protected Socket m_sock_nonssl = null;
    protected SSLSocket m_sock_ssl = null;
    protected byte[] m_ipAddr;
    protected int m_port;

    public Client(byte[] byArray, int n) {
        this.m_ipAddr = byArray;
        this.m_port = n;
    }

    public void SetSocket(Socket socket) {
        this.m_sock = socket;
    }

    public Socket getSocket() {
        return this.m_sock;
    }

    protected int connectVideo(boolean bl) {
        try {
            int n = bl ? 2 : 0;
            this.m_sock = JViewerApp.getInstance().getConnection().createSocket(InetAddress.getByAddress(this.m_ipAddr), this.m_port, n);
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
            return -1;
        }
        if (this.m_sock == null) {
            if (bl && JViewerApp.getInstance().getConnection().getConnErrCode() == Connection.SUCCESS) {
                JViewerApp.getInstance().getMainWindow().windowClosed();
            } else {
                return -1;
            }
        }
        if (JViewer.isKVMReconnectEnabled()) {
            JViewerApp.getInstance().setLocalport(this.m_sock.getLocalPort());
        }
        this.SetSocket(this.m_sock);
        String string = this.m_sock.getLocalAddress().toString();
        String[] stringArray = string.split("/");
        KVMSharing.KVM_CLIENT_OWN_IP = stringArray[1];
        if (KVMSharing.KVM_CLIENT_OWN_IP.compareToIgnoreCase("0.0.0.0") == 0) {
            KVMSharing.KVM_CLIENT_OWN_IP = this.getipv6IP();
        }
        Debug.out.println("m_sock.socket().getLocalAddress()" + string.toString());
        Debug.out.println("m_sock.socket().getLocalAddress()" + KVMSharing.KVM_CLIENT_OWN_IP);
        return 0;
    }

    public int sendMessage(byte[] byArray, int n) {
        if (!JViewer.isplayerapp() && !JViewer.isdownloadapp()) {
            try {
                this.getSocket().getOutputStream().write(byArray);
            }
            catch (IOException iOException) {
                if (JViewer.isKVMReconnectEnabled() && (JViewer.isjviewerapp() || JViewer.isStandAloneApp())) {
                    JViewerApp.getInstance().onReconnect();
                }
                Debug.out.println("Send message failed");
                Debug.out.println(iOException);
                return 0;
            }
        }
        if (JViewer.isKVMReconnectEnabled()) {
            JViewerApp.getInstance().setLastPckSent();
        }
        return n;
    }

    public void VideoSocketclose() {
        try {
            if (JViewer.isSinglePortEnabled()) {
                if (this.getSocket() != null) {
                    this.getSocket().close();
                }
            } else {
                if (this.m_sock_nonssl != null) {
                    this.m_sock_nonssl.close();
                    this.m_sock_nonssl = null;
                    this.m_sock = null;
                }
                if (this.m_sock_ssl != null) {
                    this.m_sock_ssl.close();
                    this.m_sock_ssl = null;
                    this.m_sock = null;
                }
            }
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
    }

    public String getipv6IP() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            Debug.out.println(socketException);
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Debug.out.println("NetworkInterface name: " + networkInterface.getDisplayName());
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                InetAddress inetAddress2 = null;
                try {
                    inetAddress2 = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    Debug.out.println(unknownHostException);
                }
                String string = inetAddress2.getHostAddress();
                String string2 = inetAddress.toString();
                String[] stringArray = string2.split("/");
                if (string.compareTo(stringArray[1]) == 0) {
                    Debug.out.println("CONTINUING LOOP");
                    continue;
                }
                Debug.out.println("" + Client.isProperIPv6Address(stringArray[1]));
                if (!Client.isProperIPv6Address(stringArray[1])) continue;
                Debug.out.println("VALID IPV6IP::" + stringArray[1]);
                return stringArray[1];
            }
        }
        return null;
    }

    public static boolean isProperIPv6Address(String string) {
        String[] stringArray = new String[]{"fc80", "fec0", "ff"};
        String[] stringArray2 = string.split(":");
        try {
            InetAddress inetAddress = Inet6Address.getByName(string);
            if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress()) {
                Debug.out.println("Returning false because LOOPBACK");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray2[0].compareToIgnoreCase(stringArray[i]) != 0) continue;
                Debug.out.println("Returning false because RESERVED IP");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            return false;
        }
    }

    public abstract void onReadEvent();
}

