/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public class Connection {
    public static int SUCCESS = 0;
    public static int INVALID_SOCKET = -1;
    public static int SOCK_CREAT_FAILED = -2;
    private boolean validateSSLCert = true;
    private boolean webSSLVerfiy = true;
    private boolean kvmSSLVerify = true;
    private int connErrCode = INVALID_SOCKET;
    public static final int SSL_HANDSHAKE_TIMEOUT = 5000;
    public static final int SOCKET_CONNECT_TIMEOUT = 900;
    private boolean connectHTTPPort = false;

    public SSLSocketFactory getSocketFactory() {
        SSLContext sSLContext = null;
        SSLSocketFactory sSLSocketFactory = null;
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext2 = SSLContext.getInstance("TLSv1.2");
            sSLContext2.init(null, trustManagerArray, new SecureRandom());
            sSLContext = sSLContext2;
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.out.println(noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            Debug.out.println(keyManagementException);
        }
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocket createSSLSocket(InetAddress inetAddress, int n, int n2) {
        SSLSocketFactory sSLSocketFactory;
        SSLSocket sSLSocket = null;
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        if (n2 == 1) {
            this.validateSSLCert = Debug.VERIFYSSLCERTS == 1 ? this.webSSLVerfiy : false;
        } else {
            boolean bl2 = this.validateSSLCert = Debug.VERIFYSSLCERTS == 1 ? this.kvmSSLVerify : false;
        }
        if (this.validateSSLCert) {
            SSLSocketFactory sSLSocketFactory2 = (SSLSocketFactory)SSLSocketFactory.getDefault();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            sSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            try {
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(inetAddress, n);
            }
            catch (UnknownHostException unknownHostException) {
                Debug.out.println(unknownHostException);
                sSLSocket = null;
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                sSLSocket = null;
            }
            catch (NullPointerException nullPointerException) {
                Debug.out.println(nullPointerException);
                sSLSocket = null;
            }
            if (sSLSocket != null) {
                try {
                    n4 = sSLSocket.getSoTimeout();
                    sSLSocket.setSoTimeout(5000);
                    sSLSocket.startHandshake();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Debug.out.println(socketTimeoutException);
                    try {
                        this.connectHTTPPort = true;
                        sSLSocket.close();
                    }
                    catch (IOException iOException) {
                        Debug.out.println(iOException);
                    }
                    finally {
                        sSLSocket = null;
                    }
                }
                catch (SSLException sSLException) {
                    Debug.out.println(sSLException);
                    bl = false;
                    this.validateSSLCert = false;
                }
                catch (IOException iOException) {
                    Debug.out.println(iOException);
                    bl = false;
                    this.validateSSLCert = false;
                }
                finally {
                    try {
                        if (sSLSocket != null) {
                            sSLSocket.setSoTimeout(n4);
                        }
                    }
                    catch (SocketException socketException) {
                        Debug.out.println(socketException);
                    }
                }
                if (!bl && (n3 = JOptionPane.showConfirmDialog(JViewerApp.getInstance().getConnectionDialog(), LocaleStrings.getString("Z_9_URLP") + LocaleStrings.getString("Z_10_URLP"), LocaleStrings.getString("Z_8_URLP"), 0, 2)) != 0) {
                    try {
                        sSLSocket.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return null;
                }
            }
        }
        if (!this.validateSSLCert) {
            if (n2 == 1) {
                this.webSSLVerfiy = this.validateSSLCert;
            } else {
                this.kvmSSLVerify = this.validateSSLCert;
            }
            sSLSocketFactory = this.getSocketFactory();
            try {
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
                sSLSocket.connect(new InetSocketAddress(inetAddress, n), 900);
            }
            catch (UnknownHostException unknownHostException) {
                Debug.out.println(unknownHostException);
                sSLSocket = null;
            }
            catch (IOException iOException) {
                Debug.out.println(iOException);
                sSLSocket = null;
            }
        }
        if (sSLSocket == null) {
            this.connErrCode = SOCK_CREAT_FAILED;
            if (JViewerApp.getInstance().getConnectionDialog() != null && !JViewerApp.getInstance().getRetryConnection()) {
                if (this.connectHTTPPort) {
                    n3 = JOptionPane.showConfirmDialog(JViewerApp.getInstance().getConnectionDialog(), LocaleStrings.getString("Z_12_URLP"), LocaleStrings.getString("Z_11_URLP"), 0, 2);
                    if (n3 != 0) {
                        this.connectHTTPPort = false;
                    }
                } else {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getConnectionDialog(), LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
                }
            } else if (!JViewerApp.getInstance().getRetryConnection()) {
                JOptionPane.showMessageDialog(JViewer.getMainFrame(), LocaleStrings.getString("S_11_SACD"), LocaleStrings.getString("S_9_SACD"), 0);
            }
        }
        return sSLSocket;
    }

    private Socket createNonSSLSocket(InetAddress inetAddress, int n) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(inetAddress, n), 900);
        }
        catch (Exception exception) {
            this.connErrCode = SOCK_CREAT_FAILED;
            Debug.out.println(exception);
            socket = null;
        }
        return socket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) {
        Socket socket = null;
        this.connErrCode = SUCCESS;
        if (n2 > 0) {
            socket = this.createSSLSocket(inetAddress, n, n2);
            if (this.connectHTTPPort && socket == null) {
                JViewer.setWebSecure(0);
                JViewer.setUseSSL(false);
                JViewer.setSecureChannel(0);
                JViewer.setVMSecureChannel(0);
                JViewer.setVMUseSSL(false);
                JViewer.setWebSecure(0);
                socket = this.createNonSSLSocket(inetAddress, n);
            }
        } else if (n2 == 0) {
            socket = this.createNonSSLSocket(inetAddress, n);
        }
        return socket;
    }

    public boolean isWebSSLVerify() {
        return this.webSSLVerfiy;
    }

    public void setWebSSLVerify(boolean bl) {
        this.webSSLVerfiy = bl;
    }

    public boolean isKvmSSLVerify() {
        return this.kvmSSLVerify;
    }

    public void setKvmSSLVerify(boolean bl) {
        this.kvmSSLVerify = bl;
    }

    public int getConnErrCode() {
        return this.connErrCode;
    }
}

