/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;

public class KVMShareDialog {
    public static final boolean FIRST_USER = true;
    public static final boolean SECOND_USER = false;
    public static final byte KVM_SHARING = 0;
    public static final byte KVM_SELECT_MASTER = 1;
    public static final byte KVM_FULL_PERMISSION_REQUEST = 2;
    public static boolean isMasterSession;
    private int kvmsDecisionDuration = 30;
    private final int NORTH_PANEL_STRUT = 150;
    private JButton kvmsSubmitButton = null;
    private JLabel kvmsRequestLabel = new JLabel();
    private JDialog kvmsResponseDialog = null;
    private JDialog kvmsRequestDialog = null;
    private Timer kvmsTimer = null;
    private JLabel kvmsTimerLabel = new JLabel();
    private JLabel mediaRedirStatus = new JLabel();
    private JRadioButton fullAccessChoice = new JRadioButton(LocaleStrings.getString("H_1_KVMS"), false);
    private JRadioButton partialAccessChoice = new JRadioButton(LocaleStrings.getString("H_2_KVMS"), false);
    private JRadioButton denyAccessChoice = new JRadioButton(LocaleStrings.getString("H_3_KVMS"), false);
    private JPanel kvmsNorthPanel = null;
    private JPanel kvmsCenterPanel = null;
    private JPanel kvmsSouthPanel = null;
    private JPanel kvmsResponsePanel = null;
    private JLabel kvmsResponseLabel = null;
    private JPanel kvmsRequestPanel = null;
    private ButtonGroup kvmsButtonGroup = null;
    private byte dialogType;
    private String reqUserDetails = null;
    private JRadioButton blockRequests = new JRadioButton(LocaleStrings.getString("F_149_JVM"), false);
    private JComboBox blockPermission_comboBox = new JComboBox();

    public KVMShareDialog() {
        this.blockPermission_comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{LocaleStrings.getString("H_2_KVMS"), LocaleStrings.getString("H_3_KVMS")}));
        this.blockPermission_comboBox.setSelectedIndex(0);
        this.kvmsResponsePanel = new JPanel();
        this.kvmsRequestPanel = new JPanel();
    }

    private void constructResponseDialog(byte by) {
        this.dialogType = by;
        this.constructNorthPanel();
        this.constructCenterPanel();
        this.constructSouthPanel();
        this.kvmsResponsePanel.setLayout(new BorderLayout());
        this.kvmsResponsePanel.add((Component)this.kvmsNorthPanel, "North");
        this.kvmsResponsePanel.add((Component)this.kvmsCenterPanel, "Center");
        this.kvmsResponsePanel.add((Component)this.kvmsSouthPanel, "South");
        JFrame jFrame = JViewer.getMainFrame();
        this.kvmsResponseDialog = new JDialog(jFrame, LocaleStrings.getString("H_6_KVMS"), true);
        if (by != 1) {
            this.kvmsResponseDialog.setModal(false);
        }
        this.kvmsResponseDialog.add(this.kvmsResponsePanel);
        this.kvmsResponseDialog.pack();
        this.kvmsResponseDialog.setResizable(false);
        this.kvmsResponseDialog.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(this.kvmsResponseDialog.getWidth(), this.kvmsResponseDialog.getHeight()));
        this.kvmsResponseDialog.repaint();
        this.kvmsResponseDialog.addKeyListener(new KVMShareDialogKeyListener());
        this.kvmsResponseDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JViewerApp jViewerApp = JViewerApp.getInstance();
                Debug.out.println("Deny is Request");
                if (KVMShareDialog.this.dialogType == 2) {
                    jViewerApp.OnSendKVMPrevilage((byte)2, KVMShareDialog.this.reqUserDetails);
                } else if (KVMShareDialog.this.dialogType == 0) {
                    jViewerApp.OnSendKVMPrevilage((byte)1, KVMShareDialog.this.reqUserDetails);
                }
                KVMShareDialog.this.getKVMShareResponseDialog().dispose();
                KVMShareDialog.this.getTimer().stop();
                KVMShareDialog.this.kvmsDecisionDuration = 30;
                if (KVMShareDialog.this.reqUserDetails != null) {
                    JViewerApp.getInstance().getResponseDialogTable().remove(KVMShareDialog.this.reqUserDetails);
                }
                KVMShareDialog.this.kvmsTimerLabel.setText("");
            }
        });
        this.reqUserDetails = KVMSharing.KVM_CLIENT_USERNAME + " : " + KVMSharing.KVM_CLIENT_IP + " : " + KVMSharing.KVM_CLIENT_SESSION_INDEX;
        JViewerApp.getInstance().initResponseDialogTable();
        JViewerApp.getInstance().getResponseDialogTable().put(this.reqUserDetails, this.kvmsResponseDialog);
    }

    private void constructNorthPanel() {
        String string = "";
        if (this.kvmsNorthPanel == null) {
            this.kvmsNorthPanel = new JPanel();
        } else {
            this.kvmsNorthPanel.removeAll();
        }
        this.kvmsNorthPanel.setLayout(new FlowLayout(3));
        if (this.dialogType == 0 || this.dialogType == 2) {
            string = LocaleStrings.getString("H_4_KVMS") + " " + KVMSharing.KVM_CLIENT_USERNAME + "(" + JViewerApp.getInstance().getIpmiPrivText(KVMSharing.KVM_CLIENT_IPMI_PRIV) + ")" + " " + LocaleStrings.getString("H_5_KVMS") + " " + KVMSharing.KVM_CLIENT_IP;
        } else if (this.dialogType == 1) {
            string = LocaleStrings.getString("H_13_KVMS");
            this.kvmsNorthPanel.add(Box.createHorizontalStrut(150));
        }
        if (this.kvmsResponseLabel == null) {
            this.kvmsResponseLabel = new JLabel(string);
        } else {
            this.kvmsResponseLabel.setText(string);
        }
        this.kvmsRequestLabel.setHorizontalTextPosition(2);
        this.kvmsNorthPanel.add((Component)this.kvmsResponseLabel, 0);
    }

    private void constructCenterPanel() {
        Object object;
        if (this.mediaRedirStatus == null) {
            this.mediaRedirStatus = new JLabel();
        }
        this.mediaRedirStatus.setText(LocaleStrings.getString("H_14_KVMS"));
        this.mediaRedirStatus.setForeground(Color.blue);
        if (this.kvmsCenterPanel == null) {
            this.kvmsCenterPanel = new JPanel();
        } else {
            this.kvmsCenterPanel.removeAll();
        }
        if (this.kvmsButtonGroup == null) {
            this.kvmsButtonGroup = new ButtonGroup();
        } else {
            object = this.kvmsButtonGroup.getElements();
            while (object.hasMoreElements()) {
                this.kvmsButtonGroup.remove(object.nextElement());
            }
        }
        if (this.dialogType == 0 || this.dialogType == 2) {
            if (this.fullAccessChoice == null) {
                this.fullAccessChoice = new JRadioButton(LocaleStrings.getString("H_1_KVMS"), false);
                this.fullAccessChoice.setMnemonic(65);
            }
            if (this.partialAccessChoice == null) {
                this.partialAccessChoice = new JRadioButton(LocaleStrings.getString("H_2_KVMS"), false);
                this.partialAccessChoice.setMnemonic(86);
            }
            if (this.blockRequests == null) {
                this.blockRequests = new JRadioButton(LocaleStrings.getString("F_149_JVM"), false);
                this.blockRequests.setMnemonic(66);
            }
            if (this.denyAccessChoice == null) {
                this.denyAccessChoice = new JRadioButton(LocaleStrings.getString("H_3_KVMS"), false);
                this.denyAccessChoice.setMnemonic(68);
            }
            this.kvmsCenterPanel.setLayout(this.getGridBagLayout());
            object = new RadioListener();
            this.fullAccessChoice.addActionListener((ActionListener)object);
            this.partialAccessChoice.addActionListener((ActionListener)object);
            this.denyAccessChoice.addActionListener((ActionListener)object);
            this.blockRequests.addActionListener((ActionListener)object);
            this.kvmsButtonGroup.add(this.fullAccessChoice);
            this.kvmsButtonGroup.add(this.partialAccessChoice);
            this.kvmsButtonGroup.add(this.denyAccessChoice);
            this.kvmsButtonGroup.add(this.blockRequests);
            if (this.dialogType == 2) {
                this.denyAccessChoice.removeActionListener((ActionListener)object);
                this.kvmsButtonGroup.remove(this.denyAccessChoice);
                this.denyAccessChoice.setVisible(false);
            }
            this.fullAccessChoice.setSelected(true);
        } else if (this.dialogType == 1) {
            int n = KVMClient.getNumUsers();
            String[] stringArray = KVMClient.getUserData();
            JRadioButton[] jRadioButtonArray = new JRadioButton[n];
            this.kvmsCenterPanel.setLayout(new GridLayout(n - 1, 1));
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i].substring(stringArray[i].indexOf(":") + 1, stringArray[i].length()).trim();
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf(":") - 1).trim();
                if (Integer.parseInt(string2) == JViewerApp.getInstance().getCurrentSessionId()) continue;
                jRadioButtonArray[i] = new JRadioButton(string);
                jRadioButtonArray[i].setActionCommand(stringArray[i]);
                this.kvmsCenterPanel.add(jRadioButtonArray[i]);
                this.kvmsButtonGroup.add(jRadioButtonArray[i]);
            }
        }
        this.kvmsCenterPanel.repaint();
    }

    private void constructSouthPanel() {
        if (this.kvmsSouthPanel == null) {
            this.kvmsSouthPanel = new JPanel();
            this.kvmsSouthPanel.setLayout(new FlowLayout());
            if (this.kvmsSubmitButton == null) {
                this.initSubmitButton();
            }
            if (this.kvmsTimerLabel == null) {
                this.kvmsTimerLabel = new JLabel();
            }
            if (this.dialogType == 1) {
                this.kvmsTimerLabel.setText("(10 " + LocaleStrings.getString("H_7_KVMS") + " )");
            } else {
                this.kvmsTimerLabel.setText("(30 " + LocaleStrings.getString("H_7_KVMS") + " )");
            }
            this.kvmsSouthPanel.add(this.kvmsSubmitButton);
            this.kvmsSouthPanel.add(this.kvmsTimerLabel);
        }
    }

    private void initSubmitButton() {
        this.kvmsSubmitButton = new JButton(LocaleStrings.getString("A_3_GLOBAL"));
        KVMShareDialogButtonListener kVMShareDialogButtonListener = new KVMShareDialogButtonListener();
        this.kvmsSubmitButton.addActionListener(kVMShareDialogButtonListener);
    }

    private GridBagLayout getGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.kvmsCenterPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.kvmsCenterPanel.add((Component)this.fullAccessChoice, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        this.kvmsCenterPanel.add((Component)this.partialAccessChoice, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        this.kvmsCenterPanel.add((Component)this.denyAccessChoice, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        this.kvmsCenterPanel.add((Component)this.blockRequests, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 3;
        this.kvmsCenterPanel.add((Component)this.blockPermission_comboBox, gridBagConstraints5);
        this.blockPermission_comboBox.setSelectedIndex(0);
        this.blockPermission_comboBox.setVisible(false);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 4;
        this.kvmsCenterPanel.add((Component)this.mediaRedirStatus, gridBagConstraints6);
        return gridBagLayout;
    }

    private void showResponseDialog() {
        this.kvmsResponseDialog.setVisible(true);
        this.kvmsResponseDialog.repaint();
        this.kvmsResponseDialog.requestFocus();
    }

    private void constructRequestDialog() {
        JFrame jFrame = JViewer.getMainFrame();
        this.kvmsRequestDialog = new JDialog(jFrame, "", false);
        this.kvmsRequestPanel.setLayout(new BorderLayout());
        this.kvmsRequestPanel.add((Component)this.kvmsRequestLabel, "Center");
        this.kvmsRequestDialog.setSize(900, 50);
        this.kvmsRequestDialog.add(this.kvmsRequestPanel);
        this.kvmsRequestDialog.setUndecorated(true);
        this.kvmsRequestDialog.setResizable(false);
        this.kvmsRequestDialog.setLocation(JViewerApp.getInstance().getPopUpWindowPosition(this.kvmsRequestDialog.getWidth(), this.kvmsRequestDialog.getHeight()));
    }

    private void showRequestDialog() {
        this.kvmsRequestLabel.setText("       " + LocaleStrings.getString("H_8_KVMS") + " " + KVMSharing.KVM_CLIENT_USERNAME + " " + LocaleStrings.getString("H_5_KVMS") + " " + KVMSharing.KVM_CLIENT_IP + "(30 " + LocaleStrings.getString("H_7_KVMS") + " )");
        this.kvmsRequestDialog.setVisible(true);
        this.kvmsRequestDialog.requestFocus();
    }

    public void setUserStatus(boolean bl) {
        isMasterSession = bl;
    }

    public void constructDialog(byte by) {
        this.kvmsTimer = new Timer(1000, new KVMShareDialogListener());
        this.kvmsDecisionDuration = by == 1 ? 10 : 30;
        if (isMasterSession) {
            this.constructResponseDialog(by);
        } else {
            this.constructRequestDialog();
        }
    }

    public void showDialog() {
        this.kvmsTimer.start();
        if (isMasterSession) {
            this.showResponseDialog();
        } else {
            this.showRequestDialog();
        }
    }

    public void showInformationDialog(String string) {
        JVFrame jVFrame = JViewerApp.getInstance().getMainWindow();
        JOptionPane.showMessageDialog(jVFrame, string, LocaleStrings.getString("H_10_KVMS"), 1);
    }

    public JButton getOkButton() {
        return this.kvmsSubmitButton;
    }

    public JLabel getUserTwoTimerLabel() {
        return this.kvmsRequestLabel;
    }

    public JDialog getKVMShareResponseDialog() {
        return this.kvmsResponseDialog;
    }

    public JDialog getKVMShareRequestDialog() {
        return this.kvmsRequestDialog;
    }

    public Timer getTimer() {
        return this.kvmsTimer;
    }

    public JLabel getTimerLabel() {
        return this.kvmsTimerLabel;
    }

    public JRadioButton getRadioButtonOne() {
        return this.fullAccessChoice;
    }

    public JRadioButton getRadioButtonTwo() {
        return this.partialAccessChoice;
    }

    public JRadioButton getRadioButtonThree() {
        return this.denyAccessChoice;
    }

    public JRadioButton getRadioButtonFour() {
        return this.blockRequests;
    }

    public ButtonGroup getKvmsButtonGroup() {
        return this.kvmsButtonGroup;
    }

    public byte getDialogType() {
        return this.dialogType;
    }

    public void disposeKVMShareResponseDialog() {
        if (this.kvmsTimer != null) {
            this.kvmsTimer.stop();
        }
        this.kvmsDecisionDuration = 30;
        if (this.kvmsResponseDialog != null) {
            this.kvmsResponseDialog.dispose();
            this.kvmsResponseDialog = null;
        }
        if (this.reqUserDetails != null) {
            JViewerApp.getInstance().getResponseDialogTable().remove(this.reqUserDetails);
        }
    }

    public void disposeKVMShareReqestDialog() {
        if (this.kvmsTimer != null) {
            this.kvmsTimer.stop();
        }
        this.kvmsDecisionDuration = 30;
        if (this.kvmsRequestDialog != null) {
            this.kvmsRequestDialog.dispose();
            this.kvmsRequestDialog = null;
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            KVMShareDialog.this.blockPermission_comboBox.setVisible(jRadioButton.equals(KVMShareDialog.this.getRadioButtonFour()));
            if (jRadioButton.getText().contains(LocaleStrings.getString("H_1_KVMS"))) {
                KVMShareDialog.this.mediaRedirStatus.setText(LocaleStrings.getString("H_14_KVMS"));
            } else {
                KVMShareDialog.this.mediaRedirStatus.setText("");
            }
        }
    }

    class KVMShareDialogButtonListener
    implements ActionListener {
        JViewerApp RCApp = JViewerApp.getInstance();

        KVMShareDialogButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(KVMShareDialog.this.getOkButton())) {
                if (KVMShareDialog.this.getDialogType() == 0 || KVMShareDialog.this.getDialogType() == 2) {
                    Debug.out.println("Submit Clicked");
                    if (KVMShareDialog.this.getRadioButtonOne().isSelected()) {
                        Debug.out.println("Allow KVM is Selected");
                        this.RCApp.getM_frame().onStopVMediaRedirection(0);
                        this.RCApp.getKVMClient().SendKVMPrevilage((byte)0, KVMShareDialog.this.reqUserDetails);
                        if (this.RCApp.isFullPermissionRequest()) {
                            this.RCApp.setFullPermissionRequest(false);
                        }
                        Set<Map.Entry<String, JDialog>> set = JViewerApp.getInstance().getResponseDialogTable().entrySet();
                        Iterator<Map.Entry<String, JDialog>> iterator = set.iterator();
                        JDialog jDialog = null;
                        String string = null;
                        while (iterator.hasNext()) {
                            try {
                                Map.Entry<String, JDialog> entry = iterator.next();
                                jDialog = entry.getValue();
                                string = entry.getKey();
                                if (jDialog == null) continue;
                                jDialog.dispose();
                            }
                            catch (Exception exception) {
                                Debug.out.println(exception);
                            }
                        }
                        JViewerApp.getInstance().getResponseDialogTable().clear();
                    } else if (KVMShareDialog.this.getRadioButtonTwo().isSelected()) {
                        Debug.out.println("Allow only Video is Selected");
                        this.RCApp.OnSendKVMPrevilage((byte)2, KVMShareDialog.this.reqUserDetails);
                        KVMShareDialog.this.getKVMShareResponseDialog().dispose();
                        KVMShareDialog.this.getTimer().stop();
                        KVMShareDialog.this.kvmsDecisionDuration = 30;
                        if (KVMShareDialog.this.reqUserDetails != null) {
                            JViewerApp.getInstance().getResponseDialogTable().remove(KVMShareDialog.this.reqUserDetails);
                        }
                    } else if (KVMShareDialog.this.getRadioButtonThree().isSelected()) {
                        Debug.out.println("Deny is Selected");
                        this.RCApp.OnSendKVMPrevilage((byte)1, KVMShareDialog.this.reqUserDetails);
                        KVMShareDialog.this.getKVMShareResponseDialog().dispose();
                        KVMShareDialog.this.getTimer().stop();
                        KVMShareDialog.this.kvmsDecisionDuration = 30;
                        if (KVMShareDialog.this.reqUserDetails != null) {
                            JViewerApp.getInstance().getResponseDialogTable().remove(KVMShareDialog.this.reqUserDetails);
                        }
                    } else if (KVMShareDialog.this.getRadioButtonFour().isSelected()) {
                        if (JViewerApp.getInstance().getJVMenu().getMenu("BlockFullPermission") == null) {
                            JViewerApp.getInstance().getJVMenu().addBlockPermissionMenuItem();
                        }
                        if (KVMShareDialog.this.blockPermission_comboBox.getSelectedIndex() == 0 || KVMShareDialog.this.blockPermission_comboBox.getSelectedIndex() == -1) {
                            Debug.out.println("Block requests : Allow only Video is Selected");
                            this.RCApp.OnSendKVMPrevilage((byte)6, KVMShareDialog.this.reqUserDetails);
                            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("AllowonlyVideo", true);
                        } else {
                            Debug.out.println("Block requests : Deny Access is Selected");
                            this.RCApp.OnSendKVMPrevilage((byte)8, KVMShareDialog.this.reqUserDetails);
                            JViewerApp.getInstance().getJVMenu().notifyMenuStateSelected("DenyAccess", true);
                        }
                        KVMShareDialog.this.getKVMShareResponseDialog().dispose();
                        KVMShareDialog.this.getTimer().stop();
                        KVMShareDialog.this.kvmsDecisionDuration = 30;
                        if (KVMShareDialog.this.reqUserDetails != null) {
                            JViewerApp.getInstance().getResponseDialogTable().remove(KVMShareDialog.this.reqUserDetails);
                        }
                    } else {
                        JOptionPane.showMessageDialog(KVMShareDialog.this.getKVMShareResponseDialog(), LocaleStrings.getString("H_9_KVMS"), LocaleStrings.getString("A_5_GLOBAL"), 0);
                    }
                    KVMShareDialog.this.kvmsTimerLabel.setText("");
                } else if (KVMShareDialog.this.getDialogType() == 1) {
                    if (KVMShareDialog.this.getKvmsButtonGroup().getSelection() != null) {
                        String string = KVMShareDialog.this.getKvmsButtonGroup().getSelection().getActionCommand();
                        if (string == null) {
                            return;
                        }
                        this.RCApp.sendSelectedMasterInfo(string);
                    }
                    KVMShareDialog.this.getKVMShareResponseDialog().dispose();
                    KVMShareDialog.this.getTimer().stop();
                    KVMShareDialog.this.kvmsDecisionDuration = 30;
                }
                return;
            }
        }
    }

    class KVMShareDialogKeyListener
    implements KeyListener {
        KVMShareDialogKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (isMasterSession) {
                if ((keyEvent.getModifiersEx() & 0x200) == 512) {
                    if (keyEvent.getKeyCode() == 66) {
                        KVMShareDialog.this.blockPermission_comboBox.setVisible(true);
                        KVMShareDialog.this.getRadioButtonFour().setSelected(true);
                        KVMShareDialog.this.getRadioButtonFour().repaint();
                    } else {
                        KVMShareDialog.this.blockPermission_comboBox.setVisible(false);
                        if (keyEvent.getKeyCode() == 65) {
                            KVMShareDialog.this.getRadioButtonOne().setSelected(true);
                            KVMShareDialog.this.getRadioButtonOne().repaint();
                        } else if (keyEvent.getKeyCode() == 86) {
                            KVMShareDialog.this.getRadioButtonTwo().setSelected(true);
                            KVMShareDialog.this.getRadioButtonTwo().repaint();
                        } else if (keyEvent.getKeyCode() == 68) {
                            KVMShareDialog.this.getRadioButtonThree().setSelected(true);
                            KVMShareDialog.this.getRadioButtonThree().repaint();
                        }
                    }
                } else if (keyEvent.getKeyCode() == 10) {
                    Debug.out.println("***********ENTER KEY DETECTED********");
                    KVMShareDialog.this.getOkButton().doClick();
                }
                return;
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class KVMShareDialogListener
    implements ActionListener {
        KVMShareDialogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KVMShareDialog.this.kvmsDecisionDuration--;
            if (KVMShareDialog.this.kvmsDecisionDuration <= 0) {
                KVMShareDialog.this.getTimer().stop();
                KVMShareDialog.this.kvmsDecisionDuration = 30;
                if (isMasterSession) {
                    Debug.out.println("User didn't gave any input");
                    if (KVMShareDialog.this.getKVMShareResponseDialog() != null) {
                        KVMShareDialog.this.getKVMShareResponseDialog().dispose();
                    }
                    if (KVMShareDialog.this.reqUserDetails != null) {
                        JViewerApp.getInstance().getResponseDialogTable().remove(KVMShareDialog.this.reqUserDetails);
                    }
                } else if (!isMasterSession) {
                    if (KVMShareDialog.this.getKVMShareRequestDialog() != null) {
                        KVMShareDialog.this.getKVMShareRequestDialog().dispose();
                    }
                    Debug.out.println("Time out grant full access");
                }
            } else if (isMasterSession) {
                KVMShareDialog.this.getTimerLabel().setText("(" + KVMShareDialog.this.kvmsDecisionDuration + " " + LocaleStrings.getString("H_7_KVMS") + ")");
                KVMShareDialog.this.getTimerLabel().repaint();
            } else if (!isMasterSession && KVMShareDialog.this.getKVMShareRequestDialog() != null) {
                KVMShareDialog.this.getUserTwoTimerLabel().setText("       " + LocaleStrings.getString("H_8_KVMS") + " " + KVMSharing.KVM_CLIENT_USERNAME + " " + LocaleStrings.getString("H_5_KVMS") + KVMSharing.KVM_CLIENT_IP + "  (" + KVMShareDialog.this.kvmsDecisionDuration + " " + LocaleStrings.getString("H_7_KVMS") + ")");
                KVMShareDialog.this.getKVMShareRequestDialog().repaint();
            }
        }
    }
}

