/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.VideoRecord;
import com.ami.kvm.jviewer.gui.customizefilechooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VideoRecordSettings
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public int Frame_Interval;
    public int Frame_No;
    public String StoreLocation = null;
    public String videoType = ".avi";
    private JPanel jContentPane = null;
    private JLabel jVideoLengthLabel = null;
    private JTextField videoLengthText = null;
    private JLabel path = null;
    private JTextField videoStorageLocationTextField = null;
    private JButton Browse = null;
    private JFileChooser fc;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JCheckBox recordMode = null;
    private JLabel recordModeLabel = null;
    private final int MAX_VIDEO_LENGTH = 1800;
    public static final int WIDTH = 450;
    public static final int HEIGHT = 250;

    public VideoRecordSettings(JFrame jFrame) {
        super(jFrame);
        this.StoreLocation = JViewerApp.getInstance().getM_videorecord().StoreLocation;
        this.initialize();
    }

    private void initialize() {
        this.setSize(450, 250);
        this.setMinimumSize(new Dimension(450, 250));
        Point point = JViewerApp.getInstance().getPopUpWindowPosition(450, 250);
        this.setLocation(point);
        this.setTitle(LocaleStrings.getString("U_5_VR"));
        this.setModal(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.getVideoLengthPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.getVideoLocationPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.getDecisionControlsPanel(), gridBagConstraints);
    }

    public void close() {
        this.setVisible(false);
        this.videoLengthText.setText(String.valueOf(VideoRecord.RecordStopTimer));
        this.videoStorageLocationTextField.setText(JViewerApp.getInstance().getM_videorecord().StoreLocation);
        this.dispose();
    }

    public JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 5, 5);
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            this.jContentPane.add((Component)this.getVideoLengthLabel(), null);
            this.jContentPane.add((Component)this.getSecondsLabel(), null);
            this.jContentPane.add((Component)this.getStorageLocationLabel(), null);
            this.jContentPane.add((Component)this.getVideoLenghtText(), null);
            this.jContentPane.add((Component)this.getVideoStorageLocationTextField(), null);
            this.jContentPane.add((Component)this.getBrowse(), null);
            this.jContentPane.add((Component)this.getRecordMode(), null);
            this.jContentPane.add((Component)this.getRecordModeLabel(), null);
            this.jContentPane.add((Component)this.getOkButton(), null);
            this.jContentPane.add((Component)this.getCancelButton(), null);
        }
        return this.jContentPane;
    }

    private JPanel getVideoLengthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.getVideoLengthLabel(), gridBagConstraints);
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.getVideoLenghtText(), gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.getSecondsLabel(), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getVideoLocationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.getStorageLocationLabel(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.getVideoLocationBrowsePanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getVideoLocationBrowsePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 2, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)this.getVideoStorageLocationTextField(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.getBrowse(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getDecisionControlsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.getOkButton(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 5, 1, 5);
        jPanel.add((Component)this.getRecordMode(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.getRecordModeLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.getCancelButton(), gridBagConstraints);
        return jPanel;
    }

    private JLabel getVideoLengthLabel() {
        this.jVideoLengthLabel = new JLabel();
        this.jVideoLengthLabel.setHorizontalTextPosition(2);
        this.jVideoLengthLabel.setHorizontalAlignment(2);
        this.jVideoLengthLabel.setText(LocaleStrings.getString("V_1_VRS"));
        return this.jVideoLengthLabel;
    }

    private JTextField getVideoLenghtText() {
        if (this.videoLengthText == null) {
            this.videoLengthText = new JTextField();
            this.videoLengthText.setText(String.valueOf(JViewerApp.getInstance().VIDEO_RECORD_DEFAULT_TIME));
            this.videoLengthText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    String string = VideoRecordSettings.this.videoLengthText.getText();
                    if (string.length() >= String.valueOf(1800).length() && Integer.parseInt(string) > 1800) {
                        VideoRecordSettings.this.showMessage(LocaleStrings.getString("V_2_VRS") + 1800 + ")");
                        string = String.valueOf(1800);
                        keyEvent.consume();
                        VideoRecordSettings.this.videoLengthText.setText(string);
                        VideoRecordSettings.this.videoLengthText.selectAll();
                    }
                }
            });
        }
        return this.videoLengthText;
    }

    private JLabel getSecondsLabel() {
        this.jVideoLengthLabel = new JLabel();
        this.jVideoLengthLabel.setHorizontalAlignment(2);
        this.jVideoLengthLabel.setText(LocaleStrings.getString("V_3_VRS"));
        return this.jVideoLengthLabel;
    }

    private JLabel getStorageLocationLabel() {
        this.path = new JLabel();
        this.path.setHorizontalAlignment(2);
        this.path.setText(LocaleStrings.getString("V_4_VRS"));
        return this.path;
    }

    JTextField getVideoStorageLocationTextField() {
        if (this.videoStorageLocationTextField == null) {
            this.videoStorageLocationTextField = new JTextField(this.StoreLocation);
            this.videoStorageLocationTextField.addActionListener(this);
            this.videoStorageLocationTextField.setEditable(false);
            this.videoStorageLocationTextField.setBackground(Color.WHITE);
        }
        return this.videoStorageLocationTextField;
    }

    private JButton getBrowse() {
        if (this.Browse == null) {
            this.Browse = new JButton();
            this.Browse.setText(LocaleStrings.getString("A_1_DP"));
            this.Browse.addActionListener(this);
        }
        return this.Browse;
    }

    private JCheckBox getRecordMode() {
        this.recordMode = new JCheckBox(LocaleStrings.getString("V_5_VRS"));
        this.recordMode.setBorder(null);
        this.recordMode.setSelected(true);
        this.recordMode.addActionListener(this);
        return this.recordMode;
    }

    private JLabel getRecordModeLabel() {
        this.recordModeLabel = new JLabel();
        this.recordModeLabel.setHorizontalTextPosition(2);
        this.recordModeLabel.setHorizontalAlignment(2);
        this.recordModeLabel.setText(LocaleStrings.getString("V_6_VRS"));
        return this.recordModeLabel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText(LocaleStrings.getString("A_3_GLOBAL"));
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(LocaleStrings.getString("A_4_GLOBAL"));
            this.cancelButton.addActionListener(this);
        }
        return this.cancelButton;
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.jContentPane, string, LocaleStrings.getString("V_7_VRS"), 0);
    }

    private boolean isValidNumber(String string) {
        int n = Integer.parseInt(string);
        return n >= 1 && n <= 1800;
    }

    private boolean directoryCheck(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    private boolean isParsableToInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Debug.out.println(numberFormatException);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.Browse) {
            this.fc = new JFileChooser(JViewerApp.getInstance().getM_videorecord().StoreLocation);
            this.fc.setFileSelectionMode(1);
            customizefilechooser customizefilechooser2 = new customizefilechooser();
            customizefilechooser2.customizeFileChooser(this.fc);
            int n = this.fc.showDialog(this, LocaleStrings.getString("V_8_VRS"));
            if (n == 0) {
                this.StoreLocation = this.fc.getSelectedFile().exists() ? this.fc.getSelectedFile().toString() : this.fc.getSelectedFile().getParent();
            }
            this.videoStorageLocationTextField.setText(this.StoreLocation);
        }
        if (actionEvent.getSource() == this.okButton) {
            if (this.videoStorageLocationTextField.getText().length() == 0) {
                this.showMessage(LocaleStrings.getString("V_9_VRS"));
            } else if (!this.directoryCheck(this.StoreLocation)) {
                this.showMessage(LocaleStrings.getString("V_9_VRS"));
            } else if (this.videoLengthText.getText().length() == 0) {
                this.showMessage(LocaleStrings.getString("V_10_VRS"));
            } else if (!this.isParsableToInt(this.videoLengthText.getText()) || !this.isValidNumber(this.videoLengthText.getText())) {
                this.showMessage(LocaleStrings.getString("V_2_VRS") + 1800 + ")");
                this.videoLengthText.requestFocus();
                this.videoLengthText.setText(String.valueOf(1800));
                this.videoLengthText.selectAll();
            } else {
                JViewerApp.getInstance().getM_videorecord().StoreLocation = this.StoreLocation;
                VideoRecord.RecordStopTimer = Integer.parseInt(this.videoLengthText.getText());
                this.close();
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStart", true);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordStop", false);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
            }
        }
        if (actionEvent.getSource() == this.cancelButton) {
            this.close();
        }
        if (actionEvent.getSource() == this.recordMode) {
            if (!this.recordMode.isSelected()) {
                if (JOptionPane.showConfirmDialog(this.jContentPane, LocaleStrings.getString("V_11_VRS"), LocaleStrings.getString("V_7_VRS"), 2, 1) == 0) {
                    JViewerApp.getInstance().getM_videorecord().singleVideo = false;
                } else {
                    JViewerApp.getInstance().getM_videorecord().singleVideo = true;
                    this.recordMode.setSelected(true);
                }
            } else {
                JViewerApp.getInstance().getM_videorecord().singleVideo = true;
                this.recordMode.setSelected(true);
            }
        }
    }
}

