/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.FragReader;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FragNumReader
implements KVMReader {
    private KVMClient m_client;
    private ByteBuffer m_fragNumBuf;
    private int m_fragNumIx;

    public FragNumReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_fragNumBuf = ByteBuffer.allocate(2);
        this.m_fragNumBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_fragNumIx = 0;
    }

    @Override
    public void initialize() {
        this.m_fragNumIx = 0;
        this.m_fragNumBuf.clear();
    }

    @Override
    public int read(Socket socket) {
        try {
            byte[] byArray = new byte[this.m_fragNumBuf.remaining()];
            this.m_fragNumIx = this.m_client.read_data(socket, byArray);
            this.m_fragNumBuf.put(byArray);
            if (this.m_fragNumIx < 0) {
                return -1;
            }
            if (2 <= this.m_fragNumIx) {
                this.m_client.m_fragNum = this.m_fragNumBuf.getShort(0);
                FragReader fragReader = this.m_client.getFragReader();
                fragReader.initialize();
                this.m_client.setState(fragReader);
            }
        }
        catch (Exception exception) {
            Debug.out.println("ON_READ_FRAG_SZ ");
            Debug.out.println(exception);
            return -1;
        }
        return 0;
    }
}

