/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.soc.video;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class VideoEngineConfigs {
    public static final int VIDEO_ENGINE_CONFIG_PKT_SIZE = 8;
    public byte differential_setting = 0;
    public byte dct_quant_quality = 0;
    public byte dct_quant_tbl_select = 0;
    public byte sharp_mode_selection = 0;
    public byte sharp_quant_quality = 0;
    public byte sharp_quant_tbl_select = 0;
    public byte compression_mode = 0;
    public byte vga_dac = 0;
    private ByteBuffer config_buf;

    public VideoEngineConfigs() {
        byte[] byArray = new byte[8];
        this.config_buf = ByteBuffer.wrap(byArray);
        this.config_buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setVideoEngineConfigs(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.differential_setting = byteBuffer.get();
        this.dct_quant_quality = byteBuffer.get();
        this.dct_quant_tbl_select = byteBuffer.get();
        this.sharp_mode_selection = byteBuffer.get();
        this.sharp_quant_quality = byteBuffer.get();
        this.sharp_quant_tbl_select = byteBuffer.get();
        this.compression_mode = byteBuffer.get();
        this.vga_dac = byteBuffer.get();
    }

    public final int size() {
        return 8;
    }

    public final byte[] array() {
        this.config_buf.position(0);
        this.config_buf.put(this.differential_setting);
        this.config_buf.put(this.dct_quant_quality);
        this.config_buf.put(this.dct_quant_tbl_select);
        this.config_buf.put(this.sharp_mode_selection);
        this.config_buf.put(this.sharp_quant_quality);
        this.config_buf.put(this.sharp_quant_tbl_select);
        this.config_buf.put(this.compression_mode);
        this.config_buf.put(this.vga_dac);
        return this.config_buf.array();
    }
}

