/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.vmedia.VMApp;

public class DeviceDetector
extends Thread {
    private static final long SLEEP_TIME = 1000L;
    private String[] cdDriveList;
    private String[] hdDriveList;
    private boolean run = true;
    boolean cdStateFirstTime = JViewer.isCdServiceEnabled();
    boolean hdStateFirstTime = JViewer.isHdServiceEnabled();

    public DeviceDetector() {
        this.cdDriveList = VMApp.getInstance().getCDDriveList();
        this.hdDriveList = VMApp.getInstance().getHDDriveList();
        this.start();
    }

    @Override
    public void run() {
        while (this.run) {
            if (VMApp.getVMPane() == null || VMApp.getVMPane().getVmDevicePane() == null) continue;
            if (VMApp.getVMPane().getVmDevicePane().isShowing()) {
                if (VMApp.getVMPane().getVmDevicePane().getSelectedIndex() == 0) {
                    VMApp.getVMPane().showMessageForSelectedTab(0);
                    if (JViewer.isCdServiceEnabled()) {
                        if (this.isDeviceDriveListUpdated(0)) {
                            VMApp.getVMPane().updateDeviceControlPanel(0, this.cdDriveList);
                        }
                        if (this.cdStateFirstTime) {
                            VMApp.getVMPane().updateDeviceControls(0, true);
                            this.cdStateFirstTime = false;
                        }
                    } else if (!JViewer.isCdServiceEnabled() && !this.cdStateFirstTime) {
                        VMApp.getVMPane().updateDeviceControls(0, false);
                        this.cdStateFirstTime = true;
                    }
                } else if (VMApp.getVMPane().getVmDevicePane().getSelectedIndex() == 1) {
                    VMApp.getVMPane().showMessageForSelectedTab(1);
                    if (JViewer.isHdServiceEnabled()) {
                        if (this.isDeviceDriveListUpdated(2)) {
                            VMApp.getVMPane().updateDeviceControlPanel(2, this.hdDriveList);
                        }
                        if (this.hdStateFirstTime) {
                            VMApp.getVMPane().updateDeviceControls(2, true);
                            this.hdStateFirstTime = false;
                        }
                    } else if (!JViewer.isHdServiceEnabled() && !this.hdStateFirstTime) {
                        VMApp.getVMPane().updateDeviceControls(2, false);
                        this.hdStateFirstTime = true;
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Debug.out.println(interruptedException);
            }
        }
    }

    public boolean isDeviceDriveListUpdated(int n) {
        boolean bl;
        block10: {
            bl = false;
            String[] stringArray = null;
            String[] stringArray2 = null;
            switch (n) {
                case 0: {
                    stringArray2 = this.cdDriveList;
                    break;
                }
                case 2: {
                    stringArray2 = this.hdDriveList;
                }
            }
            stringArray = VMApp.getInstance().getDeviceDriveList(n);
            if (stringArray2 != null || stringArray != null) {
                try {
                    if (stringArray.length == stringArray2.length) {
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (stringArray2[i].equals(stringArray[i])) continue;
                            bl = true;
                            this.updateDeviceDriveList(n, stringArray);
                            break block10;
                        }
                        break block10;
                    }
                    bl = true;
                    this.updateDeviceDriveList(n, stringArray);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    bl = true;
                    this.updateDeviceDriveList(n, stringArray);
                }
                catch (NullPointerException nullPointerException) {
                    bl = true;
                    this.updateDeviceDriveList(n, stringArray);
                }
            }
        }
        return bl;
    }

    private void updateDeviceDriveList(int n, String[] stringArray) {
        switch (n) {
            case 0: {
                this.cdDriveList = stringArray;
                break;
            }
            case 2: {
                this.hdDriveList = stringArray;
            }
        }
    }

    public void stopDeviceDetector() {
        this.run = false;
    }
}

