/*
 * Decompiled with CFR 0.152.
 */
package com.ami.vmedia.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.vmedia.VMApp;
import com.ami.vmedia.gui.DeviceControlPanel;
import com.ami.vmedia.gui.VMActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DevicePanel
extends JPanel {
    public static String PHYSICAL_DRIVE_WIN = LocaleStrings.getString("A_5_DP");
    public static String LOGICAL_DRIVE_WIN = LocaleStrings.getString("A_6_DP");
    public static final String HD_DRIVE_LIN = "/dev/sd";
    private static final long serialVersionUID = 1L;
    private final Color DEV_PANEL_BG_COLOR = Color.WHITE;
    private String[] imagePathList;
    private ButtonGroup deviceSelectionGroup;
    private JRadioButton[] selectDevice;
    private int totalDrives;
    private JPanel panelImage;
    private int deviceType;
    public JButton browseButton;
    public JComboBox imageAddressBar;
    public String selectedImagePath;

    public DevicePanel(String[] stringArray, int n, int n2) {
        super(new GridLayout(stringArray != null && stringArray.length > 1 ? stringArray.length + 1 : 2, 1, 0, 0));
        int n3;
        this.deviceType = n;
        this.deviceSelectionGroup = new ButtonGroup();
        this.addDeviceSelectors(n, stringArray);
        this.panelImage = new JPanel(new BorderLayout(5, 5));
        this.panelImage.setBackground(this.DEV_PANEL_BG_COLOR);
        this.createImageAddressBar(n, n2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(this.DEV_PANEL_BG_COLOR);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 5);
        this.browseButton = this.createBrowseButton(n, n2);
        jPanel.add((Component)this.browseButton, gridBagConstraints);
        this.panelImage.add((Component)this.selectDevice[0], "West");
        this.panelImage.add((Component)this.imageAddressBar, "Center");
        this.panelImage.add((Component)jPanel, "East");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = n == 2 ? new Insets(10, 0, 0, 0) : new Insets(5, 0, 0, 0);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        this.add((Component)this.panelImage, gridBagConstraints2);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        for (n3 = 1; n3 < this.totalDrives; ++n3) {
            gridBagConstraints2.gridy = n3;
            this.add((Component)this.selectDevice[n3], gridBagConstraints2);
        }
        if (n == 2) {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                DeviceControlPanel deviceControlPanel;
                n3 = 1;
                PHYSICAL_DRIVE_WIN = LocaleStrings.getString("A_5_DP");
                LOGICAL_DRIVE_WIN = LocaleStrings.getString("A_6_DP");
                if (VMApp.getVMPane() != null && (deviceControlPanel = VMApp.getVMPane().getDeviceControlPanel(n, n2)) != null && deviceControlPanel.getLogicalDrive().isSelected()) {
                    n3 = 0;
                }
                if (n3 == 1) {
                    this.enableHardDiskDrives(PHYSICAL_DRIVE_WIN);
                } else {
                    this.enableHardDiskDrives(LOGICAL_DRIVE_WIN);
                }
            } else {
                this.enableHardDiskDrives(HD_DRIVE_LIN);
            }
        }
        this.setBackground(this.DEV_PANEL_BG_COLOR);
    }

    public boolean isImageSelected() {
        return this.selectDevice[0].getModel() == this.deviceSelectionGroup.getSelection();
    }

    public void setImagePath(String string, int n, int n2) {
        int n3 = 0;
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = VMApp.cdImagePath[n2];
                break;
            }
            case 2: {
                stringArray = VMApp.hdImagePath[n2];
            }
        }
        this.imagePathList = new String[5];
        if (this.imageAddressBar.getItemAt(0) == null) {
            this.imageAddressBar.insertItemAt(string, 0);
            this.imagePathList[0] = string;
        } else {
            for (n3 = 4; n3 >= 0; --n3) {
                if (this.imageAddressBar.getItemAt(n3) == null || !this.imageAddressBar.getItemAt(n3).equals(string)) continue;
                this.imageAddressBar.removeItemAt(n3);
                break;
            }
            if (this.imageAddressBar.getItemAt(5) != null && !string.equals(this.imageAddressBar.getItemAt(5))) {
                this.imageAddressBar.removeItemAt(5);
            }
            if (!string.equals(this.imageAddressBar.getItemAt(0))) {
                this.imageAddressBar.insertItemAt(string, 0);
                for (n3 = 0; !(n3 >= 5 || this.imageAddressBar.getItemAt(1) != null && this.imageAddressBar.getItemAt(1).equals(stringArray[n3])); ++n3) {
                }
                if (n3 == 5) {
                    this.imageAddressBar.removeItemAt(1);
                }
            }
            for (n3 = 0; n3 < 5 && (String)this.imageAddressBar.getItemAt(n3) != null; ++n3) {
                this.imagePathList[n3] = (String)this.imageAddressBar.getItemAt(n3);
            }
        }
        this.imageAddressBar.setSelectedIndex(0);
    }

    public void saveImagePath(String[] stringArray, int n, int n2) {
        if (this.imageAddressBar.getItemAt(5) != null) {
            this.imageAddressBar.removeItemAt(5);
        }
        switch (n) {
            case 0: {
                VMApp.cdImagePath[n2] = stringArray;
                break;
            }
            case 2: {
                VMApp.hdImagePath[n2] = stringArray;
            }
        }
    }

    public String getImagePath() {
        String string = (String)this.imageAddressBar.getSelectedItem();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getSelectedDeviceString() {
        Enumeration<AbstractButton> enumeration = this.deviceSelectionGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.getModel() != this.deviceSelectionGroup.getSelection()) continue;
            return jRadioButton.getText();
        }
        return "";
    }

    public void disableAll() {
        for (int i = 0; i < this.selectDevice.length; ++i) {
            this.selectDevice[i].setEnabled(false);
        }
        this.browseButton.setEnabled(false);
        this.imageAddressBar.setEnabled(false);
    }

    public void enableAll() {
        for (int i = 0; i < this.selectDevice.length; ++i) {
            if (!this.isDeviceredirected(this.selectDevice[i].getText())) {
                this.selectDevice[i].setEnabled(true);
                continue;
            }
            this.selectDevice[i].setEnabled(false);
        }
        if (this.selectDevice[0].isSelected()) {
            this.browseButton.setEnabled(true);
            this.imageAddressBar.setEnabled(true);
        }
    }

    public boolean isDeviceredirected(String stringArray) {
        String string = "";
        String string2 = "";
        String[] stringArray2 = new String[]{};
        for (int i = 0; i < this.selectDevice.length; ++i) {
            String string3;
            if (VMApp.getInstance().getIUSBRedirSession() == null) continue;
            int n = VMApp.getInstance().getIUSBRedirSession().getDeviceRedirStatus(this.deviceType, i);
            VMApp.getInstance().getIUSBRedirSession();
            if (n != 1) continue;
            string = VMApp.getInstance().getIUSBRedirSession().getDeviceRedirSource(this.deviceType, i);
            if ((string.startsWith(PHYSICAL_DRIVE_WIN) || string.startsWith(LocaleStrings.getPreviousLocaleString("A_5_DP"))) && (stringArray.startsWith(LOGICAL_DRIVE_WIN) || string.startsWith(LocaleStrings.getPreviousLocaleString("A_6_DP")) && stringArray.indexOf(91) > 0)) {
                stringArray2 = string.substring(string.indexOf(91) + 1, string.indexOf(93)).split("-");
                string2 = stringArray.substring(stringArray.indexOf(91) + 1, stringArray.indexOf(93));
                for (String string4 : stringArray2) {
                    if (!string4.equals(string2)) continue;
                    return true;
                }
            }
            String[] stringArray3 = stringArray.indexOf(45) >= 0 ? stringArray.substring(stringArray.indexOf(45), stringArray.length()) : stringArray;
            String string5 = string3 = string.indexOf(45) >= 0 ? string.substring(string.indexOf(45), string.length()) : string;
            if (!stringArray3.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public void selectRadioButton(String string) {
        JRadioButton jRadioButton;
        Enumeration<AbstractButton> enumeration = this.deviceSelectionGroup.getElements();
        while (enumeration.hasMoreElements()) {
            jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().equals(string)) continue;
            jRadioButton.setSelected(true);
            return;
        }
        enumeration = this.deviceSelectionGroup.getElements();
        if (enumeration.hasMoreElements()) {
            jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setSelected(true);
        }
    }

    public String[] getImagePathList() {
        int n = this.imageAddressBar.getSelectedIndex();
        String string = (String)this.imageAddressBar.getSelectedItem();
        if (n != 0) {
            for (int i = n; i > 0; --i) {
                this.imagePathList[i] = this.imagePathList[i - 1];
            }
        }
        this.imagePathList[0] = string;
        return this.imagePathList;
    }

    public void setImagePathList(String[] stringArray) {
        this.imagePathList = stringArray;
    }

    public String getSelectedImagePath() {
        return this.selectedImagePath;
    }

    public void setSelectedImagePath(String string) {
        this.selectedImagePath = string;
    }

    private JButton createBrowseButton(int n, int n2) {
        JButton jButton = new JButton(LocaleStrings.getString("A_1_DP"));
        switch (n) {
            case 0: {
                jButton.setActionCommand("BROWSE_CD_" + n2);
                break;
            }
            case 2: {
                jButton.setActionCommand("BROWSE_HD_" + n2);
                break;
            }
        }
        jButton.addActionListener(new VMActionListener());
        return jButton;
    }

    private JComboBox createImageAddressBar(int n, int n2) {
        switch (n) {
            case 0: {
                this.imageAddressBar = new JComboBox<String>(VMApp.cdImagePath[n2]);
                this.imageAddressBar.setActionCommand("CD_IMAGE_PATH_ADDRESS_" + n2);
                this.imagePathList = VMApp.cdImagePath[n2];
                break;
            }
            case 2: {
                this.imageAddressBar = new JComboBox<String>(VMApp.hdImagePath[n2]);
                this.imageAddressBar.setActionCommand("HD_IMAGE_PATH_ADDRESS_" + n2);
                this.imagePathList = VMApp.hdImagePath[n2];
            }
        }
        this.imageAddressBar.setEditable(false);
        this.imageAddressBar.setBackground(this.DEV_PANEL_BG_COLOR);
        this.imageAddressBar.setBorder(null);
        this.imageAddressBar.setMaximumRowCount(5);
        this.imageAddressBar.addActionListener(new VMActionListener());
        return this.imageAddressBar;
    }

    public void addDeviceSelectors(int n, String[] stringArray) {
        this.totalDrives = stringArray != null ? stringArray.length + 1 : 1;
        this.selectDevice = new JRadioButton[this.totalDrives];
        switch (n) {
            case 0: {
                this.selectDevice[0] = new JRadioButton(LocaleStrings.getString("A_2_DP"));
                break;
            }
            case 2: {
                this.selectDevice[0] = new JRadioButton(LocaleStrings.getString("A_4_DP"));
            }
        }
        this.selectDevice[0].setBackground(this.DEV_PANEL_BG_COLOR);
        this.selectDevice[0].addChangeListener(new RadioButtonChangeListener());
        this.deviceSelectionGroup.add(this.selectDevice[0]);
        this.selectDevice[0].setSelected(true);
        int n2 = 1;
        int n3 = 0;
        while (n2 < this.totalDrives) {
            this.selectDevice[n2] = new JRadioButton(stringArray[n3]);
            this.selectDevice[n2].setBackground(this.DEV_PANEL_BG_COLOR);
            this.deviceSelectionGroup.add(this.selectDevice[n2]);
            ++n2;
            ++n3;
        }
    }

    public void removeDeviceSelectors() {
        for (int i = 0; i < this.selectDevice.length; ++i) {
            this.deviceSelectionGroup.remove(this.selectDevice[i]);
            this.remove(this.selectDevice[i]);
        }
    }

    public void enableHardDiskDrives(String string) {
        for (int i = 1; i < this.selectDevice.length; ++i) {
            if (this.selectDevice[i].getText().startsWith(string)) {
                this.selectDevice[i].setVisible(true);
                continue;
            }
            this.selectDevice[i].setVisible(false);
        }
    }

    private void changeStateLogicalDrives(String string, boolean bl) {
        String[] stringArray = null;
        try {
            stringArray = string.substring(string.indexOf(91) + 1, string.indexOf(93)).split("-");
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            stringArray = null;
            return;
        }
        Enumeration<AbstractButton> enumeration = this.deviceSelectionGroup.getElements();
        block4: while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            String string2 = null;
            if (jRadioButton.getText().startsWith(LOGICAL_DRIVE_WIN)) {
                try {
                    string2 = jRadioButton.getText().substring(jRadioButton.getText().indexOf(91) + 1, jRadioButton.getText().indexOf(93));
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                    string2 = null;
                    return;
                }
            }
            if (string2 == null) continue;
            for (String string3 : stringArray) {
                if (!string2.equals(string3) || jRadioButton.isEnabled() == bl) continue;
                jRadioButton.setEnabled(bl);
                continue block4;
            }
        }
    }

    private void changeStatePhysicalDrives(String string, boolean bl) {
        String[] stringArray = null;
        try {
            stringArray = string.substring(string.indexOf(91) + 1, string.indexOf(93)).split("-");
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            stringArray = null;
            return;
        }
        Enumeration<AbstractButton> enumeration = this.deviceSelectionGroup.getElements();
        block4: while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            String string2 = null;
            if (jRadioButton.getText().startsWith(PHYSICAL_DRIVE_WIN)) {
                try {
                    string2 = jRadioButton.getText().substring(jRadioButton.getText().indexOf(91) + 1, jRadioButton.getText().indexOf(93));
                }
                catch (Exception exception) {
                    Debug.out.println(exception);
                    string2 = null;
                    return;
                }
            }
            if (string2 == null) continue;
            for (String string3 : stringArray) {
                if (!string2.contains(string3) || jRadioButton.isEnabled() == bl) continue;
                jRadioButton.setEnabled(bl);
                continue block4;
            }
        }
    }

    public void updatePhysicalDeviceState(int n, String string, boolean bl) {
        block3: {
            block1: {
                block2: {
                    if (n != 2) break block1;
                    if (!System.getProperty("os.name").toLowerCase().contains("windows")) break block2;
                    this.changeStatePhysicalDrives(string, bl);
                    this.changeStateLogicalDrives(string, bl);
                    break block3;
                }
                if (!System.getProperty("os.name").toLowerCase().contains("linux")) break block3;
                this.changeStateHDDrives(string, bl);
                break block3;
            }
            Enumeration<AbstractButton> enumeration = this.deviceSelectionGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                if (!jRadioButton.getText().equals(string)) continue;
                jRadioButton.setEnabled(bl);
            }
        }
    }

    private void changeStateHDDrives(String string, boolean bl) {
        char c;
        try {
            c = string.charAt(HD_DRIVE_LIN.length());
        }
        catch (Exception exception) {
            Debug.out.println(exception);
            return;
        }
        Enumeration<AbstractButton> enumeration = this.deviceSelectionGroup.getElements();
        while (enumeration.hasMoreElements()) {
            char c2;
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            try {
                c2 = jRadioButton.getText().charAt(HD_DRIVE_LIN.length());
            }
            catch (Exception exception) {
                Debug.out.println(exception);
                return;
            }
            if (c != c2 || jRadioButton.isEnabled() == bl) continue;
            jRadioButton.setEnabled(bl);
            break;
        }
    }

    class RadioButtonChangeListener
    implements ChangeListener {
        RadioButtonChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (DevicePanel.this.selectDevice[0].isSelected()) {
                if (DevicePanel.this.browseButton != null) {
                    DevicePanel.this.browseButton.setEnabled(true);
                }
                if (DevicePanel.this.imageAddressBar != null) {
                    DevicePanel.this.imageAddressBar.setEnabled(true);
                }
            } else {
                DevicePanel.this.browseButton.setEnabled(false);
                if (DevicePanel.this.imageAddressBar != null) {
                    DevicePanel.this.imageAddressBar.setEnabled(false);
                }
            }
        }
    }
}

