/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.ProcessingResult;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.core.tree.JsonTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.SimpleJsonTree;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonSchema {
    private final ValidationProcessor processor;
    private final SchemaTree schema;
    private final ReportProvider reportProvider;

    JsonSchema(ValidationProcessor processor, SchemaTree schema, ReportProvider reportProvider) {
        this.processor = processor;
        this.schema = schema;
        this.reportProvider = reportProvider;
    }

    private ProcessingReport doValidate(JsonNode node, boolean deepCheck) throws ProcessingException {
        FullData data = new FullData(this.schema, (JsonTree)new SimpleJsonTree(node), deepCheck);
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult result = ProcessingResult.of((Processor)this.processor, (ProcessingReport)report, (MessageProvider)data);
        return result.getReport();
    }

    private ProcessingReport doValidateUnchecked(JsonNode node, boolean deepCheck) {
        FullData data = new FullData(this.schema, (JsonTree)new SimpleJsonTree(node), deepCheck);
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult result = ProcessingResult.uncheckedResult((Processor)this.processor, (ProcessingReport)report, (MessageProvider)data);
        return result.getReport();
    }

    public ProcessingReport validate(JsonNode instance, boolean deepCheck) throws ProcessingException {
        return this.doValidate(instance, deepCheck);
    }

    public ProcessingReport validate(JsonNode instance) throws ProcessingException {
        return this.validate(instance, false);
    }

    public ProcessingReport validateUnchecked(JsonNode instance, boolean deepCheck) {
        return this.doValidateUnchecked(instance, deepCheck);
    }

    public ProcessingReport validateUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance, false);
    }

    public boolean validInstance(JsonNode instance) throws ProcessingException {
        return this.doValidate(instance, false).isSuccess();
    }

    public boolean validInstanceUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance, false).isSuccess();
    }
}

