/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType0;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType3;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType4;

public abstract class PDFunction
implements COSObjectable {
    private PDStream functionStream = null;
    private COSDictionary functionDictionary = null;
    private COSArray domain = null;
    private COSArray range = null;
    private int numberOfInputValues = -1;
    private int numberOfOutputValues = -1;

    public PDFunction(COSBase function) {
        if (function instanceof COSStream) {
            this.functionStream = new PDStream((COSStream)function);
            this.functionStream.getStream().setItem(COSName.TYPE, (COSBase)COSName.FUNCTION);
        } else if (function instanceof COSDictionary) {
            this.functionDictionary = (COSDictionary)function;
        }
    }

    public abstract int getFunctionType();

    public COSBase getCOSObject() {
        if (this.functionStream != null) {
            return this.functionStream.getCOSObject();
        }
        return this.functionDictionary;
    }

    public COSDictionary getDictionary() {
        if (this.functionStream != null) {
            return this.functionStream.getStream();
        }
        return this.functionDictionary;
    }

    protected PDStream getPDStream() {
        return this.functionStream;
    }

    public static PDFunction create(COSBase function) throws IOException {
        COSDictionary functionDictionary;
        int functionType;
        PDFunction retval = null;
        if (function instanceof COSObject) {
            function = ((COSObject)function).getObject();
        }
        if ((functionType = (functionDictionary = (COSDictionary)function).getInt(COSName.FUNCTION_TYPE)) == 0) {
            retval = new PDFunctionType0(functionDictionary);
        } else if (functionType == 2) {
            retval = new PDFunctionType2(functionDictionary);
        } else if (functionType == 3) {
            retval = new PDFunctionType3(functionDictionary);
        } else if (functionType == 4) {
            retval = new PDFunctionType4(functionDictionary);
        } else {
            throw new IOException("Error: Unknown function type " + functionType);
        }
        return retval;
    }

    public int getNumberOfOutputParameters() {
        if (this.numberOfOutputValues == -1) {
            COSArray rangeValues = this.getRangeValues();
            this.numberOfOutputValues = rangeValues.size() / 2;
        }
        return this.numberOfOutputValues;
    }

    public PDRange getRangeForOutput(int n) {
        COSArray rangeValues = this.getRangeValues();
        return new PDRange(rangeValues, n);
    }

    public void setRangeValues(COSArray rangeValues) {
        this.range = rangeValues;
        this.getDictionary().setItem(COSName.RANGE, (COSBase)rangeValues);
    }

    public int getNumberOfInputParameters() {
        if (this.numberOfInputValues == -1) {
            COSArray array = this.getDomainValues();
            this.numberOfInputValues = array.size() / 2;
        }
        return this.numberOfInputValues;
    }

    public PDRange getDomainForInput(int n) {
        COSArray domainValues = this.getDomainValues();
        return new PDRange(domainValues, n);
    }

    public void setDomainValues(COSArray domainValues) {
        this.domain = domainValues;
        this.getDictionary().setItem(COSName.DOMAIN, (COSBase)domainValues);
    }

    public COSArray eval(COSArray input) throws IOException {
        float[] outputValues = this.eval(input.toFloatArray());
        COSArray array = new COSArray();
        array.setFloatArray(outputValues);
        return array;
    }

    public abstract float[] eval(float[] var1) throws IOException;

    protected COSArray getRangeValues() {
        if (this.range == null) {
            this.range = (COSArray)this.getDictionary().getDictionaryObject(COSName.RANGE);
        }
        return this.range;
    }

    private COSArray getDomainValues() {
        if (this.domain == null) {
            this.domain = (COSArray)this.getDictionary().getDictionaryObject(COSName.DOMAIN);
        }
        return this.domain;
    }

    protected float[] clipToRange(float[] inputValues) {
        COSArray rangesArray = this.getRangeValues();
        float[] result = null;
        if (rangesArray != null) {
            float[] rangeValues = rangesArray.toFloatArray();
            int numberOfRanges = rangeValues.length / 2;
            result = new float[numberOfRanges];
            for (int i = 0; i < numberOfRanges; ++i) {
                result[i] = this.clipToRange(inputValues[i], rangeValues[2 * i], rangeValues[2 * i + 1]);
            }
        } else {
            result = inputValues;
        }
        return result;
    }

    protected float clipToRange(float x, float rangeMin, float rangeMax) {
        return Math.min(Math.max(x, rangeMin), rangeMax);
    }

    protected float interpolate(float x, float xRangeMin, float xRangeMax, float yRangeMin, float yRangeMax) {
        return yRangeMin + (x - xRangeMin) * (yRangeMax - yRangeMin) / (xRangeMax - xRangeMin);
    }
}

