/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDCcitt
extends PDXObjectImage {
    private static final List<String> FAX_FILTERS = new ArrayList<String>();

    public PDCcitt(PDStream ccitt) {
        super(ccitt, "tiff");
    }

    public PDCcitt(PDDocument doc, RandomAccess raf, int number) throws IOException, IllegalArgumentException {
        super(new PDStream(doc), "tiff");
        COSDictionary decodeParms = new COSDictionary();
        COSStream dic = this.getCOSStream();
        this.extractFromTiff(raf, this.getCOSStream().createFilteredStream(), decodeParms, number);
        dic.setItem(COSName.FILTER, (COSBase)COSName.CCITTFAX_DECODE);
        dic.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dic.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
        dic.setItem(COSName.DECODE_PARMS, (COSBase)decodeParms);
        this.setBitsPerComponent(1);
        this.setColorSpace(new PDDeviceGray());
        this.setWidth(decodeParms.getInt(COSName.COLUMNS));
        this.setHeight(decodeParms.getInt(COSName.ROWS));
    }

    public PDCcitt(PDDocument doc, RandomAccess raf) throws IOException {
        this(doc, raf, 0);
    }

    public BufferedImage getRGBImage() throws IOException {
        COSStream stream = this.getCOSStream();
        COSBase decodeP = stream.getDictionaryObject(COSName.DECODE_PARMS);
        COSDictionary decodeParms = null;
        if (decodeP instanceof COSDictionary) {
            decodeParms = (COSDictionary)decodeP;
        } else if (decodeP instanceof COSArray) {
            int index;
            COSBase filters = stream.getFilters();
            if (filters instanceof COSArray) {
                COSName filtername;
                COSArray filterArray = (COSArray)filters;
                for (index = 0; index < filterArray.size() && !COSName.CCITTFAX_DECODE.equals(filtername = (COSName)filterArray.get(index)); ++index) {
                }
            }
            decodeParms = (COSDictionary)((COSArray)decodeP).getObject(index);
        }
        int cols = decodeParms.getInt(COSName.COLUMNS, 1728);
        int rows = decodeParms.getInt(COSName.ROWS, 0);
        int height = stream.getInt(COSName.HEIGHT, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        byte[] bufferData = null;
        ColorModel colorModel = null;
        PDColorSpace colorspace = this.getColorSpace();
        if (colorspace instanceof PDIndexed) {
            PDIndexed csIndexed = (PDIndexed)colorspace;
            COSBase maskArray = this.getMask();
            colorModel = maskArray != null && maskArray instanceof COSArray ? csIndexed.createColorModel(1, ((COSArray)maskArray).getInt(0)) : csIndexed.createColorModel(1);
        } else {
            byte[] map = new byte[]{0, -1};
            colorModel = new IndexColorModel(1, map.length, map, map, map, 1);
        }
        WritableRaster raster = colorModel.createCompatibleWritableRaster(cols, rows);
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        bufferData = buffer.getData();
        InputStream is = stream.getUnfilteredStream();
        IOUtils.populateBuffer(is, bufferData);
        IOUtils.closeQuietly(is);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        COSArray decode = this.getDecode();
        if (decode != null && decode.getInt(0) == 1) {
            this.invertBitmap(bufferData);
        }
        if (this.hasMask()) {
            BufferedImage indexed;
            byte[] array;
            byte[] map = new byte[]{0, -1};
            IndexColorModel cm = new IndexColorModel(1, map.length, map, map, map, 1);
            raster = cm.createCompatibleWritableRaster(cols, rows);
            bufferData = ((DataBufferByte)raster.getDataBuffer()).getData();
            System.arraycopy(array, 0, bufferData, 0, (array = ((DataBufferByte)image.getData().getDataBuffer()).getData()).length < bufferData.length ? array.length : bufferData.length);
            image = indexed = new BufferedImage(cm, raster, false, null);
        }
        return this.applyMasks(image);
    }

    private void invertBitmap(byte[] bufferData) {
        int c = bufferData.length;
        for (int i = 0; i < c; ++i) {
            bufferData[i] = (byte)(~bufferData[i] & 0xFF);
        }
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        TiffWrapper data = new TiffWrapper(this.getPDStream().getPartiallyFilteredStream(FAX_FILTERS), this.getCOSStream());
        IOUtils.copy(data, out);
        IOUtils.closeQuietly(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFromTiff(RandomAccess raf, OutputStream os, COSDictionary parms, int number) throws IOException, IllegalArgumentException {
        try {
            raf.seek(0L);
            char endianess = (char)raf.read();
            if ((char)raf.read() != endianess) {
                throw new IOException("Not a valid tiff file");
            }
            if (endianess != 'M' && endianess != 'I') {
                throw new IOException("Not a valid tiff file");
            }
            int magicNumber = this.readshort(endianess, raf);
            if (magicNumber != 42) {
                throw new IOException("Not a valid tiff file");
            }
            int address = this.readlong(endianess, raf);
            raf.seek(address);
            for (int i = 0; i < number; ++i) {
                int numtags = this.readshort(endianess, raf);
                if (numtags > 50) {
                    throw new IOException("Not a valid tiff file");
                }
                raf.seek(address + 2 + numtags * 12);
                address = this.readlong(endianess, raf);
                if (address == 0) {
                    throw new IllegalArgumentException("Image number " + number + " does not exist");
                }
                raf.seek(address);
            }
            int numtags = this.readshort(endianess, raf);
            if (numtags > 50) {
                throw new IOException("Not a valid tiff file");
            }
            int k = -1000;
            int dataoffset = 0;
            int datalength = 0;
            block19: for (int i = 0; i < numtags; ++i) {
                int tag = this.readshort(endianess, raf);
                int type = this.readshort(endianess, raf);
                int count = this.readlong(endianess, raf);
                int val = this.readlong(endianess, raf);
                if (endianess == 'M') {
                    switch (type) {
                        case 1: {
                            val >>= 24;
                            break;
                        }
                        case 3: {
                            val >>= 16;
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                switch (tag) {
                    case 256: {
                        parms.setInt(COSName.COLUMNS, val);
                        continue block19;
                    }
                    case 257: {
                        parms.setInt(COSName.ROWS, val);
                        continue block19;
                    }
                    case 259: {
                        if (val == 4) {
                            k = -1;
                        }
                        if (val != 3) continue block19;
                        k = 0;
                        continue block19;
                    }
                    case 262: {
                        if (val != 1) continue block19;
                        parms.setBoolean(COSName.BLACK_IS_1, true);
                        continue block19;
                    }
                    case 273: {
                        if (count != 1) continue block19;
                        dataoffset = val;
                        continue block19;
                    }
                    case 279: {
                        if (count != 1) continue block19;
                        datalength = val;
                        continue block19;
                    }
                    case 292: {
                        if ((val & 1) != 0) {
                            k = 50;
                        }
                        if ((val & 4) != 0) {
                            throw new IOException("CCITT Group 3 'uncompressed mode' is not supported");
                        }
                        if ((val & 2) == 0) continue block19;
                        throw new IOException("CCITT Group 3 'fill bits before EOL' is not supported");
                    }
                    case 324: {
                        if (count != 1) continue block19;
                        dataoffset = val;
                        continue block19;
                    }
                    case 325: {
                        if (count != 1) continue block19;
                        datalength = val;
                        continue block19;
                    }
                }
            }
            if (k == -1000) {
                throw new IOException("First image in tiff is not CCITT T4 or T6 compressed");
            }
            if (dataoffset == 0) {
                throw new IOException("First image in tiff is not a single tile/strip");
            }
            parms.setInt(COSName.K, k);
            raf.seek(dataoffset);
            byte[] buf = new byte[8192];
            int amountRead = -1;
            while ((amountRead = raf.read(buf, 0, Math.min(8192, datalength))) > 0) {
                datalength -= amountRead;
                os.write(buf, 0, amountRead);
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    private int readshort(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8;
        }
        return raf.read() << 8 | raf.read();
    }

    private int readlong(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8 | raf.read() << 16 | raf.read() << 24;
        }
        return raf.read() << 24 | raf.read() << 16 | raf.read() << 8 | raf.read();
    }

    static {
        FAX_FILTERS.add(COSName.CCITTFAX_DECODE.getName());
        FAX_FILTERS.add(COSName.CCITTFAX_DECODE_ABBREVIATION.getName());
    }

    private class TiffWrapper
    extends InputStream {
        private int currentOffset;
        private byte[] tiffheader;
        private InputStream datastream;
        private final byte[] basicHeader = new byte[]{73, 73, 42, 0, 8, 0, 0, 0, 0, 0};
        private int additionalOffset;

        private TiffWrapper(InputStream rawstream, COSDictionary options) {
            this.buildHeader(options);
            this.currentOffset = 0;
            this.datastream = rawstream;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            throw new IOException("reset not supported");
        }

        public int read() throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                return this.tiffheader[this.currentOffset++];
            }
            return this.datastream.read();
        }

        public int read(byte[] data) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                int length = Math.min(this.tiffheader.length - this.currentOffset, data.length);
                if (length > 0) {
                    System.arraycopy(this.tiffheader, this.currentOffset, data, 0, length);
                }
                this.currentOffset += length;
                return length;
            }
            return this.datastream.read(data);
        }

        public int read(byte[] data, int off, int len) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                int length = Math.min(this.tiffheader.length - this.currentOffset, len);
                if (length > 0) {
                    System.arraycopy(this.tiffheader, this.currentOffset, data, off, length);
                }
                this.currentOffset += length;
                return length;
            }
            return this.datastream.read(data, off, len);
        }

        public long skip(long n) throws IOException {
            if (this.currentOffset < this.tiffheader.length) {
                long length = Math.min((long)(this.tiffheader.length - this.currentOffset), n);
                this.currentOffset = (int)((long)this.currentOffset + length);
                return length;
            }
            return this.datastream.skip(n);
        }

        private void buildHeader(COSDictionary options) {
            int numOfTags = 10;
            int maxAdditionalData = 24;
            int ifdSize = 134;
            this.tiffheader = new byte[ifdSize + 24];
            Arrays.fill(this.tiffheader, (byte)0);
            System.arraycopy(this.basicHeader, 0, this.tiffheader, 0, this.basicHeader.length);
            this.additionalOffset = ifdSize;
            short cols = 1728;
            short rows = 0;
            short blackis1 = 0;
            int comptype = 3;
            long t4options = 0L;
            COSArray decode = PDCcitt.this.getDecode();
            if (decode != null && decode.getInt(0) == 1) {
                blackis1 = 1;
            }
            COSBase dicOrArrayParms = options.getDictionaryObject(COSName.DECODE_PARMS);
            COSDictionary decodeParms = null;
            if (dicOrArrayParms instanceof COSDictionary) {
                decodeParms = (COSDictionary)dicOrArrayParms;
            } else {
                COSArray parmsArray = (COSArray)dicOrArrayParms;
                if (parmsArray.size() == 1) {
                    decodeParms = (COSDictionary)parmsArray.getObject(0);
                } else {
                    for (int i = 0; i < parmsArray.size() && decodeParms == null; ++i) {
                        COSDictionary dic = (COSDictionary)parmsArray.getObject(i);
                        if (dic == null || dic.getDictionaryObject(COSName.COLUMNS) == null && dic.getDictionaryObject(COSName.ROWS) == null) continue;
                        decodeParms = dic;
                    }
                }
            }
            if (decodeParms != null) {
                int k;
                cols = (short)decodeParms.getInt(COSName.COLUMNS, (int)cols);
                rows = (short)decodeParms.getInt(COSName.ROWS, (int)rows);
                if (decodeParms.getBoolean(COSName.BLACK_IS_1, false)) {
                    blackis1 = 1;
                }
                if ((k = decodeParms.getInt(COSName.K, 0)) < 0) {
                    comptype = 4;
                }
                if (k > 0) {
                    comptype = 3;
                    t4options = 1L;
                }
            }
            if (rows == 0) {
                rows = (short)options.getInt(COSName.HEIGHT, (int)rows);
            }
            this.addTag(256, cols);
            this.addTag(257, rows);
            this.addTag(259, (short)comptype);
            this.addTag(262, blackis1);
            this.addTag(273, this.tiffheader.length);
            this.addTag(279, options.getInt(COSName.LENGTH));
            this.addTag(282, 300L, 1L);
            this.addTag(283, 300L, 1L);
            if (comptype == 3) {
                this.addTag(292, t4options);
            }
            this.addTag(305, "PDFBOX");
        }

        private void addTag(int tag, long value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 4;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(value & 0xFFL);
            this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFFL);
            this.tiffheader[offset + 10] = (byte)(value >> 16 & 0xFFL);
            this.tiffheader[offset + 11] = (byte)(value >> 24 & 0xFFL);
        }

        private void addTag(int tag, short value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 3;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(value & 0xFF);
            this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFF);
        }

        private void addTag(int tag, String value) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 2;
            int len = value.length() + 1;
            this.tiffheader[offset + 4] = (byte)(len & 0xFF);
            this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
            this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
            this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
            this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
            try {
                System.arraycopy(value.getBytes("US-ASCII"), 0, this.tiffheader, this.additionalOffset, value.length());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Incompatible VM without US-ASCII encoding", e);
            }
            this.additionalOffset += len;
        }

        private void addTag(int tag, long numerator, long denominator) {
            byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
            int offset = (count - 1) * 12 + 10;
            this.tiffheader[offset] = (byte)(tag & 0xFF);
            this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
            this.tiffheader[offset + 2] = 5;
            this.tiffheader[offset + 4] = 1;
            this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
            this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
            this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
            this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 8 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 16 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 24 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 8 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 16 & 0xFFL);
            this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 24 & 0xFFL);
        }
    }
}

