/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.isocaching;

import Gbt.core.vmedia.isocaching.ReadAheadCache;
import Gbt.core.vmedia.protocol.IUSBSCSIPacket;
import Gbt.core.vmedia.protocol.Image;
import Gbt.core.vmedia.protocol.SCSICommandPacket;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CDImage
extends Image {
    public static final int CD_BLOCK_SIZE = 2048;
    private static final int ISO_PRIMARY_VOLUME_DESCRIPTOR_LBA = 16;
    private static final int UDF_DOMAIN_ID_LBA = 35;
    private static final int UDF_DOMAIN_ID_OFFSET = 217;
    private static final int ISO_ID_SIZE = 5;
    private static final int UDF_DOMAIN_ID_SIZE = 19;
    private static final String ISO_ID = "CD001";
    private static final String UDF_DOMAIN_ID = "*OSTA UDF Compliant";
    private static final int MSF_BIT = 2;
    public int dataLength = 0;
    public byte[] append = new byte[20];
    private static final int DATA_LENGTH_INDEX = 57;
    private static final int CURRENT_INDEX = 61;
    private static final int OVERALL_STATUS_INDEX = 53;
    private static final int SENSE_KEY_INDEX = 54;
    private static final int SENSE_CODE_INDEX = 55;
    private static final int SENSE_CODE_Q_INDEX = 56;
    private ReadAheadCache readAheadCache = null;
    private boolean firstTime = false;

    public CDImage(File imageFile) {
        if (this.openImage(imageFile, "r")) {
            if (this.validateISOImage() == 0) {
                this.setOpened(true);
                this.setFirstTime(true);
            } else {
                this.setOpened(false);
            }
        }
        this.mediaChange = true;
    }

    public int validateISOImage() {
        int ret = 0;
        byte[] readBlockData = new byte[2048];
        byte[] isoIDBuffer = new byte[5];
        byte[] udfDomainIDData = new byte[19];
        ByteBuffer blockBuffer = ByteBuffer.wrap(readBlockData);
        String isoID = null;
        String udfDomainID = null;
        this.blockSize = 2048L;
        try {
            this.imageFile.seek(32768L);
            ret = this.imageFile.read(readBlockData);
            if (0 == ret || -1 == ret) {
                ret = -7;
            }
            blockBuffer.position(1);
            blockBuffer.get(isoIDBuffer);
            isoID = new String(isoIDBuffer);
            if (!isoID.equals(ISO_ID)) {
                blockBuffer.clear();
                blockBuffer.rewind();
                this.imageFile.seek(71680L);
                ret = this.imageFile.read(readBlockData);
                if (0 == ret || -1 == ret) {
                    ret = -7;
                }
                blockBuffer.position(217);
                blockBuffer.get(udfDomainIDData);
                udfDomainID = new String(udfDomainIDData);
                if (udfDomainID.equals(UDF_DOMAIN_ID)) {
                    ret = 0;
                    return ret;
                }
                ret = -2;
            } else {
                ret = 0;
            }
        }
        catch (IOException e) {
            ret = -4;
        }
        return ret;
    }

    public int readCapacity() {
        int ret = 0;
        this.blockSize = 2048L;
        try {
            this.imageFile.seek(0L);
            long imageFileSize = this.imageFile.length();
            this.imageFile.seek(imageFileSize);
            this.totalSectors = imageFileSize / 2048L;
        }
        catch (IOException e) {
            ret = -4;
        }
        ret = 0;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readCDImage(long sectorNo, int numSectors) {
        byte[] readData = new byte[2048 * numSectors];
        if (this.readAheadCache == null) {
            this.readAheadCache = new ReadAheadCache(this.imageFile);
            this.readAheadCache.startThread();
            this.readAheadCache.setName("ReadAheadCache");
        }
        Object object = this.readAheadCache.getReadSync();
        synchronized (object) {
            try {
                Object object2 = this.readAheadCache.getCacheSync();
                synchronized (object2) {
                    this.readAheadCache.setSectorRequest(sectorNo, numSectors);
                    this.readAheadCache.getCacheSync().notifyAll();
                }
                this.readAheadCache.getReadSync().wait();
                readData = this.readAheadCache.getSectorData();
            }
            catch (Exception e) {
                readData = null;
            }
        }
        if (readData == null) {
            this.closeImage();
        }
        return readData;
    }

    public int executeSCSICmd(ByteBuffer requests, ByteBuffer response) {
        int val = 0;
        SCSICommandPacket packet = null;
        byte[] readBuffer = null;
        long startingSectorNumber = 0L;
        long numberOfSectors = 0L;
        short maxTOCSize = 0;
        IUSBSCSIPacket requestPacket = null;
        int transfer = Math.min(response.remaining(), requests.remaining());
        ByteBuffer temp = requests.duplicate();
        temp.limit(temp.position() + transfer);
        response.put(temp);
        requestPacket = new IUSBSCSIPacket(requests);
        packet = requestPacket.getCommandPkt();
        switch (packet.getOpCode()) {
            case 0: {
                if (this.isFirstTime()) {
                    this.setFirstTime(false);
                    val = -3;
                } else {
                    val = this.testUnitReady();
                }
                this.setDataLength(0);
                break;
            }
            case 37: {
                if (this.isFirstTime()) {
                    this.setFirstTime(false);
                    val = -3;
                    break;
                }
                val = this.readCapacity();
                response.put(57, (byte)8);
                response.limit(70);
                response.position(61);
                response.putInt(this.mac2blong((int)(this.totalSectors - 1L)));
                response.putInt(this.mac2blong((int)this.blockSize));
                this.setDataLength(8);
                break;
            }
            case 40: 
            case 168: {
                startingSectorNumber = packet.getLba();
                numberOfSectors = packet.getOpCode() == 40 ? (int)requestPacket.getCommandPkt().getCmd10().getLength() : packet.getCmd12().getLength32();
                if (startingSectorNumber >= 0L) {
                    startingSectorNumber = this.mac2blong(packet.getLba());
                } else {
                    byte[] tempBuff = ByteBuffer.allocate(8).putLong(startingSectorNumber).array();
                    tempBuff[3] = 0;
                    tempBuff[2] = 0;
                    tempBuff[1] = 0;
                    tempBuff[0] = 0;
                    byte temp6 = tempBuff[6];
                    byte temp7 = tempBuff[7];
                    tempBuff[7] = tempBuff[4];
                    tempBuff[6] = tempBuff[5];
                    tempBuff[4] = temp7;
                    tempBuff[5] = temp6;
                    startingSectorNumber = ByteBuffer.wrap(tempBuff).getLong();
                }
                numberOfSectors = this.mac2bshort(packet.getCmd10().getLength());
                readBuffer = this.readCDImage(startingSectorNumber, (int)numberOfSectors);
                response.putInt(57, readBuffer.length);
                this.setDataLength(readBuffer.length);
                break;
            }
            case 67: {
                val = this.readTOC(packet);
                maxTOCSize = packet.getCmd10().getLength();
                if (this.dataLength > maxTOCSize) {
                    this.dataLength = maxTOCSize;
                }
                response.put(57, (byte)this.getDataLength());
                break;
            }
            case 27: {
                val = 0;
                break;
            }
            default: {
                val = -9;
            }
        }
        this.setErrorStatus(val, response);
        if (requestPacket.getCommandPkt().getOpCode() == 40 || requestPacket.getCommandPkt().getOpCode() == 168) {
            response.position(61);
            response.limit(response.position() + readBuffer.length);
            response.put(readBuffer);
        } else if (requestPacket.getCommandPkt().getOpCode() == 67) {
            response.position(61);
            response.limit(response.position() + this.append.length);
            response.put(this.append);
        }
        return val;
    }

    private int testUnitReady() {
        int retVal = this.readCapacity();
        if (retVal != 0) {
            return retVal;
        }
        return 0;
    }

    private int readTOC(SCSICommandPacket packet) {
        byte nLength = 4;
        byte[] TOC = new byte[20];
        byte allocLength = 0;
        byte startTrack = packet.getCmd10().getReserved6();
        allocLength = this.mac2bshort((char)packet.getCmd10().getLength());
        if (startTrack > 1 && startTrack != 170) {
            return 0;
        }
        TOC[2] = 1;
        TOC[3] = 1;
        if (startTrack <= 1) {
            TOC[nLength++] = 0;
            TOC[nLength++] = 20;
            TOC[nLength++] = 1;
            TOC[nLength++] = 0;
            if ((packet.getLun() & 2) == 1) {
                TOC[nLength++] = 0;
                TOC[nLength++] = 0;
                TOC[nLength++] = 2;
                TOC[nLength++] = 0;
            } else {
                TOC[nLength++] = 0;
                TOC[nLength++] = 0;
                TOC[nLength++] = 0;
                TOC[nLength++] = 0;
            }
        }
        TOC[nLength++] = 0;
        TOC[nLength++] = 22;
        TOC[nLength++] = -86;
        TOC[nLength++] = 0;
        TOC[nLength++] = 0;
        TOC[nLength++] = (byte)((this.totalSectors + 150L) / 75L / 60L);
        TOC[nLength++] = (byte)((this.totalSectors + 150L) / 75L % 60L);
        TOC[nLength++] = (byte)((this.totalSectors + 150L) % 75L);
        if (nLength > allocLength) {
            nLength = allocLength;
        }
        TOC[0] = (byte)(nLength - 2 >> 8 & 0xFF);
        TOC[1] = (byte)(nLength - 2 & 0xFF);
        this.setDataLength(nLength);
        System.arraycopy(TOC, 0, this.append, 0, TOC.length);
        return 0;
    }

    private void setErrorStatus(int val, ByteBuffer response) {
        switch (val) {
            case 0: {
                response.put(53, (byte)0);
                response.put(54, (byte)0);
                response.put(55, (byte)0);
                response.put(56, (byte)0);
                break;
            }
            case -1: {
                response.put(53, (byte)1);
                response.put(54, (byte)5);
                response.put(55, (byte)33);
                response.put(56, (byte)0);
                break;
            }
            case -2: {
                response.put(53, (byte)0);
                response.put(54, (byte)3);
                response.put(55, (byte)48);
                response.put(56, (byte)1);
                break;
            }
            case -3: {
                response.put(53, (byte)1);
                response.put(54, (byte)6);
                response.put(55, (byte)40);
                response.put(56, (byte)0);
                break;
            }
            case -4: {
                response.put(53, (byte)1);
                response.put(54, (byte)3);
                response.put(55, (byte)17);
                response.put(56, (byte)0);
                break;
            }
            case -5: {
                response.put(53, (byte)1);
                response.put(54, (byte)2);
                response.put(55, (byte)58);
                response.put(56, (byte)0);
                break;
            }
            case -6: {
                response.put(53, (byte)1);
                response.put(54, (byte)5);
                response.put(55, (byte)38);
                response.put(56, (byte)0);
                break;
            }
            case -7: {
                response.put(53, (byte)1);
                response.put(54, (byte)3);
                response.put(55, (byte)48);
                response.put(56, (byte)2);
                break;
            }
            case -8: {
                response.put(53, (byte)1);
                response.put(54, (byte)5);
                response.put(55, (byte)83);
                response.put(56, (byte)2);
                break;
            }
            default: {
                response.put(53, (byte)1);
                response.put(54, (byte)5);
                response.put(55, (byte)32);
                response.put(56, (byte)0);
            }
        }
    }

    public byte mac2bshort(char x) {
        return (byte)(x >> 8 | x << 8);
    }

    public short mac2bshort(int x) {
        return (short)((short)x >> 8 | (short)x << 8);
    }

    public int mac2blong(int x) {
        return x >> 24 | x << 24 | (x & 0xFF0000) >> 8 | (x & 0xFF00) << 8;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeImage() {
        block11: {
            try {
                Object object;
                if (this.imageFile != null) {
                    this.imageFile.close();
                    this.imageFile = null;
                }
                if (this.readAheadCache == null) break block11;
                if (this.readAheadCache.getRequestHandler() != null) {
                    this.readAheadCache.getRequestHandler().stopThread();
                    object = this.readAheadCache.getCacheLock();
                    synchronized (object) {
                        this.readAheadCache.getCacheLock().notifyAll();
                    }
                }
                if (this.readAheadCache.getCacheManager() != null) {
                    this.readAheadCache.getCacheManager().stopThread();
                    object = this.readAheadCache.getCacheSync();
                    synchronized (object) {
                        this.readAheadCache.getCacheSync().notifyAll();
                    }
                }
                this.readAheadCache.stopThread();
                this.readAheadCache = null;
            }
            catch (IOException e) {
                this.imageFile = null;
            }
        }
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }
}

