/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.isocaching;

import Gbt.core.vmedia.isocaching.ReadAheadCache;
import java.io.IOException;

public class RequestHandler
extends Thread {
    private boolean running = false;
    private ReadAheadCache readAheadCache = null;
    private boolean sectorMiss = false;
    private long missingStartSector;

    public RequestHandler(ReadAheadCache readAheadCache) {
        this.readAheadCache = readAheadCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            if (this.isSectorMiss()) {
                byte[] sectorData = new byte[131072];
                long startingSector = this.missingStartSector;
                int numSectors = 64;
                this.setSectorMiss(false);
                if (this.readAheadCache.getCacheManager().getFreeBankCount() <= 0 && this.readAheadCache.getSectorDataCache().size() > 0) {
                    this.readAheadCache.getCacheManager().setCleanUpCache(true);
                    Object object = this.readAheadCache.getCacheLock();
                    synchronized (object) {
                        this.readAheadCache.getCacheLock().notifyAll();
                        if (this.readAheadCache.isCacheLocked()) {
                            try {
                                this.readAheadCache.getCacheLock().wait();
                            }
                            catch (InterruptedException e) {
                                e.getMessage();
                            }
                        }
                    }
                }
                int count = 0;
                int freeBanks = this.readAheadCache.getCacheManager().getFreeBankCount();
                for (count = 0; count < freeBanks; ++count) {
                    block22: {
                        try {
                            if (!this.readAheadCache.isFileReadWait()) break block22;
                            Object object = this.readAheadCache.getFileLock();
                            synchronized (object) {
                                try {
                                    this.readAheadCache.getFileLock().wait();
                                    sectorData = this.readAheadCache.readFromFile(startingSector, numSectors);
                                    this.readAheadCache.addToCache(sectorData, startingSector);
                                    startingSector += (long)numSectors;
                                }
                                catch (InterruptedException e) {
                                    e.getMessage();
                                }
                            }
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    if (!this.isSectorMiss()) continue;
                    ++count;
                    break;
                }
                this.readAheadCache.getCacheManager().setFreeBankCount(this.readAheadCache.getCacheManager().getFreeBankCount() - count);
            }
            Object object = this.readAheadCache.getReqSync();
            synchronized (object) {
                try {
                    this.readAheadCache.getReqSync().wait();
                }
                catch (InterruptedException e) {
                    e.getMessage();
                }
            }
        }
    }

    public void startThread() {
        this.setRunning(true);
        this.start();
    }

    public void stopThread() {
        this.setRunning(false);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isSectorMiss() {
        return this.sectorMiss;
    }

    public void setSectorMiss(boolean sectorMiss) {
        this.sectorMiss = sectorMiss;
    }

    public void setMissingBankInfo(long startingSector) {
        this.missingStartSector = startingSector;
    }
}

