/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

import Gbt.core.loggers.ShowMsg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class CopyFile {
    private CopyFile() {
    }

    public static final boolean copy(String srFile, String dtFile) {
        try {
            ShowMsg.showMsgInfo(CopyFile.class.getName(), "Copy source file : " + srFile + " to destination : " + dtFile);
            FileInputStream srcInputStream = new FileInputStream(srFile);
            FileOutputStream dstInputStream = new FileOutputStream(dtFile);
            FileChannel srcChannel = srcInputStream.getChannel();
            FileChannel dstChannel = dstInputStream.getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            srcInputStream.close();
            dstInputStream.close();
            return true;
        }
        catch (IOException e) {
            ShowMsg.showMsgInfo(CopyFile.class.getName(), e.getMessage());
            return false;
        }
    }

    public static final synchronized boolean synchronizedCopyFile(File srFile, File dtFile, boolean override) {
        if (!dtFile.exists()) {
            try {
                System.out.println("Copy source file : " + srFile);
                System.out.println("To destination   : " + dtFile);
                FileInputStream srcInputStream = new FileInputStream(srFile);
                FileOutputStream dstInputStream = new FileOutputStream(dtFile);
                FileChannel srcChannel = srcInputStream.getChannel();
                FileChannel dstChannel = dstInputStream.getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                srcInputStream.close();
                dstInputStream.close();
                return true;
            }
            catch (IOException e) {
                System.out.println("Copy file fail.");
                e.printStackTrace();
                return false;
            }
        }
        if (override) {
            try {
                System.out.println("Copy source file : " + srFile);
                System.out.println("To destination   : " + dtFile);
                FileInputStream srcInputStream = new FileInputStream(srFile);
                FileOutputStream dstInputStream = new FileOutputStream(dtFile);
                FileChannel srcChannel = srcInputStream.getChannel();
                FileChannel dstChannel = dstInputStream.getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                srcInputStream.close();
                dstInputStream.close();
                return true;
            }
            catch (IOException e) {
                System.out.println("Copy file fail.");
                e.printStackTrace();
                return false;
            }
        }
        System.out.println("File has already exist and not override.");
        return true;
    }
}

