/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Common;

public enum SystemTypes {
    UNKNOWN("Unknown"),
    WINDOWS("Windows"),
    LINUX("Linux"),
    MACOS("Mac");

    private static final String PRO_ITEM = "os.name";
    private static final String NA_ITEM = "Unknown";
    private static final String WIN_ITEM = "Windows";
    private static final String LIN_ITEM = "Linux";
    private static final String LIN_ITEM_2 = "nix";
    private static final String MAC_ITEM = "Mac";
    private final String name;

    private SystemTypes(String name) {
        this.name = name;
    }

    public boolean isWindows() {
        return this == WINDOWS;
    }

    public boolean isLinux() {
        return this == LINUX;
    }

    public boolean isMacOS() {
        return this == MACOS;
    }

    public String toString() {
        return this.name;
    }

    public static final SystemTypes getOsType() {
        if (System.getProperty(PRO_ITEM).startsWith(WIN_ITEM)) {
            return WINDOWS;
        }
        if (System.getProperty(PRO_ITEM).startsWith(LIN_ITEM) || System.getProperty(PRO_ITEM).toLowerCase().contains(LIN_ITEM_2)) {
            return LINUX;
        }
        if (System.getProperty(PRO_ITEM).startsWith(MAC_ITEM) || System.getProperty(PRO_ITEM).indexOf("aix") > 0) {
            return MACOS;
        }
        return UNKNOWN;
    }
}

