/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Configdeploy;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.CopyFile;
import Gbt.utility.Common.UncompressFile;
import Gbt.utility.Configdeploy.ConfigItems;
import Gbt.utility.Configdeploy.ConfigRow;
import Gbt.utility.Configdeploy.ConfigTable;
import java.io.File;
import java.util.List;

public class ConfigDeployCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "configdeploy";
    private GbtIPMICommandReceiver ipmiReceiver;
    private GbtLocalCommandReceiver localReceiver;
    private GbtSSHCommandReceiver sshReceiver;
    private static boolean checkCfgLock = false;

    private ConfigDeployCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
        this.sshReceiver = GbtSSHCommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        if (this.sshReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSH command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.commandArgs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Remote BMC IP is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result = true;
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unzip " + ((Builder)this.commandArgs).configPkgName);
        String absConfigPkgPath = new File("./" + ((Builder)this.commandArgs).configPkgName).getAbsolutePath();
        if (!UncompressFile.deCompressedFile(absConfigPkgPath, true)) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Extract config pkg fail."));
            return false;
        }
        if (!this.checkConfigPkg(absConfigPkgPath, "configPkg")) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Check config pkg fail."));
            return false;
        }
        ((Builder)this.commandArgs).configTable = new ConfigTable();
        this.modifyConfigTable(((Builder)this.commandArgs).configTable);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Table:\n" + ((Builder)this.commandArgs).configTable.print());
        ConfigItems configItems = new ConfigItems(this.getStartTime(), this.loggerWriter, ((Builder)this.commandArgs).debugFile, COMMAND_NAME, this.commandID);
        for (ConfigRow row : ((Builder)this.commandArgs).configTable.getConfigTable()) {
            ConfigRow.ConfigItemName name = row.getItemName();
            if (!row.getAction().equals((Object)ConfigRow.Action.DO)) continue;
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start item:[" + (Object)((Object)name) + "]");
            if (name.equals((Object)ConfigRow.ConfigItemName.CHECKBMCPLATFORM)) {
                result = configItems.checkIsAMI(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.BOOTINTOMINIOS) || name.equals((Object)ConfigRow.ConfigItemName.REBOOTINTOMINIOS)) {
                result = configItems.bootIntoMiniOS(((Builder)this.commandArgs).isUEFI, ((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, absConfigPkgPath, ((Builder)this.commandArgs).miniOSISOName, ((Builder)this.commandArgs).serverIP);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.UPDATEBIOS)) {
                result = configItems.updateBIOS(((Builder)this.commandArgs).firmwareOfBIOS.getName(), ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.UPDATEBMC)) {
                result = configItems.updateBMC(((Builder)this.commandArgs).firmwareOfBMC.getName(), ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.RESTOREBMC)) {
                result = configItems.restoreBMC(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.RESTOREBIOS)) {
                result = configItems.configRestore("BIOS", "01-biosCfgRes.res", ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.RESTORELAN)) {
                result = configItems.configRestore("LAN", "10-eepromRes.res", ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.RESTOREPART)) {
                result = configItems.configRestore("partition", "02-partitionTable.res", ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.RESTORERAID)) {
                result = configItems.configRestore("RAID", "99-raidCfgRes.res", ((Builder)this.commandArgs).timeout);
            }
            if (result) continue;
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail item:" + (Object)((Object)name));
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Fail item:" + (Object)((Object)name)));
            break;
        }
        configItems.close();
        if (result) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Config deploy success.");
            this.commandResults.add(new NullJSONData().setError(false).setMessages("Config deploy success."));
        }
        return result;
    }

    private void modifyConfigTable(ConfigTable table) {
        this.modifyConfigTableByInitial(table);
        this.modifyConfigTableByRelated(table);
    }

    private void modifyConfigTableByInitial(ConfigTable table) {
        for (ConfigRow.ConfigItemName config : ConfigRow.ConfigItemName.values()) {
            table.addConfigTow(new ConfigRow().setItemName(config).setAction(ConfigRow.Action.SKIP));
        }
        table.getConfigRow(ConfigRow.ConfigItemName.CHECKBMCPLATFORM).setAction(ConfigRow.Action.DO);
        if (((Builder)this.commandArgs).restoreBIOS) {
            table.getConfigRow(ConfigRow.ConfigItemName.RESTOREBIOS).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).restoreBMC) {
            table.getConfigRow(ConfigRow.ConfigItemName.RESTOREBMC).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).restoreLAN) {
            table.getConfigRow(ConfigRow.ConfigItemName.RESTORELAN).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).restorePart) {
            table.getConfigRow(ConfigRow.ConfigItemName.RESTOREPART).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).restoreRAID) {
            table.getConfigRow(ConfigRow.ConfigItemName.RESTORERAID).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).updateBIOS) {
            table.getConfigRow(ConfigRow.ConfigItemName.UPDATEBIOS).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).updateBMC) {
            table.getConfigRow(ConfigRow.ConfigItemName.UPDATEBMC).setAction(ConfigRow.Action.DO);
        }
    }

    private void modifyConfigTableByRelated(ConfigTable table) {
        if (table.getConfigRow(ConfigRow.ConfigItemName.UPDATEBIOS).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
            table.getConfigRow(ConfigRow.ConfigItemName.REBOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        } else if (table.getConfigRow(ConfigRow.ConfigItemName.UPDATEBMC).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        } else if (table.getConfigRow(ConfigRow.ConfigItemName.RESTOREBMC).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        } else if (table.getConfigRow(ConfigRow.ConfigItemName.RESTOREBIOS).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        } else if (table.getConfigRow(ConfigRow.ConfigItemName.RESTORELAN).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        } else if (table.getConfigRow(ConfigRow.ConfigItemName.RESTOREPART).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        } else if (table.getConfigRow(ConfigRow.ConfigItemName.RESTORERAID).getAction().equals((Object)ConfigRow.Action.DO)) {
            table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        }
    }

    @Override
    public void cancelHook(Object obj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkConfigPkg(String configPkgPath, String subDirName) {
        boolean result = false;
        if (checkCfgLock) return result;
        Class<ConfigDeployCommand> clazz = ConfigDeployCommand.class;
        synchronized (ConfigDeployCommand.class) {
            if (checkCfgLock) return result;
            checkCfgLock = true;
            String subDirAbsPath = new File("./" + subDirName).getAbsolutePath();
            System.out.println("subDirName:" + subDirName);
            System.out.println("subDirAbsPath:" + subDirAbsPath);
            List<File> fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "bmc", ".zip", true);
            if (fileList != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).updateBMC = true;
                ((Builder)this.commandArgs).firmwareOfBMC = fileList.get(0);
                result = true;
            } else {
                ((Builder)this.commandArgs).updateBMC = false;
            }
            fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "bios", ".zip", true);
            if (fileList != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).updateBIOS = true;
                ((Builder)this.commandArgs).firmwareOfBIOS = fileList.get(0);
                result = true;
            } else {
                ((Builder)this.commandArgs).updateBIOS = false;
            }
            fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "bmc", ".conf", true);
            if (fileList != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).confOfBMC = fileList.get(0);
            }
            if ((fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "bmc", ".sh", true)) != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).scriptOfBMC = fileList.get(0);
            }
            if (((Builder)this.commandArgs).confOfBMC != null && ((Builder)this.commandArgs).confOfBMC.exists() && ((Builder)this.commandArgs).scriptOfBMC.exists()) {
                CopyFile.copy(((Builder)this.commandArgs).confOfBMC.getAbsolutePath(), "./" + ((Builder)this.commandArgs).confOfBMC.getName());
                CopyFile.copy(((Builder)this.commandArgs).scriptOfBMC.getAbsolutePath(), "./" + ((Builder)this.commandArgs).scriptOfBMC.getName());
                ((Builder)this.commandArgs).restoreBMC = true;
                result = true;
            } else {
                ((Builder)this.commandArgs).restoreBMC = false;
            }
            fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "bios", "nvram.log", true);
            if (fileList != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).restoreBIOS = true;
                ((Builder)this.commandArgs).configOfBIOS = fileList.get(0);
                result = true;
            } else {
                ((Builder)this.commandArgs).restoreBIOS = false;
            }
            fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "lan", ".eep", true);
            if (fileList != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).restoreLAN = true;
                ((Builder)this.commandArgs).configOfLAN = fileList.get(0);
                result = true;
            } else {
                ((Builder)this.commandArgs).restoreLAN = false;
            }
            ((Builder)this.commandArgs).restorePart = false;
            fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "partition", ".gpt", true);
            if (fileList != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).restorePart = true;
                ((Builder)this.commandArgs).configOfPart = fileList;
                result = true;
            }
            if ((fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "partition", ".mbr", true)) != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).restorePart = true;
                ((Builder)this.commandArgs).configOfPart = fileList;
                result = true;
            }
            if ((fileList = CommonFunction.searchFilesInDirector(subDirAbsPath + File.separator + "configs" + File.separator + "raid", ".raid", true)) != null && !fileList.isEmpty()) {
                ((Builder)this.commandArgs).restoreRAID = true;
                ((Builder)this.commandArgs).configOfRAID = fileList;
                result = true;
            } else {
                ((Builder)this.commandArgs).restoreRAID = false;
            }
            System.out.println("********** The following configs will be deployed: **********");
            System.out.println("* BMC firmware : " + (((Builder)this.commandArgs).updateBMC ? ((Builder)this.commandArgs).firmwareOfBMC.getName() : "<none>"));
            System.out.println("* BIOS firmware: " + (((Builder)this.commandArgs).updateBIOS ? ((Builder)this.commandArgs).firmwareOfBIOS.getName() : "<none>"));
            System.out.println("* BMC config   : " + (((Builder)this.commandArgs).restoreBMC ? ((Builder)this.commandArgs).confOfBMC.getName() + "," + ((Builder)this.commandArgs).scriptOfBMC.getName() : "<none>"));
            System.out.println("* BIOS config  : " + (((Builder)this.commandArgs).restoreBIOS ? ((Builder)this.commandArgs).configOfBIOS.getName() : "<none>"));
            System.out.println("* LAN config  : " + (((Builder)this.commandArgs).restoreLAN ? ((Builder)this.commandArgs).configOfLAN.getName() : "<none>"));
            String findResult = "";
            if (((Builder)this.commandArgs).configOfPart != null) {
                for (File f : ((Builder)this.commandArgs).configOfPart) {
                    findResult = findResult + f.getName() + ",";
                }
            }
            System.out.println("* Partition config: " + (((Builder)this.commandArgs).restorePart ? findResult : "<none>"));
            findResult = "";
            if (((Builder)this.commandArgs).configOfRAID != null) {
                for (File f : ((Builder)this.commandArgs).configOfRAID) {
                    findResult = findResult + f.getName() + ",";
                }
            }
            System.out.println("* RAID config  : " + (((Builder)this.commandArgs).restoreRAID ? findResult : "<none>"));
            System.out.println("*************************************************************");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String miniOSISOName;
        private int timeout = 60;
        private String configPkgName;
        private String serverIP;
        private boolean isUEFI;
        private boolean updateBMC = false;
        private boolean updateBIOS = false;
        private boolean restoreBMC;
        private boolean restoreBIOS;
        private boolean restoreLAN = false;
        private boolean restorePart = false;
        private boolean restoreRAID = false;
        private File firmwareOfBMC;
        private File firmwareOfBIOS;
        private File confOfBMC;
        private File scriptOfBMC;
        private File configOfBIOS;
        private File configOfLAN;
        private List<File> configOfPart;
        private List<File> configOfRAID;
        private File debugFile = null;
        private ConfigTable configTable;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].contains("timeout=")) {
                        this.timeout = Integer.parseInt(this.args[i].substring(this.args[i].lastIndexOf("timeout=") + 8));
                        continue;
                    }
                    if (this.args[i].contains("uefi=")) {
                        this.isUEFI = Boolean.valueOf(this.args[i].substring(this.args[i].lastIndexOf("uefi=") + 5));
                        continue;
                    }
                    if (this.args[i].contains("debug=")) {
                        this.debugFile = new File(this.args[i].substring(this.args[i].lastIndexOf("debug=") + 6));
                        if (this.debugFile.exists()) continue;
                        System.out.println("Debug file is not exist!");
                        return false;
                    }
                    if (i == 0) {
                        this.miniOSISOName = this.args[i];
                        continue;
                    }
                    if (i == 1) {
                        this.serverIP = this.args[i];
                        continue;
                    }
                    if (i != 2) continue;
                    this.configPkgName = this.args[i];
                }
                return this.miniOSISOName != null && this.serverIP != null && this.configPkgName != null;
            }
            return false;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public ConfigDeployCommand build() {
            return new ConfigDeployCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setMiniOSImage(String osISOName) {
            this.miniOSISOName = osISOName;
            return this.getThis();
        }

        public Builder setConfigPkg(String configPkgName) {
            this.configPkgName = configPkgName;
            return this.getThis();
        }

        public Builder setServerIP(String serverIP) {
            this.serverIP = serverIP;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.configPkgName = null;
            this.miniOSISOName = null;
            this.firmwareOfBMC = null;
            this.firmwareOfBIOS = null;
            this.confOfBMC = null;
            this.scriptOfBMC = null;
            this.configOfBIOS = null;
            this.configOfLAN = null;
            this.configTable = null;
            this.loggerWriter.close();
        }
    }
}

