/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.FRU.record;

import Gbt.utility.FRU.record.ChassisType;
import Gbt.utility.FRU.record.FruRecord;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class ChassisInfo
extends FruRecord {
    private ChassisType chassisType;
    private String chassisPartNumber;
    private String chassisSerialNumber;
    private String customChassisInfo;

    public ChassisInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        this.chassisType = ChassisType.parseInt(TypeConverter.byteToInt(fruData[offset + 2]));
        int partNumber = TypeConverter.byteToInt(fruData[offset + 3]);
        offset += 4;
        int index = 0;
        StringBuilder buffer = new StringBuilder();
        block4: while (partNumber != 193 && offset < fruData.length) {
            int partType = (partNumber & 0xC0) >> 6;
            int partDataLength = partNumber & 0x3F;
            if (partDataLength > 0 && partDataLength + offset < fruData.length) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, offset, partNumberData, 0, partDataLength);
                offset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setChassisPartNumber(ChassisInfo.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 1: {
                        this.setChassisSerialNumber(ChassisInfo.decodeString(partType, partNumberData, true));
                        break;
                    }
                    default: {
                        if (partDataLength == 0) continue block4;
                        buffer.append(ChassisInfo.decodeString(partType, partNumberData, true));
                    }
                }
            }
            partNumber = TypeConverter.byteToInt(fruData[offset]);
            ++offset;
            ++index;
        }
        if (buffer.length() > 0) {
            this.customChassisInfo = buffer.toString();
        }
    }

    @JsonProperty(value="ChassisType")
    public ChassisType getChassisType() {
        return this.chassisType;
    }

    public void setChassisType(ChassisType chassisType) {
        this.chassisType = chassisType;
    }

    @JsonProperty(value="ChassisPartNumber")
    public String getChassisPartNumber() {
        return this.chassisPartNumber;
    }

    public void setChassisPartNumber(String chassisPartNumber) {
        this.chassisPartNumber = chassisPartNumber;
    }

    @JsonProperty(value="ChassisSerialNumber")
    public String getChassisSerialNumber() {
        return this.chassisSerialNumber;
    }

    public void setChassisSerialNumber(String chassisSerialNumber) {
        this.chassisSerialNumber = chassisSerialNumber;
    }

    @JsonProperty(value="CustomChassisInfo")
    public String getCustomChassisInfo() {
        return this.customChassisInfo;
    }

    public void setCustomChassisInfo(String customChassisInfo) {
        this.customChassisInfo = customChassisInfo;
    }
}

