/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.IPSrc;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.bmclanconfig.BMCLanConfigCommand;
import Gbt.utility.bmclanconfig.BMCLanConfigData;
import Gbt.utility.bmclanconfig.BMCLanConfigIPMIOptions;
import Gbt.utility.bmclanconfig.BMCLanConfigIPSource;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class IPSrcCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "ipsrc";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private BMCLanConfigData bmcLanConfigData = new BMCLanConfigData();

    protected IPSrcCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        if (((Builder)this.commandArgs).setOption) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to set BMC IP source settings.");
            this.bmcLanConfigData.setIpAddressSource(((Builder)this.commandArgs).ipSource);
            AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, BMCLanConfigIPMIOptions.SET_IP_ADDRESS_SOURCE, new BMCLanConfigCommand.Builder().setBmcLanConfigData(this.bmcLanConfigData), COMMAND_NAME, this.commandID);
            if (responseData instanceof NullJSONData) {
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set " + BMCLanConfigIPMIOptions.SET_IP_ADDRESS_SOURCE.getItem() + " fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
            }
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get BMC IP source settings.");
            AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, BMCLanConfigIPMIOptions.GET_IP_ADDRESS_SOURCE, new BMCLanConfigCommand.Builder(), COMMAND_NAME, this.commandID);
            if (responseData instanceof NullJSONData) {
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get " + BMCLanConfigIPMIOptions.GET_IP_ADDRESS_SOURCE.getItem() + " fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            } else {
                this.bmcLanConfigData = responseData.castConcreteJSON(BMCLanConfigData.class);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, this.bmcLanConfigData.toString());
                this.commandResults.add(responseData);
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private boolean setOption = false;
        private BMCLanConfigIPSource ipSource = BMCLanConfigIPSource.Unspecified;

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setIpSource(BMCLanConfigIPSource ipSource) {
            this.ipSource = ipSource;
            this.setOption = true;
            return this.getThis();
        }

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "get": {
                        this.setOption = false;
                        break;
                    }
                    case "set": {
                        if (this.args.length != 2) {
                            return false;
                        }
                        this.ipSource = BMCLanConfigIPSource.parseByStrings(this.args[1]);
                        this.setOption = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public IPSrcCommand build() {
            return new IPSrcCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.ipSource = null;
            this.loggerWriter.close();
        }
    }
}

