/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.MSR;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.MSR.MsrIpmiOptions;
import Gbt.utility.MSR.NodeManagementData;
import Gbt.utility.MSR.NodeMsrFullData;
import Gbt.utility.MSR.NodeMsrReadingData;
import Gbt.utility.MSR.NodeRdCfgData;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import java.math.BigDecimal;

public final class MSRCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "msr";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private static final int COUNT_ALL = 44;
    private static final byte[] CLIENT_ADDRS = new byte[]{48, 49};

    protected MSRCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        NullJSONData temp;
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCInfoJSONData bmcInfo = this.ipmiReceiver.getBmcInfo(handle, ((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID);
        if (bmcInfo == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Get BMC info fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC info fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        if (!bmcInfo.isIntel()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Only support on Intel");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        GetChassisStatusResponseData status = this.ipmiReceiver.getChassisPowerStates(handle, COMMAND_NAME, this.commandID);
        if (!status.isPowerOn()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Node power is off.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, MsrIpmiOptions.GET_NODE_MANAGEMENT_DATA, this.commandArgs, COMMAND_NAME, this.commandID);
        if (resp instanceof NullJSONData && (temp = resp.castConcreteJSON(NullJSONData.class)).isError()) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get node management data success.");
        if (!resp.castConcreteJSON(NodeManagementData.class).getNMSupport().booleanValue()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not supported msr command.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        for (int cpu_id = 0; cpu_id < CLIENT_ADDRS.length; ++cpu_id) {
            ((Builder)this.commandArgs).setClientAddr(CLIENT_ADDRS[cpu_id]);
            resp = this.ipmiReceiver.sendIPMIRawCommand(handle, MsrIpmiOptions.GET_RD_PKG_CONFIG, this.commandArgs, COMMAND_NAME, this.commandID);
            if (resp instanceof NodeRdCfgData) {
                if (resp.castConcreteJSON(NodeRdCfgData.class).getTjmax() == 0) continue;
                NodeMsrFullData fullData = new NodeMsrFullData();
                fullData.setCPU_ID(new BigDecimal(cpu_id));
                for (int i = 0; i < 44; ++i) {
                    NodeMsrReadingData temp2;
                    byte status_byte = 0;
                    if (i % 4 != 1) continue;
                    byte[] posBytes = new byte[]{(byte)i, 4};
                    ((Builder)this.commandArgs).setReadPosition(i);
                    StringBuilder msgBuffer = new StringBuilder().append(GbtCommonConverters.bytesToHexReverse(posBytes)).append(" :\t");
                    resp = this.ipmiReceiver.sendIPMIRawCommand(handle, MsrIpmiOptions.MSR_READ, this.commandArgs, COMMAND_NAME, this.commandID);
                    if (resp instanceof NodeMsrReadingData) {
                        temp2 = resp.castConcreteJSON(NodeMsrReadingData.class);
                        temp2.setPosition(GbtCommonConverters.bytesToHexReverse(posBytes));
                        temp2.setSupported(Boolean.TRUE);
                        fullData.setReadings(temp2);
                        for (byte value : temp2.getValues()) {
                            msgBuffer.append(GbtCommonConverters.bytesToHex(value)).append("\t");
                            status_byte = (byte)(status_byte | value);
                        }
                        if (status_byte != 0) {
                            fullData.setCPUOK(Boolean.FALSE);
                        }
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, msgBuffer.toString());
                        continue;
                    }
                    temp2 = new NodeMsrReadingData();
                    temp2.setPosition(GbtCommonConverters.bytesToHexReverse(posBytes));
                    temp2.setSupported(Boolean.FALSE);
                    fullData.setReadings(temp2);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, msgBuffer.toString() + " Not support.");
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "CPU_" + cpu_id + (fullData.getCPUOK() != false ? " ok." : " error."));
                this.commandResults.add(fullData);
                continue;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] CPU_" + cpu_id + " not exist.");
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    private final boolean isIPMISendMessagesFail(AbstractJSONPOJO resp) {
        if (resp instanceof NullJSONData) {
            NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
            if (temp.isError()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
                return true;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            this.commandResults.add(temp);
            return false;
        }
        return false;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private byte clientAddr;
        private int readPosition;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            return this.args == null || this.args.length == 0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public MSRCommand build() {
            return new MSRCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        protected byte getClientAddr() {
            return this.clientAddr;
        }

        protected void setClientAddr(byte clientAddr) {
            this.clientAddr = clientAddr;
        }

        protected int getReadPosition() {
            return this.readPosition;
        }

        protected void setReadPosition(int readPosition) {
            this.readPosition = readPosition;
        }
    }
}

