/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.PEF;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.PEF.PEFCommand;
import Gbt.utility.PEF.PEFEntry;
import Gbt.utility.PEF.PEFEventServerity;
import Gbt.utility.PEF.PEFEventTrigger;
import Gbt.utility.PEF.PefActions;
import Gbt.utility.SDR.record.SensorType;
import com.veraxsystems.vxipmi.common.TypeConverter;

public enum PEFIpmiOptions implements GbtIPMIOptions<PEFCommand.Builder>
{
    GET(0, "get", 19),
    SET(1, "set", 18);

    private static final String GET_ITEM = "get";
    private static final String SET_ITEM = "set";
    private final int optionCode;
    private final String item;
    private static final byte NET_FN = 4;
    private static final int FilterReqSize = 22;
    private static final byte PARAMETER_SELECTOR = 6;
    private final byte commandCode;

    private PEFIpmiOptions(int optionCode, String item, byte commandCode) {
        this.optionCode = optionCode;
        this.item = item;
        this.commandCode = commandCode;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 4;
    }

    @Override
    public byte getCommandCode() {
        return this.commandCode;
    }

    @Override
    public byte[] rebuildRequestData(PEFCommand.Builder commandArgs) {
        switch (this) {
            case GET: {
                byte[] getPEFReqData = new byte[]{6, (byte)commandArgs.getFilterNumber(), 0};
                return getPEFReqData;
            }
            case SET: {
                PEFEntry entry = commandArgs.getPEFEntry();
                PefActions action = commandArgs.getPefActions();
                Boolean enable = commandArgs.getEnable();
                if (entry.getActionSetting() == null) {
                    entry.setActionSetting(entry.getPower_action());
                }
                if (entry.getAlertSetting() == null) {
                    entry.setAlertSetting(entry.getAlert());
                }
                if (action != null) {
                    entry.setActionSetting(action);
                }
                if (enable != null) {
                    entry.setAlertSetting(enable);
                }
                byte[] setPEFReqData = new byte[22];
                byte[] pefFilterData = entry.getRaw_data();
                setPEFReqData[0] = 6;
                System.arraycopy(pefFilterData, 1, setPEFReqData, 1, pefFilterData.length - 1);
                setPEFReqData[3] = entry.getActionSetting().getFilterActionCode(entry.getAlertSetting());
                return setPEFReqData;
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] raw = gbtResponseData.getAllResponseData();
        switch (this) {
            case GET: {
                PEFEntry info = new PEFEntry();
                info.setFilterNumber(TypeConverter.byteToInt(raw[1]));
                info.setEventTrigger(PEFEventTrigger.parse(raw[10]));
                info.setSensorType(SensorType.parseInt(raw[8]));
                info.setTriggerEventSeverity(PEFEventServerity.parse(raw[5]));
                info.setPowerAction(PefActions.parseByte(raw[3]));
                info.setEnableFilter((raw[2] & 0x80) == 128);
                info.setAlert((raw[3] & 1) == 1);
                info.setRawData(raw);
                return info;
            }
            case SET: {
                return new NullJSONData().setMessages("PEF " + this.getItem() + " success").setError(false);
            }
        }
        return new NullJSONData().setMessages("Unknown options.").setError(true);
    }
}

