/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.PEF;

import com.fasterxml.jackson.annotation.JsonValue;

public enum PefActions {
    OFF(2, "off"),
    NONE(0, "none"),
    REBOOT(4, "reboot"),
    CYCLE(8, "cycle");

    private static final String OFF_ITEM = "off";
    private static final String NONE_ITEM = "none";
    private static final String REBOOT_ITEM = "reboot";
    private static final String CYCLE_ITEM = "cycle";
    private static final int OFF_CODE = 2;
    private static final int NONE_CODE = 0;
    private static final int REBOOT_CODE = 4;
    private static final int CYCLE_CODE = 8;
    private final int code;
    private final String item;

    private PefActions(int code, String item) {
        this.code = code;
        this.item = item;
    }

    public final byte getFilterActionCode(boolean enable) {
        switch (this) {
            case NONE: {
                return enable ? (byte)(this.code + 1) : (byte)this.code;
            }
            case REBOOT: {
                return enable ? (byte)(this.code + 1) : (byte)this.code;
            }
            case CYCLE: {
                return enable ? (byte)(this.code + 1) : (byte)this.code;
            }
        }
        return enable ? (byte)(this.code + 1) : (byte)this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final PefActions parse(String rawString) {
        if (rawString == null) {
            return OFF;
        }
        switch (rawString) {
            case "none": {
                return NONE;
            }
            case "reboot": {
                return REBOOT;
            }
            case "cycle": {
                return CYCLE;
            }
        }
        return OFF;
    }

    public static final PefActions parseByte(byte action) {
        switch (action) {
            case 0: {
                return NONE;
            }
            case 4: {
                return REBOOT;
            }
            case 8: {
                return CYCLE;
            }
        }
        return OFF;
    }
}

