/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.utility.SMBIOS.SmbiosTypeCollection;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.menu.GbtUtility;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.requests.SMBIOSRequest;
import Gbt.utility.rest.requests.SessionRequest;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class GetSMBIOSCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "smbios";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final RESTClientReceiver restReceiver;
    private static final String REMOTE_FILE_NAME = "/var/smash/smbios_mv.bin";

    protected GetSMBIOSCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.restReceiver = RESTClientReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Check arguments fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI ipmiReceiver is null.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start get SMBIOS info.");
        File dumpFile = new File(GbtUtility.getResultsRootPath() + "/" + COMMAND_NAME + "/" + ((Builder)this.commandArgs).bmcIP + "_SMBIOS.bin");
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, COMMAND_NAME, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                if (!this.ipmiReceiver.getSMBIOSAndHDDInfo(handle, REMOTE_FILE_NAME, dumpFile, 1, COMMAND_NAME, this.commandID)) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Download SMBIOS file fail.");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.commandResults.addAll(SmbiosTypeCollection.parseFullSMBIOSData(dumpFile));
                if (this.commandResults.isEmpty()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] No SMBIOS data ...");
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, JacksonCommonUtil.getUtil().getPrettyPrintString(this.commandResults));
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                break;
            }
            case AMI: {
                Response response;
                RESTRequest request;
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                Client client = this.restReceiver.createHttpsClient(((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID, false);
                if (client == null) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSL context initialize fail.");
                    return false;
                }
                AMIRestSessionData sessionData = null;
                try {
                    request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(((Builder)this.commandArgs).bmcIP)).setContentType("application/x-www-form-urlencoded")).setFormData("username", ((Builder)this.commandArgs).bmcUsername)).setFormData("password", ((Builder)this.commandArgs).bmcPassword)).build();
                    response = this.restReceiver.syncInvoke(client, request, COMMAND_NAME, this.commandID);
                    sessionData = this.restReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Open session success.");
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Open session fail.", re);
                    client.close();
                    return false;
                }
                try {
                    request = ((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)new SMBIOSRequest.Builder().setHostname(((Builder)this.commandArgs).bmcIP)).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setCookies(sessionData)).setDownloadFileNmae(dumpFile).build();
                    response = this.restReceiver.syncInvoke(client, request, COMMAND_NAME, this.commandID);
                    this.commandResults.addAll(this.restReceiver.downloadSmbios(response, dumpFile));
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, JacksonCommonUtil.getUtil().getPrettyPrintString(this.commandResults));
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get SMBIOS info fail, " + re.getMessage());
                    client.close();
                    return false;
                }
                try {
                    request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(((Builder)this.commandArgs).bmcIP)).setContentType("application/x-www-form-urlencoded")).setCookies(sessionData)).build();
                    response = this.restReceiver.syncInvoke(client, request, COMMAND_NAME, this.commandID);
                    sessionData = this.restReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Close session success.");
                    break;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Close session fail.", re);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (client != null) {
                        sessionData = null;
                        client.close();
                    }
                }
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            return this.args == null || this.args.length == 0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public GetSMBIOSCommand build() {
            return new GetSMBIOSCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }
    }
}

