/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.SMBIOS.SmbiosType0;
import Gbt.utility.SMBIOS.SmbiosType1;
import Gbt.utility.SMBIOS.SmbiosType128;
import Gbt.utility.SMBIOS.SmbiosType129;
import Gbt.utility.SMBIOS.SmbiosType130;
import Gbt.utility.SMBIOS.SmbiosType131;
import Gbt.utility.SMBIOS.SmbiosType16;
import Gbt.utility.SMBIOS.SmbiosType17;
import Gbt.utility.SMBIOS.SmbiosType19;
import Gbt.utility.SMBIOS.SmbiosType2;
import Gbt.utility.SMBIOS.SmbiosType20;
import Gbt.utility.SMBIOS.SmbiosType3;
import Gbt.utility.SMBIOS.SmbiosType32;
import Gbt.utility.SMBIOS.SmbiosType4;
import Gbt.utility.SMBIOS.SmbiosType7;
import Gbt.utility.SMBIOS.SmbiosType9;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public enum SmbiosTypeCollection {
    UnknownType(127, "Unknown Type"),
    Type0(0, "Type 0 BIOS Information"),
    Type1(1, "Type 1 System Information"),
    Type2(2, "Type 2 Baseboard (or Module) Information"),
    Type3(3, "Type 3 System Enclosure"),
    Type4(4, "Type 4 Processor Information"),
    Type7(7, "Type 7 Cache Information"),
    Type9(9, "Type 9 System Slots"),
    Type16(16, "Type 16 Physical Memory Array"),
    Type17(17, "Type 17 Memory Device"),
    Type19(19, "Type 19 Memory Array Mapped Address"),
    Type20(20, "Type 20 Memory Device Mapped Address"),
    Type32(32, "Type 32 System Boot Information"),
    Type128(-128, "Type 128 OEM Header"),
    Type129(-127, "Type 129 HDD Infomation"),
    Type130(-126, "Type 130 PCIeInformation"),
    Type131(-125, "Type 131 Networking Information");

    private static final byte UNKNOWN_TYPE_CODE = 127;
    private static final byte TYPE_0_CODE = 0;
    private static final byte TYPE_1_CODE = 1;
    private static final byte TYPE_2_CODE = 2;
    private static final byte TYPE_3_CODE = 3;
    private static final byte TYPE_4_CODE = 4;
    private static final byte TYPE_7_CODE = 7;
    private static final byte TYPE_9_CODE = 9;
    private static final byte TYPE_16_CODE = 16;
    private static final byte TYPE_17_CODE = 17;
    private static final byte TYPE_19_CODE = 19;
    private static final byte TYPE_20_CODE = 20;
    private static final byte TYPE_32_CODE = 32;
    private static final byte TYPE_128_CODE = -128;
    private static final byte TYPE_129_CODE = -127;
    private static final byte TYPE_130_CODE = -126;
    private static final byte TYPE_131_CODE = -125;
    private static final String UNKNOWN_TYPE_ITEM = "Unknown Type";
    private static final String TYPE_0_ITEM = "Type 0 BIOS Information";
    private static final String TYPE_1_ITEM = "Type 1 System Information";
    private static final String TYPE_2_ITEM = "Type 2 Baseboard (or Module) Information";
    private static final String TYPE_3_ITEM = "Type 3 System Enclosure";
    private static final String TYPE_4_ITEM = "Type 4 Processor Information";
    private static final String TYPE_7_ITEM = "Type 7 Cache Information";
    private static final String TYPE_9_ITEM = "Type 9 System Slots";
    private static final String TYPE_16_ITEM = "Type 16 Physical Memory Array";
    private static final String TYPE_17_ITEM = "Type 17 Memory Device";
    private static final String TYPE_19_ITEM = "Type 19 Memory Array Mapped Address";
    private static final String TYPE_20_ITEM = "Type 20 Memory Device Mapped Address";
    private static final String TYPE_32_ITEM = "Type 32 System Boot Information";
    private static final String TYPE_128_ITEM = "Type 128 OEM Header";
    private static final String TYPE_129_ITEM = "Type 129 HDD Infomation";
    private static final String TYPE_130_ITEM = "Type 130 PCIeInformation";
    private static final String TYPE_131_ITEM = "Type 131 Networking Information";
    private static final String SMBIOS_ANCHOR_21 = "_SM_";
    private static final String SMBIOS_ANCHOR_30 = "_SM3";
    private final byte typeCode;
    private final String typeName;

    private SmbiosTypeCollection(byte typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    public byte getTypeCode() {
        return this.typeCode;
    }

    @JsonValue
    public String toString() {
        return this.typeName;
    }

    public final SmbiosTypeBase createSMBIOSData(byte[] rawData) {
        switch (this) {
            case Type0: {
                return new SmbiosType0(rawData);
            }
            case Type1: {
                return new SmbiosType1(rawData);
            }
            case Type2: {
                return new SmbiosType2(rawData);
            }
            case Type3: {
                return new SmbiosType3(rawData);
            }
            case Type4: {
                return new SmbiosType4(rawData);
            }
            case Type7: {
                return new SmbiosType7(rawData);
            }
            case Type9: {
                return new SmbiosType9(rawData);
            }
            case Type16: {
                return new SmbiosType16(rawData);
            }
            case Type17: {
                return new SmbiosType17(rawData);
            }
            case Type19: {
                return new SmbiosType19(rawData);
            }
            case Type20: {
                return new SmbiosType20(rawData);
            }
            case Type32: {
                return new SmbiosType32(rawData);
            }
            case Type128: {
                return new SmbiosType128(rawData);
            }
            case Type129: {
                return new SmbiosType129(rawData);
            }
            case Type130: {
                return new SmbiosType130(rawData);
            }
            case Type131: {
                return new SmbiosType131(rawData);
            }
        }
        return null;
    }

    public static final SmbiosTypeCollection parseType(byte typeCode) {
        switch (typeCode) {
            case 0: {
                return Type0;
            }
            case 1: {
                return Type1;
            }
            case 2: {
                return Type2;
            }
            case 3: {
                return Type3;
            }
            case 4: {
                return Type4;
            }
            case 7: {
                return Type7;
            }
            case 9: {
                return Type9;
            }
            case 16: {
                return Type16;
            }
            case 17: {
                return Type17;
            }
            case 19: {
                return Type19;
            }
            case 20: {
                return Type20;
            }
            case 32: {
                return Type32;
            }
            case -128: {
                return Type128;
            }
            case -127: {
                return Type129;
            }
            case -126: {
                return Type130;
            }
            case -125: {
                return Type131;
            }
        }
        return UnknownType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<SmbiosTypeBase> parseFullSMBIOSData(File smbiosFile) {
        ArrayList<SmbiosTypeBase> list = new ArrayList<SmbiosTypeBase>();
        FilterInputStream dis = null;
        try {
            String anchor;
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(smbiosFile)));
            dis.mark(0);
            byte[] header = new byte[4];
            ((DataInputStream)dis).read(header, 0, header.length);
            switch (anchor = new String(header, StandardCharsets.UTF_8)) {
                case "_SM_": {
                    ((DataInputStream)dis).skipBytes(1);
                    break;
                }
                case "_SM3": {
                    ((DataInputStream)dis).skipBytes(2);
                    break;
                }
                default: {
                    dis.close();
                    ArrayList<SmbiosTypeBase> arrayList = list;
                    return arrayList;
                }
            }
            byte headerLength = ((DataInputStream)dis).readByte();
            dis.reset();
            dis.skip(headerLength);
            while (true) {
                dis.mark(0);
                byte type = ((DataInputStream)dis).readByte();
                if (type == 127) break;
                int length = ((DataInputStream)dis).readByte() & 0xFF;
                dis.skip(length - 2);
                byte b1 = ((DataInputStream)dis).readByte();
                byte b2 = ((DataInputStream)dis).readByte();
                length += 2;
                while (b1 != 0 || b2 != 0) {
                    b1 = b2;
                    b2 = ((DataInputStream)dis).readByte();
                    ++length;
                    if (b1 != 0 || b2 != 0) continue;
                }
                dis.reset();
                byte[] rawData = new byte[length];
                ((DataInputStream)dis).read(rawData, 0, length);
                SmbiosTypeBase instanceData = SmbiosTypeCollection.parseType(type).createSMBIOSData(rawData);
                if (instanceData == null) continue;
                instanceData.parser();
                list.add(instanceData);
            }
            ArrayList<SmbiosTypeBase> arrayList = list;
            return arrayList;
        }
        catch (Exception ioe) {
            ArrayList<SmbiosTypeBase> arrayList = list;
            return arrayList;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {
                    dis = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<SmbiosTypeBase> parseFullSMBIOSData(byte[] rawData) {
        ArrayList<SmbiosTypeBase> list = new ArrayList<SmbiosTypeBase>();
        FilterInputStream dis = null;
        try {
            String anchor;
            dis = new DataInputStream(new ByteArrayInputStream(rawData));
            dis.mark(0);
            byte[] header = new byte[4];
            ((DataInputStream)dis).read(header, 0, header.length);
            switch (anchor = new String(header, StandardCharsets.UTF_8)) {
                case "_SM_": {
                    ((DataInputStream)dis).skipBytes(1);
                    break;
                }
                case "_SM3": {
                    ((DataInputStream)dis).skipBytes(2);
                    break;
                }
                default: {
                    dis.close();
                    ArrayList<SmbiosTypeBase> arrayList = list;
                    return arrayList;
                }
            }
            byte headerLength = ((DataInputStream)dis).readByte();
            dis.reset();
            dis.skip(headerLength);
            while (true) {
                dis.mark(0);
                byte type = ((DataInputStream)dis).readByte();
                if (type == 127) break;
                byte leng = ((DataInputStream)dis).readByte();
                int length = leng & 0xFF;
                dis.skip(length - 2);
                byte b1 = ((DataInputStream)dis).readByte();
                byte b2 = ((DataInputStream)dis).readByte();
                length += 2;
                while (b1 != 0 || b2 != 0) {
                    b1 = b2;
                    b2 = ((DataInputStream)dis).readByte();
                    ++length;
                    if (b1 != 0 || b2 != 0) continue;
                }
                dis.reset();
                byte[] tempRaw = new byte[length];
                ((DataInputStream)dis).read(tempRaw, 0, length);
                SmbiosTypeBase instanceData = SmbiosTypeCollection.parseType(type).createSMBIOSData(tempRaw);
                if (instanceData == null) continue;
                instanceData.parser();
                list.add(instanceData);
            }
            ArrayList<SmbiosTypeBase> arrayList = list;
            return arrayList;
        }
        catch (IOException ioe) {
            ArrayList<SmbiosTypeBase> arrayList = list;
            return arrayList;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {
                    dis = null;
                }
            }
        }
    }

    public static final <T extends SmbiosTypeBase> List<T> castConcreteType(List<AbstractJSONPOJO> data, Class<T> clazz) {
        ArrayList<T> output = new ArrayList<T>();
        for (AbstractJSONPOJO base : data) {
            if (base.getClass() != clazz) continue;
            output.add(clazz.cast(base));
        }
        return output;
    }
}

