/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.SKUUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class SkuSuitableFwParser
extends SuitableFwParser {
    public SkuSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
    }

    @Override
    public SKUUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        File skuXML = new File(fwPackages.get(0).getParentFile().getAbsolutePath() + "/SKU.xml");
        if (!skuXML.exists()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] SKU.xml not found.");
            return null;
        }
        SKUUpdateFWInfo updateFWInfo = new SKUUpdateFWInfo();
        updateFWInfo.setBmcVendor(mcinfo.getBmcVendor());
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(skuXML);
            String productID = doc.getElementsByTagName("ID").item(0).getTextContent().replace("0x", "");
            String productName = doc.getElementsByTagName("Platform").item(0).getTextContent();
            updateFWInfo.setTargetBmcIp(this.bmcIpAddress);
            updateFWInfo.setUpdateType(UpdateType.SKU);
            updateFWInfo.setImagePath(fwPackages.get(0).getAbsolutePath());
            updateFWInfo.setTargetBMCProductID(productID);
            updateFWInfo.setTargetBMCType(productName);
            return updateFWInfo;
        }
        catch (SAXException saxe) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] SKU.xml SAX exception.", saxe);
            return null;
        }
        catch (IOException ioe) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] SKU.xml not found.", ioe);
            return null;
        }
        catch (ParserConfigurationException pce) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] SKU.xml parser error.", pce);
            return null;
        }
    }
}

