/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcinfo;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.bmcinfo.AdditionalDeviceSupport;
import Gbt.utility.bmcinfo.BMCChipID;
import Gbt.utility.bmcinfo.BMCPlatform;
import Gbt.utility.bmcinfo.BMCPlatformInfoJSONData;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.bmcinfo.PlatformName;
import Gbt.utility.bmcinfo.PlatformVendor;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class BMCInfoJSONData
extends AbstractJSONPOJO {
    private int deviceID;
    private int deviceRevision;
    private String firmwareRevision;
    private String ipmiVersion;
    private int manufacturerID;
    private String manufacturerName;
    private String productID;
    private BMCPlatform productName;
    private BMCPlatformInfoJSONData bmcPlatformInfo;
    private boolean deviceAvailable;
    private boolean providesDeviceSDRs;
    private List<AdditionalDeviceSupport> additionalDeviceSupport = new ArrayList<AdditionalDeviceSupport>();
    private List<String> auxFWRevInfo = new ArrayList<String>();
    private BMCVendor bmcVendor;

    public void setDeviceID(int deviceID) {
        this.deviceID = deviceID;
    }

    @JsonProperty(value="Device ID")
    public int getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceRevision(int deviceRevision) {
        this.deviceRevision = deviceRevision;
    }

    @JsonProperty(value="Device Revision")
    public int getDeviceRevision() {
        return this.deviceRevision;
    }

    public void setFirmwareRevision(String firmwareRevision) {
        this.firmwareRevision = firmwareRevision;
    }

    @JsonProperty(value="Firmware Revision")
    public String getFirmwareRevision() {
        return this.firmwareRevision;
    }

    public void setIpmiVersion(String ipmiVersion) {
        this.ipmiVersion = ipmiVersion;
    }

    @JsonProperty(value="IPMI Version")
    public String getIpmiVersion() {
        return this.ipmiVersion;
    }

    public void setManufacturerID(int manufacturerID) {
        this.manufacturerID = manufacturerID;
    }

    @JsonProperty(value="Manufacturer ID")
    public int getManufacturerID() {
        return this.manufacturerID;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    @JsonProperty(value="Manufacturer Name")
    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setProductID(String productID) {
        this.productID = productID;
    }

    @JsonProperty(value="Product ID")
    public String getProductID() {
        return this.productID;
    }

    public void setProductName(BMCPlatform productName) {
        this.productName = productName;
    }

    @JsonProperty(value="Platform Name")
    public BMCPlatform getProductName() {
        return this.productName;
    }

    public void setDeviceAvailable(boolean deviceAvailable) {
        this.deviceAvailable = deviceAvailable;
    }

    @JsonProperty(value="Device Available")
    public boolean isDeviceAvailable() {
        return this.deviceAvailable;
    }

    public void setProvidesDeviceSDRs(boolean providesDeviceSDRs) {
        this.providesDeviceSDRs = providesDeviceSDRs;
    }

    @JsonProperty(value="Provides Device SDRs")
    public boolean isProvidesDeviceSDRs() {
        return this.providesDeviceSDRs;
    }

    public void setAdditionalDeviceSupport(AdditionalDeviceSupport additionalDeviceSupport) {
        this.additionalDeviceSupport.add(additionalDeviceSupport);
    }

    @JsonProperty(value="Additional Device Support")
    public List<AdditionalDeviceSupport> getAdditionalDeviceSupport() {
        return this.additionalDeviceSupport;
    }

    public void setAuxFWRevInfo(String info) {
        this.auxFWRevInfo.add(info);
    }

    @JsonProperty(value="Aux Firmware Rev Info")
    public List<String> getAuxFWRevInfo() {
        return this.auxFWRevInfo;
    }

    @JsonProperty(value="BmcVendor")
    public BMCVendor getBmcVendor() {
        return this.bmcVendor;
    }

    public void setBmcVendor(BMCVendor bmcVendor) {
        this.bmcVendor = bmcVendor;
    }

    @JsonProperty(value="BmcPlatformInfo")
    public BMCPlatformInfoJSONData getBmcPlatformInfo() {
        return this.bmcPlatformInfo;
    }

    public void setBmcPlatformInfo(BMCPlatformInfoJSONData bmcPlatformInfo) {
        this.bmcPlatformInfo = bmcPlatformInfo;
    }

    public BMCChipID getBmcGen() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getChipID() != BMCChipID.Unknown) {
            return this.bmcPlatformInfo.getChipID();
        }
        return this.productName.getBmcGen();
    }

    public String getPlatformName() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getPlatformName() != PlatformName.Unknown) {
            return this.bmcPlatformInfo.getPlatformName().toString();
        }
        return this.productName.toString();
    }

    public boolean isAST2400() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getChipID() != BMCChipID.Unknown) {
            return this.bmcPlatformInfo.getChipID() == BMCChipID.AST2400;
        }
        return this.productName.getBmcGen() == BMCChipID.AST2400;
    }

    public boolean isAST2500() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getChipID() != BMCChipID.Unknown) {
            return this.bmcPlatformInfo.getChipID() == BMCChipID.AST2500;
        }
        return this.productName.getBmcGen() == BMCChipID.AST2500;
    }

    public boolean isAST2520() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getChipID() != BMCChipID.Unknown) {
            return this.bmcPlatformInfo.getChipID() == BMCChipID.AST2520;
        }
        return this.productName.getBmcGen() == BMCChipID.AST2520;
    }

    public boolean isAST2600() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getChipID() != BMCChipID.Unknown) {
            return this.bmcPlatformInfo.getChipID() == BMCChipID.AST2600;
        }
        return this.productName.getBmcGen() == BMCChipID.AST2600;
    }

    public boolean isAST2700() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getChipID() != BMCChipID.Unknown) {
            return this.bmcPlatformInfo.getChipID() == BMCChipID.AST2700;
        }
        return this.productName.getBmcGen() == BMCChipID.AST2700;
    }

    public boolean isPurley() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getPlatformName() != PlatformName.Unknown) {
            return this.bmcPlatformInfo.getPlatformName() == PlatformName.PURLEY;
        }
        return this.productName.isPurley();
    }

    public boolean isGrantley() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getPlatformName() != PlatformName.Unknown) {
            return this.bmcPlatformInfo.getPlatformName() == PlatformName.GRANTLEY;
        }
        return this.productName.isGrantley();
    }

    public boolean isIntel() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getPlatformVendor() != PlatformVendor.Unknown) {
            return this.bmcPlatformInfo.getPlatformVendor() == PlatformVendor.Intel;
        }
        return this.productName.isIntel();
    }

    public boolean isAMD() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getPlatformVendor() != PlatformVendor.Unknown) {
            return this.bmcPlatformInfo.getPlatformVendor() == PlatformVendor.AMD;
        }
        return this.productName.isAMD();
    }

    public boolean isCMC() {
        if (this.bmcPlatformInfo != null && this.bmcPlatformInfo.getPlatformName() != PlatformName.Unknown) {
            return this.bmcPlatformInfo.getPlatformName() == PlatformName.CMC_2U4N;
        }
        return this.productName.isCMC();
    }
}

