/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmcinfo;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.utility.bmcinfo.BMCChipID;
import Gbt.utility.bmcinfo.BMCGeneration;
import Gbt.utility.bmcinfo.BMCPlatformInfoJSONData;
import Gbt.utility.bmcinfo.GetBMCInfoCommand;
import Gbt.utility.bmcinfo.PlatformArch;
import Gbt.utility.bmcinfo.PlatformName;
import Gbt.utility.bmcinfo.PlatformVendor;

public enum BmcPlatformIpmiOptions implements GbtIPMIOptions<GetBMCInfoCommand.Builder>
{
    GETBMCPLATFORM(0, "Get platform", 17);

    private static final String GET_BMCPLATFORM_ITEM = "Get platform";
    private static final byte NetFn = 46;
    private final int optionCode;
    private final String item;
    private final byte cmd;

    private BmcPlatformIpmiOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 46;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(GetBMCInfoCommand.Builder commandArgs) {
        return new byte[]{10, 60, 0, 23};
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        BMCPlatformInfoJSONData platformInfo = new BMCPlatformInfoJSONData();
        byte[] response = gbtResponseData.getAllResponseData();
        try {
            platformInfo.setGeneration(BMCGeneration.parse(response[3]));
            platformInfo.setChipID(BMCChipID.parse(response[3]));
            platformInfo.setArch(PlatformArch.parse(response[4]));
            platformInfo.setPlatformVendor(PlatformVendor.parse(response[4]));
            platformInfo.setPlatformName(PlatformName.parse(response[4]));
        }
        catch (Exception e) {
            platformInfo.setGeneration(BMCGeneration.Unknown);
            platformInfo.setChipID(BMCChipID.Unknown);
            platformInfo.setArch(PlatformArch.Unknown);
            platformInfo.setPlatformVendor(PlatformVendor.Unknown);
            platformInfo.setPlatformName(PlatformName.Unknown);
        }
        return platformInfo;
    }
}

