/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmclanconfig;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;

public enum BMCLanConfigAuthType {
    NULL("NULL", 0),
    NONE("NONE", 1),
    MD2("MD2", 2),
    MD5("MD5", 4),
    RESERVED("RESERVED", 8),
    PASSWORD("PASSWORD", 16),
    OEM("OEM", 32);

    private static final byte NULL_BYTE = 0;
    private static final byte NONE_BYTE = 1;
    private static final byte MD2_BYTE = 2;
    private static final byte MD5_BYTE = 4;
    private static final byte RESERVED_BYTE = 8;
    private static final byte PASSWORD_BYTE = 16;
    private static final byte OEM_BYTE = 32;
    private static final String NULL_ITEM = "NULL";
    private static final String NONE_ITEM = "NONE";
    private static final String MD2_ITEM = "MD2";
    private static final String MD5_ITEM = "MD5";
    private static final String RESERVED_ITEM = "RESERVED";
    private static final String PASSWORD_ITEM = "PASSWORD";
    private static final String OEM_ITEM = "OEM";
    private final String item;
    private final byte matchByte;

    private BMCLanConfigAuthType(String item, byte matchByte) {
        this.item = item;
        this.matchByte = matchByte;
    }

    public byte getMatchByte() {
        return this.matchByte;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final List<BMCLanConfigAuthType> parseSupportedTypesByRawByte(byte rawByte) {
        ArrayList<BMCLanConfigAuthType> output = new ArrayList<BMCLanConfigAuthType>();
        for (int i = 0; i < 6; ++i) {
            byte matchByte = (byte)(rawByte & 0xFFFFFFFF & 1 << i);
            BMCLanConfigAuthType support = BMCLanConfigAuthType.parseByMatchByte(matchByte);
            if (support == NULL) continue;
            output.add(support);
        }
        return output;
    }

    public static final BMCLanConfigAuthType parseByMatchByte(byte matchByte) {
        switch (matchByte) {
            case 1: {
                return NONE;
            }
            case 2: {
                return MD2;
            }
            case 4: {
                return MD5;
            }
            case 8: {
                return RESERVED;
            }
            case 16: {
                return PASSWORD;
            }
            case 32: {
                return OEM;
            }
        }
        return NULL;
    }
}

