/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bmclanconfig;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmclanconfig.BMCLanConfigData;
import Gbt.utility.bmclanconfig.BMCLanConfigIPMIOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public final class BMCLanConfigCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "lanprint";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected BMCLanConfigCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, this.getCommandName(), this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to " + (((Builder)this.commandArgs).getConfig ? "get" : "set") + " BMC LAN configurations.");
        BMCInfoJSONData bmcInfo = this.ipmiReceiver.getBmcInfo(handle, ((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID);
        if (bmcInfo == null) {
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Get BMC info fail."));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC info fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
            return false;
        }
        List<BMCLanConfigIPMIOptions> options = BMCLanConfigIPMIOptions.getFullOptions(((Builder)this.commandArgs).getConfig, bmcInfo, ((Builder)this.commandArgs).bmcLanConfigData);
        BMCLanConfigData bmcLanConfigData = new BMCLanConfigData();
        for (BMCLanConfigIPMIOptions option : options) {
            Method[] methods;
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + (((Builder)this.commandArgs).getConfig ? "Getting" : "Setting") + " " + option.getItem());
            AbstractJSONPOJO responseData = this.ipmiReceiver.sendIPMIRawCommand(handle, option, this.commandArgs, this.getCommandName(), this.commandID);
            if (responseData instanceof NullJSONData) {
                NullJSONData temp = responseData.castConcreteJSON(NullJSONData.class);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + option.getItem() + " fail.");
                    this.commandResults.add(temp);
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                this.commandResults.add(temp);
            }
            if (!((Builder)this.commandArgs).getConfig) continue;
            for (Method method : methods = bmcLanConfigData.getClass().getMethods()) {
                if (!method.isAnnotationPresent(JsonProperty.class)) continue;
                try {
                    Object fieldValue = method.invoke((Object)responseData, new Object[0]);
                    if (fieldValue == null) continue;
                    String jsonPropertyName = method.getAnnotation(JsonProperty.class).value();
                    String fieldName = jsonPropertyName.substring(0, 1).toLowerCase() + jsonPropertyName.substring(1);
                    PropertyDescriptor propertyOrder = new PropertyDescriptor(fieldName, bmcLanConfigData.getClass());
                    propertyOrder.getWriteMethod().invoke((Object)bmcLanConfigData, fieldValue);
                }
                catch (IntrospectionException | IllegalAccessException | InvocationTargetException ies) {
                    this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Error for parse the pojo field values", ies);
                    this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
                    return false;
                }
            }
        }
        if (((Builder)this.commandArgs).getConfig) {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, bmcLanConfigData.toString());
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get BMC LAN configuration success.");
            this.commandResults.add(bmcLanConfigData);
        } else {
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.INFO, this.commandID, JacksonCommonUtil.getUtil().getPrettyPrintString(this.commandResults));
            this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set BMC LAN configuration success.");
        }
        this.ipmiReceiver.closeIPMIConnection(handle, this.getCommandName(), this.commandID);
        this.loggerWriter.appendPath(this.getCommandName()).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
        return true;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private byte channel = 1;
        private BMCLanConfigData bmcLanConfigData;
        private boolean getConfig = true;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null && this.args.length == 1) {
                this.channel = GbtCommonConverters.stringToByte(this.args[0]);
            }
            return this.getConfig || this.bmcLanConfigData != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public BMCLanConfigCommand build() {
            return new BMCLanConfigCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setChannel(byte channel) {
            this.channel = channel;
            return this.getThis();
        }

        public Builder setBmcLanConfigData(BMCLanConfigData bmcLanConfigData) {
            this.bmcLanConfigData = bmcLanConfigData;
            return this.getThis();
        }

        public Builder setAction(boolean action) {
            this.getConfig = action;
            return this.getThis();
        }

        public byte getChannel() {
            return this.channel;
        }

        public BMCLanConfigData getBmcLanConfigData() {
            return this.bmcLanConfigData;
        }
    }
}

