/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.bootoptions;

import com.fasterxml.jackson.annotation.JsonValue;

public enum BootOptions {
    None(0, "None"),
    PXE(4, "PXE"),
    Disk(8, "HDD disk"),
    Safe(12, "Safe mode"),
    Diag(16, "Diag mode"),
    CDROM(20, "CD/ROM"),
    BIOS(24, "BIOS setup menu"),
    VMFloppy(28, "Virtual floppy"),
    VMCDROM(36, "Virtual CD/ROM"),
    Floppy(60, "Floppy");

    private final byte optionCode;
    private final String optionName;

    private BootOptions(byte optionCode, String optionName) {
        this.optionCode = optionCode;
        this.optionName = optionName;
    }

    public byte getOptionsCode() {
        return this.optionCode;
    }

    @JsonValue
    public String toString() {
        return this.optionName;
    }

    public static final BootOptions parserOptions(String optionName) {
        if (optionName == null) {
            return None;
        }
        switch (optionName) {
            case "pxe": {
                return PXE;
            }
            case "disk": {
                return Disk;
            }
            case "safe": {
                return Safe;
            }
            case "diag": {
                return Diag;
            }
            case "cdrom": {
                return CDROM;
            }
            case "bios": {
                return BIOS;
            }
            case "vmfloppy": {
                return VMFloppy;
            }
            case "vmcdrom": {
                return VMCDROM;
            }
            case "floppy": {
                return Floppy;
            }
        }
        return None;
    }
}

