/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.monitor;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.monitor.MonitorMemoryUsage;

public class MonitorMemoryUsageThread
extends Thread {
    private volatile boolean running = true;
    private AbstractLoggerWriter loggerWriter;
    private String COMMAND_NAME = "monitor";
    private String COMMAND_ID = "monitor";
    private long threadId;
    private long interval;
    private boolean showAll = false;
    private GbtLogLevel logLevel = GbtLogLevel.INFO;

    public void setloggerWriter(AbstractLoggerWriter loggerWriter) {
        this.loggerWriter = loggerWriter;
    }

    public void setCommandName(String command_name) {
        this.COMMAND_NAME = command_name;
    }

    public void setCommandId(String command_id) {
        this.COMMAND_ID = command_id;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public void setLogLevel(GbtLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void run() {
        this.loggerWriter.appendPath(this.COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.COMMAND_ID, "<=================Monitor Memory Usage Thread Start=================>");
        while (this.running) {
            MonitorMemoryUsage memTest = new MonitorMemoryUsage();
            if (this.showAll) {
                memTest.printThreadMemoryUsage(this.loggerWriter, this.COMMAND_NAME, this.COMMAND_ID, this.logLevel);
            }
            memTest.printNowThreadMemoryUsage(this.loggerWriter, this.COMMAND_NAME, this.COMMAND_ID, this.logLevel, this.threadId);
            memTest.printMemoryInfo(this.loggerWriter, this.COMMAND_NAME, this.COMMAND_ID, this.logLevel);
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.loggerWriter.appendPath(this.COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.COMMAND_ID, "<=================Monitor Memory Usage Thread End=================>");
        this.running = false;
    }
}

